/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.audio.openal;

import java.beans.ConstructorProperties;
import org.achtern.AchternEngine.core.audio.openal.Audio;
import org.achtern.AchternEngine.core.audio.openal.binding.AudioPlayer;
import org.achtern.AchternEngine.core.math.Vector3f;
import org.achtern.AchternEngine.core.scenegraph.entity.QuickEntity;

public class AudioListener
extends QuickEntity
implements Audio {
    protected Vector3f velocity;
    protected AudioPlayer audioPlayer;

    public AudioListener() {
        this(Vector3f.ZERO.get(), null);
    }

    public void update(float delta) {
        this.getAudioPlayer().getDataBinder().upload(this);
    }

    public void attached() {
        this.setAudioPlayer(this.getEngine().getBindingProvider().getAudioBindingProvider().getAudioPlayer());
    }

    public Vector3f getUp() {
        return this.getTransform().getTransformedRotation().getUp();
    }

    public Vector3f getForward() {
        return this.getTransform().getTransformedRotation().getForward();
    }

    public Vector3f getPosition() {
        return this.getTransform().getTransformedPosition();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AudioListener)) {
            return false;
        }
        AudioListener other = (AudioListener)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Vector3f this$velocity = this.getVelocity();
        Vector3f other$velocity = other.getVelocity();
        if (this$velocity == null ? other$velocity != null : !((Object)this$velocity).equals(other$velocity)) {
            return false;
        }
        AudioPlayer this$audioPlayer = this.getAudioPlayer();
        AudioPlayer other$audioPlayer = other.getAudioPlayer();
        return !(this$audioPlayer == null ? other$audioPlayer != null : !this$audioPlayer.equals(other$audioPlayer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AudioListener;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Vector3f $velocity = this.getVelocity();
        result = result * 59 + ($velocity == null ? 0 : $velocity.hashCode());
        AudioPlayer $audioPlayer = this.getAudioPlayer();
        result = result * 59 + ($audioPlayer == null ? 0 : $audioPlayer.hashCode());
        return result;
    }

    public Vector3f getVelocity() {
        return this.velocity;
    }

    public AudioPlayer getAudioPlayer() {
        return this.audioPlayer;
    }

    public void setVelocity(Vector3f velocity) {
        this.velocity = velocity;
    }

    public void setAudioPlayer(AudioPlayer audioPlayer) {
        this.audioPlayer = audioPlayer;
    }

    public String toString() {
        return "AudioListener(velocity=" + this.getVelocity() + ", audioPlayer=" + this.getAudioPlayer() + ")";
    }

    @ConstructorProperties(value={"velocity", "audioPlayer"})
    public AudioListener(Vector3f velocity, AudioPlayer audioPlayer) {
        this.velocity = velocity;
        this.audioPlayer = audioPlayer;
    }
}

