/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.audio.openal.trigger;

import org.achtern.AchternEngine.core.audio.openal.AudioSource;
import org.achtern.AchternEngine.core.audio.openal.AudioSourceState;
import org.achtern.AchternEngine.core.audio.openal.trigger.AudioTrigger;
import org.achtern.AchternEngine.core.input.Key;
import org.achtern.AchternEngine.core.input.event.listener.KeyListener;
import org.achtern.AchternEngine.core.input.event.listener.trigger.KeyTrigger;
import org.achtern.AchternEngine.core.input.event.payload.KeyEvent;
import org.achtern.AchternEngine.core.input.inputmap.KeyMap;

public class KeyboardAudioTrigger
implements AudioTrigger,
KeyListener {
    protected Key playKey;
    protected Key pauseKey;
    protected Key stopKey;
    protected AudioSourceState next = AudioSourceState.STOPPED;

    public KeyboardAudioTrigger(KeyMap keyMap, Key playKey, Key pauseKey, Key stopKey) {
        this.playKey = playKey;
        this.pauseKey = pauseKey;
        this.stopKey = stopKey;
        keyMap.register(new KeyTrigger(this.getPlayKey()), (KeyListener)this).register(new KeyTrigger(this.getPauseKey()), (KeyListener)this).register(new KeyTrigger(this.getStopKey()), (KeyListener)this);
    }

    public KeyboardAudioTrigger(KeyMap keyMap) {
        this(keyMap, Key.L, Key.K, Key.J);
    }

    public AudioSourceState next(AudioSource as) {
        return this.getNext();
    }

    public void onAction(KeyEvent event) {
        Key eKey = event.getKey();
        if (eKey.equals((Object)this.getPlayKey())) {
            this.setNext(AudioSourceState.PLAYING);
        } else if (eKey.equals((Object)this.getPauseKey())) {
            this.setNext(AudioSourceState.PAUSED);
        } else if (eKey.equals((Object)this.getStopKey())) {
            this.setNext(AudioSourceState.STOPPED);
        }
    }

    protected Key getPlayKey() {
        return this.playKey;
    }

    protected Key getPauseKey() {
        return this.pauseKey;
    }

    protected Key getStopKey() {
        return this.stopKey;
    }

    protected AudioSourceState getNext() {
        return this.next;
    }

    protected void setNext(AudioSourceState next) {
        this.next = next;
    }
}

