/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.audio.openal.trigger;

import java.beans.ConstructorProperties;
import org.achtern.AchternEngine.core.audio.openal.AudioSource;
import org.achtern.AchternEngine.core.audio.openal.AudioSourceState;
import org.achtern.AchternEngine.core.audio.openal.trigger.AudioTrigger;
import org.achtern.AchternEngine.core.math.Vector3f;
import org.achtern.AchternEngine.core.scenegraph.Node;

public class ProximityAudioTrigger
implements AudioTrigger {
    protected Node target;
    protected float maxDistance;
    protected AudioSourceState onExit = AudioSourceState.PAUSED;

    public ProximityAudioTrigger(Node target) {
        this(target, 10.0f, AudioSourceState.PAUSED);
    }

    public AudioSourceState next(AudioSource as) {
        Vector3f t;
        Vector3f c = as.getPosition();
        Vector3f subtracted = c.sub(t = this.target.getTransform().getPosition());
        if (subtracted.getX() + subtracted.getY() + subtracted.getZ() > this.maxDistance) {
            return this.onExit;
        }
        if (Vector3f.distance(c, t) > this.maxDistance) {
            return this.onExit;
        }
        return AudioSourceState.PLAYING;
    }

    @ConstructorProperties(value={"target", "maxDistance", "onExit"})
    public ProximityAudioTrigger(Node target, float maxDistance, AudioSourceState onExit) {
        this.target = target;
        this.maxDistance = maxDistance;
        this.onExit = onExit;
    }

    public Node getTarget() {
        return this.target;
    }

    public void setTarget(Node target) {
        this.target = target;
    }

    public float getMaxDistance() {
        return this.maxDistance;
    }

    public AudioSourceState getOnExit() {
        return this.onExit;
    }

    public void setOnExit(AudioSourceState onExit) {
        this.onExit = onExit;
    }
}

