/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.bootstrap;

import java.io.IOException;
import java.util.Properties;

public class BuildInfo {
    public static final String ENGINE_VERSION = "0.4";
    private static BuildInfo instance;
    protected String branch;
    protected String describe;
    protected String describeShort;
    protected String commitId;
    protected String buildUserName;
    protected String buildUserEmail;
    protected String buildTime;
    protected String commitUserName;
    protected String commitUserEmail;
    protected String commitMessageShort;
    protected String commitMessageFull;
    protected String commitTime;

    public static BuildInfo load() throws IOException {
        if (instance == null) {
            Properties properties = new Properties();
            properties.load(BuildInfo.class.getClassLoader().getResourceAsStream("git.properties"));
            instance = new BuildInfo(properties);
        }
        return instance;
    }

    public static String get() {
        try {
            return BuildInfo.load().toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "Error loading git.properties";
        }
    }

    private BuildInfo(Properties properties) {
        this.branch = properties.get("git.branch").toString();
        this.describe = properties.get("git.commit.id.describe").toString();
        this.describeShort = properties.get("git.commit.id.describe-short").toString();
        this.commitId = properties.get("git.commit.id").toString();
        this.buildUserName = properties.get("git.build.user.name").toString();
        this.buildUserEmail = properties.get("git.build.user.email").toString();
        this.buildTime = properties.get("git.build.time").toString();
        this.commitUserName = properties.get("git.commit.user.name").toString();
        this.commitUserEmail = properties.get("git.commit.user.email").toString();
        this.commitMessageShort = properties.get("git.commit.message.short").toString();
        this.commitMessageFull = properties.get("git.commit.message.full").toString();
        this.commitTime = properties.get("git.commit.time").toString();
    }

    public String toString() {
        return "AchternEngine v0.4;\nBuild on " + this.getBuildTime() + " by " + this.getBuildUserName() + " git commit = " + this.getDescribe();
    }

    public String getBranch() {
        return this.branch;
    }

    public String getDescribe() {
        return this.describe;
    }

    public String getDescribeShort() {
        return this.describeShort;
    }

    public String getCommitId() {
        return this.commitId;
    }

    public String getBuildUserName() {
        return this.buildUserName;
    }

    public String getBuildUserEmail() {
        return this.buildUserEmail;
    }

    public String getBuildTime() {
        return this.buildTime;
    }

    public String getCommitUserName() {
        return this.commitUserName;
    }

    public String getCommitUserEmail() {
        return this.commitUserEmail;
    }

    public String getCommitMessageShort() {
        return this.commitMessageShort;
    }

    public String getCommitMessageFull() {
        return this.commitMessageFull;
    }

    public String getCommitTime() {
        return this.commitTime;
    }
}

