/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.math;

import org.achtern.AchternEngine.core.math.Quaternion;
import org.achtern.AchternEngine.core.math.Vector2f;

public class Vector3f
implements Cloneable {
    public static final Vector3f ZERO = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vector3f UNIT_X = new Vector3f(1.0f, 0.0f, 0.0f);
    public static final Vector3f UNIT_Y = new Vector3f(0.0f, 1.0f, 0.0f);
    public static final Vector3f UNIT_Z = new Vector3f(0.0f, 0.0f, 1.0f);
    public static final Vector3f ONE = new Vector3f(1.0f, 1.0f, 1.0f);
    protected boolean locked = false;
    private float x;
    private float y;
    private float z;

    public static float distance(Vector3f p, Vector3f q) {
        return p.euclidean(q);
    }

    public static Vector3f lerp(Vector3f p, Vector3f q, float factor) {
        return p.lerp(q, factor);
    }

    public Vector3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3f(float v) {
        this(v, v, v);
    }

    public Vector3f(Vector3f v) {
        this(v.getX(), v.getY(), v.getZ());
    }

    public Vector3f lock() {
        this.locked = true;
        return this;
    }

    public Vector3f unlock() {
        this.locked = false;
        return this;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public float euclidean(Vector3f v) {
        return (float)Math.sqrt((this.getX() - v.getX()) * (this.getX() - v.getX()) + (this.getY() - v.getY()) * (this.getY() - v.getY()) + (this.getZ() - v.getZ()) * (this.getZ() - v.getZ()));
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public float dot(Vector3f v) {
        return this.x * v.getX() + this.y * v.getY() + this.z * v.getZ();
    }

    public Vector3f cross(Vector3f v) {
        float _x = this.y * v.getZ() - this.z * v.getY();
        float _y = this.z * v.getX() - this.x * v.getZ();
        float _z = this.x * v.getY() - this.y * v.getX();
        return new Vector3f(_x, _y, _z);
    }

    public void normalize() {
        float l = this.length();
        this.x /= l;
        this.y /= l;
        this.z /= l;
    }

    public Vector3f normalized() {
        float l = this.length();
        return new Vector3f(this.x / l, this.y / l, this.z / l);
    }

    public Vector3f lerp(Vector3f dest, float factor) {
        return dest.sub(this).mul(factor).add(this);
    }

    public Vector3f rotate(Vector3f axis, float angle) {
        return this.rotate(new Quaternion().initRotation(axis, angle));
    }

    public Vector3f rotate(Quaternion q) {
        Quaternion conjugate = q.conjugate();
        Quaternion w = q.mul(this).mul(conjugate);
        return new Vector3f(w.getX(), w.getY(), w.getZ());
    }

    public float max() {
        return Math.max(this.getX(), Math.max(this.getY(), this.getZ()));
    }

    public Vector3f add(Vector3f v) {
        return new Vector3f(this.x + v.getX(), this.y + v.getY(), this.z + v.getZ());
    }

    public Vector3f add(float v) {
        return new Vector3f(this.x + v, this.y + v, this.z + v);
    }

    public Vector3f addLocal(Vector3f v) {
        this.x += v.getX();
        this.y += v.getY();
        this.z += v.getZ();
        return this;
    }

    public Vector3f addLocal(float v) {
        this.x += v;
        this.y += v;
        this.z += v;
        return this;
    }

    public Vector3f sub(Vector3f v) {
        return new Vector3f(this.x - v.getX(), this.y - v.getY(), this.z - v.getZ());
    }

    public Vector3f sub(float v) {
        return new Vector3f(this.x - v, this.y - v, this.z - v);
    }

    public Vector3f subLocal(Vector3f v) {
        this.x -= v.getX();
        this.y -= v.getY();
        this.z -= v.getZ();
        return this;
    }

    public Vector3f subLocal(float v) {
        this.x -= v;
        this.y -= v;
        this.z -= v;
        return this;
    }

    public Vector3f mul(Vector3f v) {
        return new Vector3f(this.x * v.getX(), this.y * v.getY(), this.z * v.getZ());
    }

    public Vector3f mul(float v) {
        return new Vector3f(this.x * v, this.y * v, this.z * v);
    }

    public Vector3f multLocal(Vector3f v) {
        this.x *= v.getX();
        this.y *= v.getY();
        this.z *= v.getZ();
        return this;
    }

    public Vector3f multLocal(float v) {
        this.x *= v;
        this.y *= v;
        this.z *= v;
        return this;
    }

    public Vector3f div(Vector3f v) {
        return new Vector3f(this.x / v.getX(), this.y / v.getY(), this.z / v.getZ());
    }

    public Vector3f div(float v) {
        return new Vector3f(this.x / v, this.y / v, this.z / v);
    }

    public Vector3f abs() {
        return new Vector3f(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
    }

    public Vector3f clamp(float c) {
        Vector3f r = new Vector3f(this);
        r.clampLocal(c);
        return r;
    }

    public Vector3f clampLocal(float c) {
        if (this.getX() > c) {
            this.setX(c);
        }
        if (this.getY() > c) {
            this.setY(c);
        }
        if (this.getZ() > c) {
            this.setZ(c);
        }
        return this;
    }

    public Vector2f getXY() {
        return new Vector2f(this.getX(), this.getY());
    }

    public Vector2f getYZ() {
        return new Vector2f(this.getY(), this.getZ());
    }

    public Vector2f getXZ() {
        return new Vector2f(this.getX(), this.getZ());
    }

    public Vector2f getYX() {
        return new Vector2f(this.getY(), this.getX());
    }

    public Vector2f getZY() {
        return new Vector2f(this.getZ(), this.getY());
    }

    public Vector2f getZX() {
        return new Vector2f(this.getZ(), this.getX());
    }

    public Vector3f set(float x, float y, float z) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        return this;
    }

    public Vector3f set(Vector3f v) {
        this.setX(v.getX());
        this.setY(v.getY());
        this.setZ(v.getZ());
        return this;
    }

    public void setX(float x) {
        if (this.locked) {
            throw new IllegalAccessError("Vector is locked!");
        }
        this.x = x;
    }

    public void setY(float y) {
        if (this.locked) {
            throw new IllegalAccessError("Vector is locked!");
        }
        this.y = y;
    }

    public void setZ(float z) {
        if (this.locked) {
            throw new IllegalAccessError("Vector is locked!");
        }
        this.z = z;
    }

    public boolean equals(Vector3f v) {
        return this.x == v.getX() && this.y == v.getY() && this.z == v.getZ();
    }

    public boolean isNullVector() {
        return this.getXY().isNullVector() && this.getZ() == 0.0f;
    }

    public boolean equals(Object obj) {
        return obj instanceof Vector3f && this.equals((Vector3f)obj);
    }

    public String toString() {
        return "(" + this.getX() + "/" + this.getY() + "/" + this.getZ() + ")";
    }

    public Vector3f get() {
        return new Vector3f(this);
    }

    public Vector3f clone() throws CloneNotSupportedException {
        try {
            return (Vector3f)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }
}

