/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.rendering;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.achtern.AchternEngine.core.Window;
import org.achtern.AchternEngine.core.bootstrap.GraphicsBindingProvider;
import org.achtern.AchternEngine.core.rendering.Color;
import org.achtern.AchternEngine.core.rendering.PassFilter;
import org.achtern.AchternEngine.core.rendering.RenderEngine;
import org.achtern.AchternEngine.core.rendering.RenderPass;
import org.achtern.AchternEngine.core.rendering.RenderTarget;
import org.achtern.AchternEngine.core.rendering.binding.DataBinder;
import org.achtern.AchternEngine.core.rendering.drawing.DrawStrategy;
import org.achtern.AchternEngine.core.rendering.drawing.DrawStrategyFactory;
import org.achtern.AchternEngine.core.rendering.shadow.BasicShadowRenderer;
import org.achtern.AchternEngine.core.rendering.sorting.NoShadowFirstSorter;
import org.achtern.AchternEngine.core.rendering.state.BlendFunction;
import org.achtern.AchternEngine.core.rendering.state.DepthFunction;
import org.achtern.AchternEngine.core.rendering.state.Face;
import org.achtern.AchternEngine.core.rendering.state.Feature;
import org.achtern.AchternEngine.core.rendering.state.FrontFaceMethod;
import org.achtern.AchternEngine.core.rendering.state.RenderEngineState;
import org.achtern.AchternEngine.core.scenegraph.Node;
import org.achtern.AchternEngine.core.scenegraph.entity.Camera;
import org.achtern.AchternEngine.core.scenegraph.entity.GlobalEntity;
import org.achtern.AchternEngine.core.scenegraph.entity.renderpasses.light.AmbientLight;
import org.achtern.AchternEngine.core.scenegraph.entity.renderpasses.light.BaseLight;
import org.achtern.AchternEngine.core.util.CommonDataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicRenderEngine
extends CommonDataStore
implements RenderEngine {
    public static final Logger LOGGER = LoggerFactory.getLogger(RenderEngine.class);
    protected RenderEngineState state;
    protected DataBinder dataBinder;
    protected RenderTarget renderTarget;
    protected List<RenderPass> renderPasses;
    protected RenderPass activePass;
    protected List<PassFilter> passFilters;
    protected Camera camera;
    protected DrawStrategy drawStrategy;
    public boolean first;
    protected Map<Class, GlobalEntity> globalEntities;

    public BasicRenderEngine(GraphicsBindingProvider graphicsBindingProvider) {
        this.state = graphicsBindingProvider.getRenderEngineState();
        this.dataBinder = graphicsBindingProvider.getDataBinder();
        this.setRenderTarget(Window.get());
        this.renderPasses = new ArrayList<RenderPass>();
        this.passFilters = new ArrayList<PassFilter>();
        this.drawStrategy = DrawStrategyFactory.get(DrawStrategyFactory.Common.SOLID);
        this.globalEntities = new HashMap<Class, GlobalEntity>();
        this.setupStates();
        this.addPassFilter(new BasicShadowRenderer());
    }

    @Override
    public void render(Node node) {
        this.render(node, true);
    }

    @Override
    public void render(Node node, boolean clear) {
        if (this.getRenderTarget() != null) {
            this.getRenderTarget().bindAsRenderTarget(this.getDataBinder());
        }
        if (clear) {
            this.state.clear(true, true, false);
        }
        if (this.renderPasses.isEmpty()) {
            LOGGER.debug("No render passes. Skip render!");
            return;
        }
        this.activePass = this.renderPasses.get(0);
        LOGGER.trace("Rendering Pass of type: {}", this.activePass.getClass());
        boolean skip = true;
        if (this.hasShadow(this.activePass)) {
            LOGGER.debug("First Pass has shadow, sorting...");
            Collections.sort(this.renderPasses, new NoShadowFirstSorter());
            this.activePass = this.renderPasses.get(0);
            if (this.hasShadow(this.activePass)) {
                LOGGER.info("Using own Ambient Pass with Color(0.01f, 0.01f, 0.01f), to avoid shadow render loss");
                this.activePass = new AmbientLight(new Color(0.01f, 0.01f, 0.01f));
                skip = false;
            }
        }
        this.getDataBinder().bind(this.activePass.getShader());
        this.first = true;
        node.render(this);
        this.first = false;
        for (RenderPass pass : this.renderPasses) {
            if (skip) {
                skip = false;
                continue;
            }
            this.activePass = pass;
            for (PassFilter filter : this.passFilters) {
                filter.pre(node, pass, this);
            }
            this.state.enable(Feature.BLEND);
            this.state.setBlendFunction(BlendFunction.ONE, BlendFunction.ONE);
            this.state.enableDepthWrite(false);
            this.state.setDepthFunction(DepthFunction.EQUAL);
            LOGGER.trace("Rendering Pass of type: {}", this.activePass.getClass());
            this.getDataBinder().bind(pass.getShader());
            node.render(this);
            this.state.setDepthFunction(DepthFunction.LESS);
            this.state.enableDepthWrite(true);
            this.state.disable(Feature.BLEND);
            for (PassFilter filter : this.passFilters) {
                filter.post(node, pass, this);
            }
        }
    }

    @Override
    public void addRenderPass(RenderPass pass) {
        this.renderPasses.add(pass);
    }

    @Override
    public void removeRenderPass(RenderPass pass) {
        this.renderPasses.remove(pass);
    }

    @Override
    public RenderPass getActiveRenderPass() {
        return this.activePass;
    }

    @Override
    public void setActiveRenderPass(RenderPass active) {
        this.activePass = active;
    }

    @Override
    public void addPassFilter(PassFilter filter) {
        this.passFilters.add(filter);
        filter.init(this);
    }

    @Override
    public boolean removePassFilter(PassFilter filter) {
        return this.passFilters.remove(filter);
    }

    @Override
    public void addGlobal(GlobalEntity entity) {
        this.globalEntities.put(entity.getObject().getClass(), entity);
    }

    @Override
    public void removeGlobal(GlobalEntity entity) {
        this.globalEntities.remove(entity.getObject().getClass());
    }

    @Override
    public <T> GlobalEntity<T> getGlobal(Class<? extends T> type) {
        return this.globalEntities.get(type);
    }

    protected void setupStates() {
        this.state.setClearColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        this.state.setFrontFace(FrontFaceMethod.CLOCKWISE);
        this.state.enable(Feature.CULL_FACE);
        this.state.cullFace(Face.BACK);
        this.state.enable(Feature.DEPTH_TEST);
        this.state.setDepthFunction(DepthFunction.LESS);
        this.state.enable(Feature.DEPTH_CLAMP);
        this.state.enable(Feature.TEXTURE_2D);
    }

    protected boolean hasShadow(RenderPass pass) {
        return pass instanceof BaseLight && ((BaseLight)pass).getShadowInfo() != null;
    }

    @Override
    public RenderEngineState getState() {
        return this.state;
    }

    @Override
    public DataBinder getDataBinder() {
        return this.dataBinder;
    }

    @Override
    public RenderTarget getRenderTarget() {
        return this.renderTarget;
    }

    @Override
    public void setRenderTarget(RenderTarget renderTarget) {
        this.renderTarget = renderTarget;
    }

    @Override
    public Camera getCamera() {
        return this.camera;
    }

    @Override
    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    @Override
    public DrawStrategy getDrawStrategy() {
        return this.drawStrategy;
    }

    @Override
    public void setDrawStrategy(DrawStrategy drawStrategy) {
        this.drawStrategy = drawStrategy;
    }
}

