/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.rendering;

import org.achtern.AchternEngine.core.rendering.Color;
import org.achtern.AchternEngine.core.rendering.shader.forward.ShaderSuit;
import org.achtern.AchternEngine.core.rendering.shader.forward.suits.phong.PhongShaderSuit;
import org.achtern.AchternEngine.core.rendering.texture.Texture;
import org.achtern.AchternEngine.core.resource.ResourceLoader;
import org.achtern.AchternEngine.core.util.CommonDataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Material
extends CommonDataStore {
    public static final Logger LOGGER = LoggerFactory.getLogger(Material.class);
    public static Texture DEFAULT_NORMAL;
    public static Texture MISSING_TEXTURE;
    protected boolean wireframe = false;
    protected ShaderSuit shader;

    public Material(ShaderSuit shader) {
        this.shader = shader;
        this.addTexture("normalMap", DEFAULT_NORMAL);
    }

    public Material() {
        this(PhongShaderSuit.get());
    }

    public Texture getTexture(String name) {
        Texture r = super.getTexture(name);
        if (r != null) {
            return r;
        }
        this.addTexture(name, MISSING_TEXTURE);
        return MISSING_TEXTURE;
    }

    public void setColor(Color color) {
        this.addColor("color", color);
    }

    public Color getColor() {
        Color c = this.getColor("color");
        if (c == null) {
            return Color.WHITE;
        }
        return c;
    }

    public void asWireframe(boolean wireframe) {
        this.wireframe = wireframe;
    }

    public boolean isWireframe() {
        return this.wireframe;
    }

    public ShaderSuit getShader() {
        return this.shader;
    }

    public void setShader(ShaderSuit shader) {
        this.shader = shader;
    }

    static {
        try {
            DEFAULT_NORMAL = ResourceLoader.getTexture("default_normal.jpg");
            MISSING_TEXTURE = ResourceLoader.getTexture("missing.jpg");
        }
        catch (Exception e) {
            LOGGER.error("BREAK IN THE SPACETIME! MISSING BUNDLED TEXTURE!", (Throwable)e);
        }
    }
}

