/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.rendering;

import java.beans.ConstructorProperties;
import org.achtern.AchternEngine.core.math.Vector2f;
import org.achtern.AchternEngine.core.math.Vector3f;

public class Vertex {
    public static final int SIZE = 11;
    protected Vector3f pos;
    protected Vector2f texCor;
    protected Vector3f normal;
    protected Vector3f tangent;

    public Vertex(Vector3f pos) {
        this(pos, new Vector2f(0.0f, 0.0f));
    }

    public Vertex(Vector3f pos, Vector2f texCor, Vector3f normal) {
        this(pos, texCor, normal, null);
    }

    public Vertex(Vector3f pos, Vector2f texCor) {
        this(pos, texCor, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f));
    }

    public Vertex(float x, float y, float z, float texX, float texY) {
        this(new Vector3f(x, y, z), new Vector2f(texX, texY));
    }

    @ConstructorProperties(value={"pos", "texCor", "normal", "tangent"})
    public Vertex(Vector3f pos, Vector2f texCor, Vector3f normal, Vector3f tangent) {
        this.pos = pos;
        this.texCor = texCor;
        this.normal = normal;
        this.tangent = tangent;
    }

    public Vector3f getPos() {
        return this.pos;
    }

    public Vector2f getTexCor() {
        return this.texCor;
    }

    public Vector3f getNormal() {
        return this.normal;
    }

    public Vector3f getTangent() {
        return this.tangent;
    }

    public void setPos(Vector3f pos) {
        this.pos = pos;
    }

    public void setTexCor(Vector2f texCor) {
        this.texCor = texCor;
    }

    public void setNormal(Vector3f normal) {
        this.normal = normal;
    }

    public void setTangent(Vector3f tangent) {
        this.tangent = tangent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Vertex)) {
            return false;
        }
        Vertex other = (Vertex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Vector3f this$pos = this.getPos();
        Vector3f other$pos = other.getPos();
        if (this$pos == null ? other$pos != null : !((Object)this$pos).equals(other$pos)) {
            return false;
        }
        Vector2f this$texCor = this.getTexCor();
        Vector2f other$texCor = other.getTexCor();
        if (this$texCor == null ? other$texCor != null : !((Object)this$texCor).equals(other$texCor)) {
            return false;
        }
        Vector3f this$normal = this.getNormal();
        Vector3f other$normal = other.getNormal();
        if (this$normal == null ? other$normal != null : !((Object)this$normal).equals(other$normal)) {
            return false;
        }
        Vector3f this$tangent = this.getTangent();
        Vector3f other$tangent = other.getTangent();
        return !(this$tangent == null ? other$tangent != null : !((Object)this$tangent).equals(other$tangent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Vertex;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Vector3f $pos = this.getPos();
        result = result * 59 + ($pos == null ? 0 : $pos.hashCode());
        Vector2f $texCor = this.getTexCor();
        result = result * 59 + ($texCor == null ? 0 : ((Object)$texCor).hashCode());
        Vector3f $normal = this.getNormal();
        result = result * 59 + ($normal == null ? 0 : $normal.hashCode());
        Vector3f $tangent = this.getTangent();
        result = result * 59 + ($tangent == null ? 0 : $tangent.hashCode());
        return result;
    }

    public String toString() {
        return "Vertex(pos=" + this.getPos() + ", texCor=" + this.getTexCor() + ", normal=" + this.getNormal() + ", tangent=" + this.getTangent() + ")";
    }
}

