/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.rendering.binding;

import org.achtern.AchternEngine.core.math.Matrix4f;
import org.achtern.AchternEngine.core.math.Vector2f;
import org.achtern.AchternEngine.core.math.Vector3f;
import org.achtern.AchternEngine.core.math.Vector4f;
import org.achtern.AchternEngine.core.rendering.Color;
import org.achtern.AchternEngine.core.rendering.binding.UniformManager;
import org.achtern.AchternEngine.core.rendering.fog.Fog;
import org.achtern.AchternEngine.core.rendering.light.Attenuation;
import org.achtern.AchternEngine.core.rendering.shader.Shader;
import org.achtern.AchternEngine.core.resource.fileparser.caseclasses.GLSLScript;
import org.achtern.AchternEngine.core.resource.fileparser.caseclasses.Uniform;
import org.achtern.AchternEngine.core.scenegraph.entity.renderpasses.light.AmbientLight;
import org.achtern.AchternEngine.core.scenegraph.entity.renderpasses.light.BaseLight;
import org.achtern.AchternEngine.core.scenegraph.entity.renderpasses.light.DirectionalLight;
import org.achtern.AchternEngine.core.scenegraph.entity.renderpasses.light.PointLight;
import org.achtern.AchternEngine.core.scenegraph.entity.renderpasses.light.SpotLight;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicUniformManager
implements UniformManager {
    public static final Logger LOGGER = LoggerFactory.getLogger(BasicUniformManager.class);

    public void addUniforms(Shader shader) {
        for (GLSLScript script : shader.getProgram().getScripts()) {
            for (Uniform u : script.getExpandedUniforms()) {
                LOGGER.trace("{}: uniform {} got added", (Object)this.getClass().getSimpleName(), (Object)u.getName());
                this.registerUniform(shader, u);
            }
        }
    }

    public void setUniform(Shader shader, Uniform uniform) {
        boolean primitive;
        if (!uniform.shouldSet()) {
            return;
        }
        boolean bl = primitive = uniform.getValue() instanceof Float || uniform.getValue() instanceof Integer || uniform.getValue() instanceof Double;
        if (!primitive && uniform.getValue() == null) {
            throw new IllegalStateException("Uniform value cannot be null for " + uniform);
        }
        if (uniform.getValue() instanceof Vector3f) {
            this.setUniform(shader, uniform.getName(), (Vector3f)uniform.getValue());
        } else if (uniform.getValue() instanceof Color) {
            this.setUniform(shader, uniform.getName(), (Color)uniform.getValue());
        } else if (uniform.getValue() instanceof Vector4f) {
            this.setUniform(shader, uniform.getName(), (Vector4f)uniform.getValue());
        } else if (uniform.getValue() instanceof Vector2f) {
            this.setUniform(shader, uniform.getName(), (Vector2f)uniform.getValue());
        } else if (uniform.getValue() instanceof Matrix4f) {
            this.setUniform(shader, uniform.getName(), (Matrix4f)uniform.getValue());
        } else if (uniform.getValue() instanceof Integer) {
            this.setUniform(shader, uniform.getName(), (Integer)uniform.getValue());
        } else if (uniform.getValue() instanceof Float) {
            this.setUniform(shader, uniform.getName(), ((Float)uniform.getValue()).floatValue());
        } else if (uniform.getValue() instanceof Double) {
            this.setUniform(shader, uniform.getName(), (Double)uniform.getValue());
        } else if (uniform.getValue() instanceof DirectionalLight) {
            this.setUniform(shader, uniform.getName(), (DirectionalLight)uniform.getValue());
        } else if (uniform.getValue() instanceof AmbientLight) {
            this.setUniform(shader, uniform.getName(), (AmbientLight)uniform.getValue());
        } else if (uniform.getValue() instanceof SpotLight) {
            this.setUniform(shader, uniform.getName(), (SpotLight)uniform.getValue());
        } else if (uniform.getValue() instanceof PointLight) {
            this.setUniform(shader, uniform.getName(), (PointLight)uniform.getValue());
        } else if (uniform.getValue() instanceof BaseLight) {
            this.setUniform(shader, uniform.getName(), (BaseLight)uniform.getValue());
        } else if (uniform.getValue() instanceof Attenuation) {
            this.setUniform(shader, uniform.getName(), (Attenuation)uniform.getValue());
        } else if (uniform.getValue() instanceof Fog) {
            this.setUniform(shader, uniform.getName(), (Fog)uniform.getValue());
        } else {
            Uniform.SetStrategy strategy = uniform.getSetStrategy();
            if (strategy == null) {
                throw new UnsupportedOperationException("Cannot set uniform and no SetStrategy provided");
            }
            strategy.set(uniform, this);
        }
    }
}

