/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.rendering.framebuffer;

import java.util.ArrayList;
import java.util.List;
import org.achtern.AchternEngine.core.bootstrap.Native;
import org.achtern.AchternEngine.core.rendering.Dimension;
import org.achtern.AchternEngine.core.rendering.RenderTarget;
import org.achtern.AchternEngine.core.rendering.binding.DataBinder;
import org.achtern.AchternEngine.core.rendering.framebuffer.RenderBuffer;
import org.achtern.AchternEngine.core.rendering.texture.Format;
import org.achtern.AchternEngine.core.rendering.texture.Texture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameBuffer
extends Dimension
implements RenderTarget,
Native {
    public static final Logger LOGGER = LoggerFactory.getLogger(FrameBuffer.class);
    protected int id = -1;
    protected int samples = 1;
    protected List<RenderBuffer> colorTargets;
    protected RenderBuffer depthTarget;

    public FrameBuffer(Dimension texture, int samples) {
        super(texture);
        if (samples < 1) {
            throw new IllegalArgumentException("sampler must be greater than 0");
        }
        this.samples = samples;
        this.colorTargets = new ArrayList<RenderBuffer>();
    }

    public FrameBuffer(Dimension dimension) {
        this(dimension, 1);
    }

    public void setDepthTarget(Format format) {
        this.testModify();
        this.depthTarget = new RenderBuffer(format);
    }

    public void setDepthTarget(Texture texture) {
        this.testModify();
        this.depthTarget = new RenderBuffer(texture);
    }

    public void setColorTarget(Format format) {
        this.testModify();
        RenderBuffer buffer = new RenderBuffer(format);
        this.colorTargets.clear();
        this.colorTargets.add(buffer);
    }

    public void setColorTarget(Texture texture) {
        this.testModify();
        this.clearColorTargets();
        this.addColorTexture(texture);
    }

    public void addColorTexture(Texture texture) {
        this.testModify();
        RenderBuffer buffer = new RenderBuffer(texture);
        this.colorTargets.add(buffer);
    }

    public void clearColorTargets() {
        this.colorTargets.clear();
    }

    public int sizeColorTargets() {
        return this.colorTargets.size();
    }

    public RenderBuffer getDepthTarget() {
        return this.depthTarget;
    }

    public RenderBuffer getColorTarget() {
        return this.getColorTarget(0);
    }

    public RenderBuffer getColorTarget(int i) {
        if (this.colorTargets.isEmpty()) {
            return null;
        }
        return this.colorTargets.get(i);
    }

    public List<RenderBuffer> getColorTargets() {
        return this.colorTargets;
    }

    public int getSamples() {
        return this.samples;
    }

    @Override
    public void setID(int id) {
        this.id = id;
    }

    @Override
    public int getID() {
        return this.id;
    }

    public void testModify() {
        if (this.getID() != -1) {
            throw new IllegalStateException("FrameBuffer already generated!");
        }
    }

    @Override
    public void bindAsRenderTarget(DataBinder binder) {
        binder.bindAsRenderTarget(this);
    }
}

