/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.rendering.shader;

import org.achtern.AchternEngine.core.Transform;
import org.achtern.AchternEngine.core.math.Matrix4f;
import org.achtern.AchternEngine.core.rendering.Material;
import org.achtern.AchternEngine.core.rendering.RenderEngine;
import org.achtern.AchternEngine.core.rendering.fog.Fog;
import org.achtern.AchternEngine.core.rendering.mesh.MeshData;
import org.achtern.AchternEngine.core.resource.fileparser.GLSLParser;
import org.achtern.AchternEngine.core.resource.fileparser.GLSLProgram;
import org.achtern.AchternEngine.core.resource.fileparser.caseclasses.Uniform;
import org.achtern.AchternEngine.core.scenegraph.entity.Figure;
import org.achtern.AchternEngine.core.scenegraph.entity.GlobalEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Shader {
    public static final Logger LOGGER = LoggerFactory.getLogger(Shader.class);
    private GLSLParser parser = new GLSLParser();
    protected GLSLProgram program;

    public Shader() {
    }

    public Shader(GLSLProgram program) {
        this.program = program;
    }

    public void updateUniforms(RenderEngine renderEngine, Figure figure) {
        Material material = figure.getMaterial();
        Transform transform = figure.getTransform();
        Matrix4f worldMat = transform.getTransformation();
        Matrix4f projection = renderEngine.getCamera().getViewProjection().mul(worldMat);
        int samplerSlot = 0;
        for (Uniform u : this.program.getUniforms()) {
            String n = u.getName();
            if (u.getType().equalsIgnoreCase("sampler2D")) {
                if (material.hasTexture(n)) {
                    renderEngine.getDataBinder().bind(material.getTexture(n), samplerSlot);
                } else if (renderEngine.hasTexture(n)) {
                    renderEngine.getDataBinder().bind(renderEngine.getTexture(n), samplerSlot);
                } else if (!figure.getMesh().getData().getMode().equals((Object)MeshData.Mode.TRIANGLES)) {
                    u.setShouldSet(false);
                } else {
                    LOGGER.warn("{}: texture '{}' not found in material nor RenderEngine.", (Object)this.getClass().getSimpleName(), (Object)n);
                    renderEngine.getDataBinder().bind(material.getTexture(n), samplerSlot);
                    n = "diffuse";
                }
                u.setValue(samplerSlot);
                ++samplerSlot;
            } else if (u.getType().equalsIgnoreCase("DirectionalLight") || u.getType().equalsIgnoreCase("SpotLight") || u.getType().equalsIgnoreCase("PointLight") || u.getType().equalsIgnoreCase("AmbientLight")) {
                u.setValue(renderEngine.getActiveRenderPass());
            } else if (u.getType().equalsIgnoreCase("Fog")) {
                GlobalEntity<Fog> gE = renderEngine.getGlobal(Fog.class);
                if (gE != null) {
                    u.setValue(gE.getObject());
                } else {
                    u.setValue(Fog.DISABLED);
                }
            } else if (n.equalsIgnoreCase("color")) {
                u.setValue(material.getColor());
            } else if (n.equalsIgnoreCase("MVP")) {
                u.setValue(projection);
            } else if (n.equalsIgnoreCase("model")) {
                u.setValue(transform.getTransformation());
            } else if (n.equalsIgnoreCase("modelView")) {
                u.setValue(renderEngine.getCamera().getView().mul(transform.getTransformation()));
            } else if (n.equalsIgnoreCase("eyePos")) {
                u.setValue(renderEngine.getCamera().getTransform().getTransformedPosition());
            } else if (n.equalsIgnoreCase("shadowMatrix")) {
                Matrix4f m = new Matrix4f().initIdentiy();
                if (renderEngine.getMatrix("shadowMatrix") != null) {
                    m = renderEngine.getMatrix("shadowMatrix").mul(transform.getTransformation());
                }
                u.setValue(m);
            } else if (u.getType().equalsIgnoreCase("float")) {
                u.setValue(Float.valueOf(material.getFloat(n)));
            } else if (u.getType().equalsIgnoreCase("vec3") && material.hasVector(n)) {
                u.setValue(material.getVector(n));
            } else if (u.getType().equalsIgnoreCase("mat4") && material.hasMatrix(n)) {
                u.setValue(material.getMatrix(n));
            } else if (u.getType().equalsIgnoreCase("vec4") && material.hasColor(n)) {
                u.setValue(material.getColor(n));
            } else if (u.getType().equalsIgnoreCase("int")) {
                u.setValue(material.getInteger(n));
            }
            this.handle(u, transform, material, renderEngine, projection);
            renderEngine.getDataBinder().getUniformManager().setUniform(this, u);
        }
    }

    protected void handle(Uniform uniform, Transform transform, Material material, RenderEngine renderEngine, Matrix4f projection) {
    }

    public GLSLParser getParser() {
        return this.parser;
    }

    public void setParser(GLSLParser parser) {
        this.parser = parser;
    }

    public GLSLProgram getProgram() {
        return this.program;
    }
}

