/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.rendering.shader.forward;

import java.util.HashMap;
import java.util.Map;
import org.achtern.AchternEngine.core.rendering.RenderPass;
import org.achtern.AchternEngine.core.rendering.shader.Shader;
import org.achtern.AchternEngine.core.rendering.shader.forward.Ambient;
import org.achtern.AchternEngine.core.rendering.shader.forward.Wireframe;
import org.achtern.AchternEngine.core.scenegraph.entity.renderpasses.WireframeDisplay;
import org.achtern.AchternEngine.core.scenegraph.entity.renderpasses.light.AmbientLight;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ShaderSuit {
    protected Map<Class<? extends RenderPass>, Shader> shaders;

    protected ShaderSuit() {
        this(new HashMap<Class<? extends RenderPass>, Shader>());
    }

    protected ShaderSuit(Map<Class<? extends RenderPass>, Shader> shaders) {
        this.shaders = shaders;
        this.setShaderFor(AmbientLight.class, Ambient.getInstance());
        this.setShaderFor(WireframeDisplay.class, Wireframe.getInstance());
    }

    public Shader getFor(Class<? extends RenderPass> light) throws NullPointerException {
        Shader s = this.shaders.get(light);
        if (s == null) {
            throw new NullPointerException("No shader for Light {" + light.toString() + "}");
        }
        return s;
    }

    public void setShaderFor(Class<? extends RenderPass> type, Shader shader) {
        this.shaders.put(type, shader);
    }
}

