/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.resource;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.achtern.AchternEngine.core.audio.openal.AudioSource;
import org.achtern.AchternEngine.core.rendering.Dimension;
import org.achtern.AchternEngine.core.rendering.mesh.Mesh;
import org.achtern.AchternEngine.core.rendering.texture.Texture;
import org.achtern.AchternEngine.core.resource.ResourceCache;
import org.achtern.AchternEngine.core.resource.ResourceLoader;
import org.achtern.AchternEngine.core.resource.ResourceLoaderProvider;
import org.achtern.AchternEngine.core.resource.ResourceLocation;
import org.achtern.AchternEngine.core.resource.fileparser.GLSLProgram;
import org.achtern.AchternEngine.core.resource.fileparser.LineBasedParser;
import org.achtern.AchternEngine.core.resource.loader.AsciiFileLoader;
import org.achtern.AchternEngine.core.resource.loader.AudioSourceLoader;
import org.achtern.AchternEngine.core.resource.loader.BinaryLoader;
import org.achtern.AchternEngine.core.resource.loader.GLSLProgramLoader;
import org.achtern.AchternEngine.core.resource.loader.MeshLoader;
import org.achtern.AchternEngine.core.resource.loader.ShaderSourceLoader;
import org.achtern.AchternEngine.core.resource.loader.TextureLoader;
import org.achtern.AchternEngine.core.resource.loader.json.FigureLoader;
import org.achtern.AchternEngine.core.resource.locations.BundledFigureLocation;
import org.achtern.AchternEngine.core.resource.locations.BundledModelLocation;
import org.achtern.AchternEngine.core.resource.locations.BundledShaderLocation;
import org.achtern.AchternEngine.core.resource.locations.BundledShaderProgramLocation;
import org.achtern.AchternEngine.core.resource.locations.BundledTextureLocation;
import org.achtern.AchternEngine.core.resource.locations.ClasspathLocation;
import org.achtern.AchternEngine.core.resource.locations.FileSystemLocation;
import org.achtern.AchternEngine.core.scenegraph.entity.Figure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicResourceLoader
implements ResourceLoaderProvider {
    public static final Logger LOGGER = LoggerFactory.getLogger(ResourceLoader.class);
    public static final String SHADER_PROGRAM_EXT = ".yaml";
    public static final String FIGURE_DECLARATION_EXT = ".json";
    protected ResourceCache binaryCache = new ResourceCache();
    protected ResourceCache<String> fileCache = new ResourceCache();
    protected List<ResourceLocation> locations = new ArrayList<ResourceLocation>();

    public BasicResourceLoader() {
        this.locations.add(new ClasspathLocation());
        this.locations.add(new BundledTextureLocation());
        this.locations.add(new BundledModelLocation());
        this.locations.add(new BundledFigureLocation());
        this.locations.add(new BundledShaderLocation());
        this.locations.add(new BundledShaderProgramLocation());
        this.locations.add(new FileSystemLocation("."));
    }

    @Override
    public void addResourceLocation(ResourceLocation location) {
        this.locations.add(location);
    }

    @Override
    public void pushResourceLocation(ResourceLocation location) {
        this.locations.add(0, location);
    }

    @Override
    public void removeResourceLocation(ResourceLocation location) {
        this.locations.remove(location);
    }

    @Override
    public void clearResourceLocations() {
        this.locations.clear();
    }

    @Override
    public List<ResourceLocation> getResourceLocations() {
        return this.locations;
    }

    @Override
    public void preLoadMesh(String name) throws Exception {
        this.getMesh(name);
    }

    @Override
    public void preLoadTexture(String name) throws Exception {
        this.getTexture(name);
    }

    @Override
    public void preLoadShader(String name) throws Exception {
        this.getShader(name);
    }

    @Override
    public Figure getFigure(String name) throws Exception {
        return this.getFigure(name, false);
    }

    @Override
    public Figure getFigure(String name, boolean forceLoading) throws Exception {
        LOGGER.info("Loading Figure {}", (Object)name);
        return this.load(name + FIGURE_DECLARATION_EXT, new FigureLoader(), forceLoading);
    }

    @Override
    public Mesh getMesh(String name) throws Exception {
        return this.getMesh(name, false);
    }

    @Override
    public Mesh getMesh(String name, boolean forceLoading) throws Exception {
        LOGGER.info("Loading Mesh {}", (Object)name);
        return this.load(name, new MeshLoader(), forceLoading);
    }

    @Override
    public Texture getTexture(String name) throws Exception {
        return this.getTexture(name, null, false);
    }

    @Override
    public Texture getTexture(String name, Dimension dimension) throws Exception {
        return this.getTexture(name, dimension, false);
    }

    @Override
    public Texture getTexture(String name, Dimension dimension, boolean forceLoading) throws Exception {
        LOGGER.info("Loading Texture {}", (Object)name);
        return this.load(name, new TextureLoader(dimension), forceLoading);
    }

    @Override
    public String getShader(String name) throws Exception {
        return this.load(name, new ShaderSourceLoader(), false);
    }

    @Override
    public String getShader(String name, boolean forceLoading) throws Exception {
        return this.load(name, new ShaderSourceLoader(), forceLoading);
    }

    @Override
    public String getShader(String name, boolean forceLoading, LineBasedParser parser) throws Exception {
        LOGGER.info("Loading Shader Source {}", (Object)name);
        return this.load(name, new ShaderSourceLoader(parser), forceLoading);
    }

    @Override
    public GLSLProgram getShaderProgram(String name) throws Exception {
        return this.getShaderProgram(name, false);
    }

    @Override
    public GLSLProgram getShaderProgram(String name, boolean forceLoading) throws Exception {
        LOGGER.info("Loading Shader Program {}", (Object)name);
        return this.load(name + SHADER_PROGRAM_EXT, new GLSLProgramLoader(), forceLoading);
    }

    @Override
    public AudioSource getAudioSource(String name) throws Exception {
        return this.getAudioSource(name, false);
    }

    @Override
    public AudioSource getAudioSource(String name, boolean forceLoading) throws Exception {
        LOGGER.info("Loading AudioSource {}", (Object)name);
        return this.load(name, new AudioSourceLoader(), forceLoading);
    }

    @Override
    public <T> T load(String name, AsciiFileLoader<T> loader, boolean forceLoading) throws Exception {
        String file = this.readFile(name, forceLoading, loader.getPreProcessor());
        loader.load(name, file);
        return loader.get();
    }

    @Override
    public <T, C> T load(String name, BinaryLoader<T, C> loader, boolean forceLoading) throws Exception {
        if (this.binaryCache.has(name) && !forceLoading) {
            Object cache = this.binaryCache.get(name);
            if (loader.getCacheType() == null) {
                throw new IllegalStateException("Missing Cache Type. BinaryLoader invalid.");
            }
            if (loader.getCacheType().isAssignableFrom(cache.getClass())) {
                return loader.fromCache(cache);
            }
        }
        InputStream stream = this.getStream(name);
        loader.load(name, stream);
        Object value = loader.get();
        this.binaryCache.add(name, loader.getCache());
        stream.close();
        return value;
    }

    @Override
    public String readFile(String name) throws IOException {
        return this.readFile(name, false);
    }

    @Override
    public String readFile(String name, boolean forceLoading) throws IOException {
        return this.readFile(name, forceLoading, null);
    }

    @Override
    public String readFile(String name, boolean forceLoading, LineBasedParser parser) throws IOException {
        String line;
        if (this.fileCache.has(name) && !forceLoading) {
            return this.fileCache.get(name);
        }
        StringBuilder file = new StringBuilder();
        BufferedReader fileReader = new BufferedReader(new InputStreamReader(this.getStream(name)));
        long lines = 0L;
        while ((line = fileReader.readLine()) != null) {
            if (LOGGER.isDebugEnabled()) {
                ++lines;
            }
            try {
                if (parser != null) {
                    file.append(parser.parse(line)).append("\n");
                    continue;
                }
                file.append(line).append("\n");
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                LOGGER.warn("Non IOException when loading file <" + name + ">", (Throwable)e);
            }
        }
        fileReader.close();
        LOGGER.debug("Loaded {} lines from file {}", (Object)lines, (Object)name);
        this.fileCache.add(name, file.toString());
        return file.toString();
    }

    @Override
    public boolean exists(String name) {
        try {
            URL uRL = this.getURL(name);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public InputStream getStream(String name) throws IOException {
        ResourceLocation location;
        InputStream is = null;
        Iterator<ResourceLocation> iterator = this.locations.iterator();
        while (iterator.hasNext() && (is = (location = iterator.next()).getStream(name)) == null) {
        }
        if (is == null) {
            throw new IOException("Resource not found in locations. <" + name + ">");
        }
        return new BufferedInputStream(is);
    }

    @Override
    public URL getURL(String name) throws IOException {
        ResourceLocation location;
        URL url = null;
        Iterator<ResourceLocation> iterator = this.locations.iterator();
        while (iterator.hasNext() && (url = (location = iterator.next()).getURL(name)) == null) {
        }
        if (url == null) {
            throw new IOException("Resource not found in locations. <" + name + ">");
        }
        return url;
    }
}

