/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.resource;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.nio.ByteBuffer;
import org.achtern.AchternEngine.core.rendering.Dimension;
import org.achtern.AchternEngine.core.util.UBuffer;

public class ResourceConverter {
    public static ByteBuffer toByteBuffer(BufferedImage image) {
        return ResourceConverter.toByteBuffer(image, Dimension.fromBufferedImage(image));
    }

    public static ByteBuffer toByteBuffer(BufferedImage image, Dimension dimension) {
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        boolean hasAlphaChannel = image.getColorModel().hasAlpha();
        int bpp = 3;
        if (hasAlphaChannel) {
            ++bpp;
        }
        ByteBuffer buffer = UBuffer.createByteBuffer(dimension.getHeight() * dimension.getWidth() * bpp);
        if (hasAlphaChannel) {
            for (int i = 0; i < pixels.length; i += bpp) {
                buffer.put(pixels[i + 3]);
                buffer.put(pixels[i + 2]);
                buffer.put(pixels[i + 1]);
                buffer.put(pixels[i]);
            }
        } else {
            for (int i = 0; i < pixels.length; i += bpp) {
                buffer.put(pixels[i + 2]);
                buffer.put(pixels[i + 1]);
                buffer.put(pixels[i]);
            }
        }
        buffer.flip();
        return buffer;
    }
}

