/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.achtern.AchternEngine.core.audio.openal.AudioSource;
import org.achtern.AchternEngine.core.rendering.Dimension;
import org.achtern.AchternEngine.core.rendering.mesh.Mesh;
import org.achtern.AchternEngine.core.rendering.texture.Texture;
import org.achtern.AchternEngine.core.resource.BasicResourceLoader;
import org.achtern.AchternEngine.core.resource.ResourceLoaderProvider;
import org.achtern.AchternEngine.core.resource.ResourceLocation;
import org.achtern.AchternEngine.core.resource.fileparser.GLSLProgram;
import org.achtern.AchternEngine.core.resource.fileparser.LineBasedParser;
import org.achtern.AchternEngine.core.resource.loader.AsciiFileLoader;
import org.achtern.AchternEngine.core.resource.loader.BinaryLoader;
import org.achtern.AchternEngine.core.scenegraph.entity.Figure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLoader {
    private static ResourceLoaderProvider provider = new BasicResourceLoader();

    public static void addResourceLocation(ResourceLocation location) {
        provider.addResourceLocation(location);
    }

    public static void pushResourceLocation(ResourceLocation location) {
        provider.pushResourceLocation(location);
    }

    public static void removeResourceLocation(ResourceLocation location) {
        provider.removeResourceLocation(location);
    }

    public static void clearResourceLocations() {
        provider.clearResourceLocations();
    }

    public static List<ResourceLocation> getResourceLocations() {
        return provider.getResourceLocations();
    }

    public static void preLoadMesh(String name) throws Exception {
        provider.preLoadMesh(name);
    }

    public static void preLoadTexture(String name) throws Exception {
        provider.preLoadTexture(name);
    }

    public static void preLoadShader(String name) throws Exception {
        provider.preLoadShader(name);
    }

    public static Figure getFigure(String name) throws Exception {
        return provider.getFigure(name);
    }

    public static Figure getFigure(String name, boolean forceLoading) throws Exception {
        return provider.getFigure(name, forceLoading);
    }

    public static Mesh getMesh(String name) throws Exception {
        return provider.getMesh(name);
    }

    public static Mesh getMesh(String name, boolean forceLoading) throws Exception {
        return provider.getMesh(name, forceLoading);
    }

    public static Texture getTexture(String name) throws Exception {
        return provider.getTexture(name);
    }

    public static Texture getTexture(String name, Dimension dimension) throws Exception {
        return provider.getTexture(name, dimension);
    }

    public static Texture getTexture(String name, Dimension dimension, boolean forceLoading) throws Exception {
        return provider.getTexture(name, dimension, forceLoading);
    }

    public static String getShader(String name) throws Exception {
        return provider.getShader(name);
    }

    public static String getShader(String name, boolean forceLoading) throws Exception {
        return provider.getShader(name, forceLoading);
    }

    public static String getShader(String name, boolean forceLoading, LineBasedParser parser) throws Exception {
        return provider.getShader(name, forceLoading, parser);
    }

    public static GLSLProgram getShaderProgram(String name) throws Exception {
        return provider.getShaderProgram(name);
    }

    public static GLSLProgram getShaderProgram(String name, boolean forceLoading) throws Exception {
        return provider.getShaderProgram(name, forceLoading);
    }

    public static AudioSource getAudioSource(String name) throws Exception {
        return provider.getAudioSource(name);
    }

    public static AudioSource getAudioSource(String name, boolean forceLoading) throws Exception {
        return provider.getAudioSource(name, forceLoading);
    }

    public static <T> T load(String name, AsciiFileLoader<T> loader, boolean forceLoading) throws Exception {
        return provider.load(name, loader, forceLoading);
    }

    public static <T, C> T load(String name, BinaryLoader<T, C> loader, boolean forceLoading) throws Exception {
        return provider.load(name, loader, forceLoading);
    }

    public static String readFile(String name) throws IOException {
        return provider.readFile(name);
    }

    public static String readFile(String name, boolean forceLoading) throws IOException {
        return provider.readFile(name, forceLoading);
    }

    public static String readFile(String name, boolean forceLoading, LineBasedParser parser) throws IOException {
        return provider.readFile(name, forceLoading, parser);
    }

    public static boolean exists(String name) {
        return provider.exists(name);
    }

    public static InputStream getStream(String name) throws IOException {
        return provider.getStream(name);
    }

    public static URL getURL(String name) throws IOException {
        return provider.getURL(name);
    }

    public static ResourceLoaderProvider getProvider() {
        return provider;
    }

    public static void setProvider(ResourceLoaderProvider provider) {
        ResourceLoader.provider = provider;
    }
}

