/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.resource.fileparser.mesh;

import java.util.ArrayList;
import java.util.List;
import org.achtern.AchternEngine.core.math.Vector2f;
import org.achtern.AchternEngine.core.math.Vector3f;
import org.achtern.AchternEngine.core.util.TangentGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedModel {
    protected List<Vector3f> positions = new ArrayList<Vector3f>();
    protected List<Vector2f> texCoord = new ArrayList<Vector2f>();
    protected List<Vector3f> normal = new ArrayList<Vector3f>();
    protected List<Vector3f> tangent = new ArrayList<Vector3f>();
    protected List<Integer> indices = new ArrayList<Integer>();

    public void calcNormals() {
        for (int i = 0; i < this.getIndices().size(); i += 3) {
            int i0 = this.getIndices().get(i);
            int i1 = this.getIndices().get(i + 1);
            int i2 = this.getIndices().get(i + 2);
            Vector3f v1 = this.getPositions().get(i1).sub(this.getPositions().get(i0));
            Vector3f v2 = this.getPositions().get(i2).sub(this.getPositions().get(i0));
            Vector3f normal = v1.cross(v2).normalized();
            this.getNormal().get(i0).set(this.getNormal().get(i0).add(normal));
            this.getNormal().get(i1).set(this.getNormal().get(i1).add(normal));
            this.getNormal().get(i2).set(this.getNormal().get(i2).add(normal));
        }
        for (Vector3f normal : this.getNormal()) {
            normal.normalize();
        }
    }

    public void calcTangents() {
        this.setTangent(TangentGenerator.calculate(this.getPositions(), this.getIndices(), this.getTexCoord()));
    }

    public List<Vector3f> getPositions() {
        return this.positions;
    }

    public List<Vector2f> getTexCoord() {
        return this.texCoord;
    }

    public List<Vector3f> getNormal() {
        return this.normal;
    }

    public List<Vector3f> getTangent() {
        return this.tangent;
    }

    public List<Integer> getIndices() {
        return this.indices;
    }

    public void setPositions(List<Vector3f> positions) {
        this.positions = positions;
    }

    public void setTexCoord(List<Vector2f> texCoord) {
        this.texCoord = texCoord;
    }

    public void setNormal(List<Vector3f> normal) {
        this.normal = normal;
    }

    public void setTangent(List<Vector3f> tangent) {
        this.tangent = tangent;
    }

    public void setIndices(List<Integer> indices) {
        this.indices = indices;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexedModel)) {
            return false;
        }
        IndexedModel other = (IndexedModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Vector3f> this$positions = this.getPositions();
        List<Vector3f> other$positions = other.getPositions();
        if (this$positions == null ? other$positions != null : !((Object)this$positions).equals(other$positions)) {
            return false;
        }
        List<Vector2f> this$texCoord = this.getTexCoord();
        List<Vector2f> other$texCoord = other.getTexCoord();
        if (this$texCoord == null ? other$texCoord != null : !((Object)this$texCoord).equals(other$texCoord)) {
            return false;
        }
        List<Vector3f> this$normal = this.getNormal();
        List<Vector3f> other$normal = other.getNormal();
        if (this$normal == null ? other$normal != null : !((Object)this$normal).equals(other$normal)) {
            return false;
        }
        List<Vector3f> this$tangent = this.getTangent();
        List<Vector3f> other$tangent = other.getTangent();
        if (this$tangent == null ? other$tangent != null : !((Object)this$tangent).equals(other$tangent)) {
            return false;
        }
        List<Integer> this$indices = this.getIndices();
        List<Integer> other$indices = other.getIndices();
        return !(this$indices == null ? other$indices != null : !((Object)this$indices).equals(other$indices));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IndexedModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Vector3f> $positions = this.getPositions();
        result = result * 59 + ($positions == null ? 0 : ((Object)$positions).hashCode());
        List<Vector2f> $texCoord = this.getTexCoord();
        result = result * 59 + ($texCoord == null ? 0 : ((Object)$texCoord).hashCode());
        List<Vector3f> $normal = this.getNormal();
        result = result * 59 + ($normal == null ? 0 : ((Object)$normal).hashCode());
        List<Vector3f> $tangent = this.getTangent();
        result = result * 59 + ($tangent == null ? 0 : ((Object)$tangent).hashCode());
        List<Integer> $indices = this.getIndices();
        result = result * 59 + ($indices == null ? 0 : ((Object)$indices).hashCode());
        return result;
    }

    public String toString() {
        return "IndexedModel(positions=" + this.getPositions() + ", texCoord=" + this.getTexCoord() + ", normal=" + this.getNormal() + ", tangent=" + this.getTangent() + ", indices=" + this.getIndices() + ")";
    }
}

