/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.resource.fileparser.mesh;

import java.util.ArrayList;
import java.util.HashMap;
import org.achtern.AchternEngine.core.math.Vector2f;
import org.achtern.AchternEngine.core.math.Vector3f;
import org.achtern.AchternEngine.core.resource.fileparser.LineBasedParser;
import org.achtern.AchternEngine.core.resource.fileparser.mesh.IndexedModel;
import org.achtern.AchternEngine.core.resource.fileparser.mesh.Model;
import org.achtern.AchternEngine.core.resource.fileparser.mesh.OBJIndex;
import org.achtern.AchternEngine.core.resource.loader.LoadingException;
import org.achtern.AchternEngine.core.util.UString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBJParser
implements Model,
LineBasedParser {
    public static final Logger LOGGER = LoggerFactory.getLogger(OBJParser.class);
    public static final String COMMENT = "#";
    public static final String VERTEX = "v";
    public static final String NORMAL = "vn";
    public static final String UV = "vt";
    public static final String FACE = "f";
    public static final String GROUP = "g";
    protected ArrayList<Vector3f> positions = new ArrayList();
    protected ArrayList<Vector2f> texCoord = new ArrayList();
    protected ArrayList<Vector3f> normal = new ArrayList();
    protected ArrayList<OBJIndex> indices = new ArrayList();
    protected boolean hasTexCoords = false;
    protected boolean hasNormals = false;
    protected boolean run = false;
    private static boolean no_mulit_object_warned = false;

    @Override
    public String parse(String line) throws Exception {
        if (!this.run) {
            this.run = true;
        }
        String[] tokens = line.split(" ");
        if ((tokens = UString.removeEmptyFromArray(tokens)).length == 0) {
            return line;
        }
        if (tokens[0].startsWith(COMMENT)) {
            LOGGER.trace("Skipping commented line");
        } else if (tokens[0].equalsIgnoreCase(GROUP)) {
            if (!no_mulit_object_warned) {
                LOGGER.warn("Multi-Object OBJ files are not fully supported. Texture Coordinates may be broken. You can combine the objects in the 3D Editor of your choice.");
                no_mulit_object_warned = true;
            }
        } else if (tokens[0].equalsIgnoreCase(VERTEX)) {
            this.positions.add(new Vector3f(Float.valueOf(tokens[1]).floatValue(), Float.valueOf(tokens[2]).floatValue(), Float.valueOf(tokens[3]).floatValue()));
        } else if (tokens[0].equalsIgnoreCase(UV)) {
            this.texCoord.add(new Vector2f(Float.valueOf(tokens[1]).floatValue(), 1.0f - Float.valueOf(tokens[2]).floatValue()));
        } else if (tokens[0].equalsIgnoreCase(NORMAL)) {
            this.normal.add(new Vector3f(Float.valueOf(tokens[1]).floatValue(), Float.valueOf(tokens[2]).floatValue(), Float.valueOf(tokens[3]).floatValue()));
        } else if (tokens[0].equalsIgnoreCase(FACE)) {
            for (int i = 0; i < tokens.length - 3; ++i) {
                this.indices.add(this.parseOBJIndex(tokens[1]));
                this.indices.add(this.parseOBJIndex(tokens[2 + i]));
                this.indices.add(this.parseOBJIndex(tokens[3 + i]));
            }
        }
        return line;
    }

    @Override
    public IndexedModel toIndexedModel() {
        int i;
        LOGGER.trace("Starting to convert OBJ to Indexed Model (incl. Optimization)");
        IndexedModel rMain = new IndexedModel();
        IndexedModel normalModel = new IndexedModel();
        HashMap<OBJIndex, Integer> resultIndexMap = new HashMap<OBJIndex, Integer>();
        HashMap<Integer, Integer> normalIndexMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
        for (i = 0; i < this.getIndices().size(); ++i) {
            Integer normalModelIndex;
            OBJIndex index = this.getIndices().get(i);
            Vector3f curPos = this.getPositions().get(index.getVertex());
            Vector2f curTexCoord = this.hasTexCoords ? this.getTexCoord().get(index.getTexCoord()) : new Vector2f(0.0f, 0.0f);
            Vector3f curNormal = this.hasNormals ? this.getNormal().get(index.getNormal()) : new Vector3f(0.0f, 0.0f, 0.0f);
            Integer modelIndex = (Integer)resultIndexMap.get(index);
            if (modelIndex == null) {
                modelIndex = rMain.getPositions().size();
                resultIndexMap.put(index, modelIndex);
                rMain.getPositions().add(curPos);
                rMain.getTexCoord().add(curTexCoord);
                if (this.hasNormals) {
                    rMain.getNormal().add(curNormal);
                }
            }
            if ((normalModelIndex = (Integer)normalIndexMap.get(index.getVertex())) == null) {
                normalModelIndex = normalModel.getPositions().size();
                normalIndexMap.put(index.getVertex(), normalModelIndex);
                normalModel.getPositions().add(curPos);
                normalModel.getTexCoord().add(curTexCoord);
                normalModel.getNormal().add(curNormal);
            }
            rMain.getIndices().add(modelIndex);
            normalModel.getIndices().add(normalModelIndex);
            indexMap.put(modelIndex, normalModelIndex);
        }
        if (!this.hasNormals) {
            normalModel.calcNormals();
            for (i = 0; i < rMain.getPositions().size(); ++i) {
                rMain.getNormal().add(normalModel.getNormal().get((Integer)indexMap.get(i)));
            }
        }
        LOGGER.trace("Done to convert OBJ to Indexed Model (incl. Optimization)");
        return rMain;
    }

    protected OBJIndex parseOBJIndex(String token) throws LoadingException {
        String[] values = token.split("/");
        OBJIndex result = new OBJIndex();
        try {
            result.setVertex(Integer.parseInt(values[0]) - 1);
            if (values.length > 1 && !values[1].isEmpty()) {
                this.hasTexCoords = true;
                result.setTexCoord(Integer.parseInt(values[1]) - 1);
            }
            if (values.length > 2) {
                this.hasNormals = true;
                result.setNormal(Integer.parseInt(values[2]) - 1);
            }
        }
        catch (NumberFormatException e) {
            throw new LoadingException("Failed to parse integer in OBJ f index, token<" + token + ">");
        }
        return result;
    }

    public boolean hasRun() {
        return this.run;
    }

    public ArrayList<Vector3f> getPositions() {
        return this.positions;
    }

    public void setPositions(ArrayList<Vector3f> positions) {
        this.positions = positions;
    }

    public ArrayList<Vector2f> getTexCoord() {
        return this.texCoord;
    }

    public void setTexCoord(ArrayList<Vector2f> texCoord) {
        this.texCoord = texCoord;
    }

    public ArrayList<Vector3f> getNormal() {
        return this.normal;
    }

    public void setNormal(ArrayList<Vector3f> normal) {
        this.normal = normal;
    }

    public ArrayList<OBJIndex> getIndices() {
        return this.indices;
    }

    public void setIndices(ArrayList<OBJIndex> indices) {
        this.indices = indices;
    }
}

