/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.resource.loader;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.achtern.AchternEngine.core.rendering.Dimension;
import org.achtern.AchternEngine.core.rendering.texture.TexturableData;
import org.achtern.AchternEngine.core.rendering.texture.Texture;
import org.achtern.AchternEngine.core.resource.loader.BinaryLoader;
import org.achtern.AchternEngine.core.resource.loader.LoadingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextureLoader
extends BinaryLoader<Texture, TexturableData> {
    protected BufferedImage image;
    protected Dimension dimension;

    public TextureLoader(Dimension dimension) {
        this.dimension = dimension;
    }

    @Override
    public void load(String name, InputStream input) throws LoadingException {
        try {
            this.image = ImageIO.read(input);
        }
        catch (IOException e) {
            throw new LoadingException("Could not read image", e);
        }
    }

    @Override
    public Texture get() throws Exception {
        Texture texture = this.dimension != null ? new Texture(this.image, this.dimension) : new Texture(this.image);
        this.cache(texture);
        return texture;
    }

    @Override
    public Texture fromCache(TexturableData value) throws Exception {
        return new Texture(value);
    }

    @Override
    public Class<TexturableData> getCacheType() {
        return TexturableData.class;
    }
}

