/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.resource.loader.json;

import org.achtern.AchternEngine.core.rendering.Color;
import org.achtern.AchternEngine.core.rendering.generator.ImageGenerator;
import org.achtern.AchternEngine.core.rendering.texture.Texture;
import org.achtern.AchternEngine.core.resource.ResourceLoader;
import org.achtern.AchternEngine.core.resource.fileparser.ParsingException;
import org.achtern.AchternEngine.core.resource.loader.AsciiFileLoader;
import org.achtern.AchternEngine.core.resource.loader.LoadingException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JsonLoader<T>
extends AsciiFileLoader<T> {
    protected JSONObject jsonObject;

    @Override
    public void load(String name, String input) throws LoadingException {
        try {
            this.jsonObject = new JSONObject(input);
        }
        catch (JSONException e) {
            throw new LoadingException("Failed to parse json.", e);
        }
    }

    public JSONObject getJsonObject() {
        return this.jsonObject;
    }

    public void setJsonObject(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public static Object[] toObjectArray(JSONArray array) {
        Object[] objects = new Object[array.length()];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = array.get(i);
        }
        return objects;
    }

    protected Color getColor(JSONObject json) {
        float a = 1.0f;
        float b = 1.0f;
        float g = 1.0f;
        float r = 1.0f;
        if (json.has("r")) {
            r = (float)json.getDouble("r");
        }
        if (json.has("g")) {
            g = (float)json.getDouble("g");
        }
        if (json.has("b")) {
            b = (float)json.getDouble("b");
        }
        if (json.has("a")) {
            a = (float)json.getDouble("a");
        }
        return new Color(r, g, b, a);
    }

    protected Texture getTexture(JSONObject json) throws Exception {
        if (json.has("file")) {
            return ResourceLoader.getTexture(json.getString("file"));
        }
        if (json.has("solid")) {
            Color c = this.getColor(json.getJSONObject("solid"));
            return new Texture(ImageGenerator.bytesFromColor(c));
        }
        throw new ParsingException("Texture declaration illegal, missing <file> or <solid> key");
    }
}

