/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.resource.loader.json;

import org.achtern.AchternEngine.core.rendering.Material;
import org.achtern.AchternEngine.core.resource.loader.json.JsonLoader;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaterialLoader
extends JsonLoader<Material> {
    @Override
    public Material get() throws Exception {
        String key;
        JSONObject json = this.getJsonObject();
        Material material = new Material();
        if (json.has("wireframe")) {
            material.asWireframe(json.getBoolean("wireframe"));
        }
        if (json.has("float")) {
            JSONObject floats = json.getJSONObject("float");
            for (Object oKey : floats.keySet()) {
                key = (String)oKey;
                material.addFloat(key, (float)floats.getDouble(key));
            }
        }
        if (json.has("int")) {
            JSONObject ints = json.getJSONObject("int");
            for (Object oKey : ints.keySet()) {
                key = (String)oKey;
                material.addInteger(key, ints.getInt(key));
            }
        }
        if (json.has("Color")) {
            JSONObject colors = json.getJSONObject("Color");
            for (Object oKey : colors.keySet()) {
                key = (String)oKey;
                material.addColor(key, this.getColor(colors.getJSONObject(key)));
            }
        }
        if (json.has("Texture")) {
            JSONObject textures = json.getJSONObject("Texture");
            for (Object oKey : textures.keySet()) {
                key = (String)oKey;
                material.addTexture(key, this.getTexture(textures.getJSONObject(key)));
            }
        }
        return material;
    }
}

