/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.resource.loader.json;

import org.achtern.AchternEngine.core.rendering.mesh.Mesh;
import org.achtern.AchternEngine.core.resource.ResourceLoader;
import org.achtern.AchternEngine.core.resource.loader.json.JsonLoader;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeshDeclarationLoader
extends JsonLoader<Mesh> {
    @Override
    public Mesh get() throws Exception {
        JSONObject json = this.getJsonObject();
        if (json.has("@")) {
            return this.handleClass(json);
        }
        if (json.has("file")) {
            return ResourceLoader.getMesh(json.getString("file"));
        }
        throw new UnsupportedOperationException("Mesh declaration has to contain either '@' or 'file' key!");
    }

    protected Mesh handleClass(JSONObject json) throws Exception {
        String className = json.getString("@");
        if (!className.contains(".")) {
            className = "org.achtern.AchternEngine.core.rendering.mesh." + className;
        }
        if (json.has("args")) {
            JSONArray args = json.getJSONArray("args");
            return (Mesh)this.getObject(className, MeshDeclarationLoader.toObjectArray(args));
        }
        return (Mesh)this.getObject(className, null);
    }
}

