/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.scenegraph;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.achtern.AchternEngine.core.CoreEngine;
import org.achtern.AchternEngine.core.EngineHolder;
import org.achtern.AchternEngine.core.Transform;
import org.achtern.AchternEngine.core.rendering.RenderEngine;
import org.achtern.AchternEngine.core.rendering.Renderable;
import org.achtern.AchternEngine.core.scenegraph.Updatable;
import org.achtern.AchternEngine.core.scenegraph.entity.Entity;
import org.achtern.AchternEngine.core.scenegraph.scanning.SingleEntityRetriever;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node
implements EngineHolder<CoreEngine>,
Updatable,
Renderable {
    protected Node parent;
    protected Map<String, Node> children = new ConcurrentHashMap<String, Node>();
    protected ArrayList<Entity> entities = new ArrayList();
    protected Transform transform = new Transform();
    protected CoreEngine engine;
    protected String name;
    protected SingleEntityRetriever singleEntityRetriever;

    public Node(String name) {
        this.name = name;
    }

    public Node() {
        this(null);
    }

    @Override
    public void update(float delta) {
        for (Entity entity : this.getEntities()) {
            entity.update(delta);
        }
        for (Node node : this.getChildren().values()) {
            node.update(delta);
        }
    }

    @Override
    public void render(RenderEngine renderEngine) {
        for (Entity entity : this.getEntities()) {
            entity.render(renderEngine);
        }
        for (Node node : this.getChildren().values()) {
            node.render(renderEngine);
        }
    }

    public Node add(Node node) {
        return this.add(node, false);
    }

    public Node add(Node node, boolean forceName) {
        if (node.getName() == null && !forceName) {
            node.setName(this.getName() + " >> Untitled Node " + this.getChildren().size());
        }
        int i = 1;
        String orgName = node.getName();
        while (this.getChildren().containsKey(node.getName()) && !forceName) {
            node.setName(this.getName() + ">> " + orgName + " " + i);
            ++i;
        }
        this.getChildren().put(node.getName(), node);
        node.setEngine(this.getEngine());
        node.getTransform().setParent(this.getTransform());
        for (Entity e : node.getEntities()) {
            e.setEngine(node.getEngine());
            e.setParent(node);
            e.attached();
        }
        node.setParent(this);
        return this;
    }

    public Node add(Entity entity) {
        this.getEntities().add(entity);
        entity.setParent(this);
        entity.setEngine(this.getEngine());
        if (this.getEngine() != null) {
            entity.attached();
        }
        return this;
    }

    public boolean remove(Node node) {
        return this.remove(node.getName());
    }

    public boolean remove(String nodeName) {
        Node toBeRemoved;
        try {
            toBeRemoved = this.getChildren().get(nodeName);
            if (toBeRemoved == null) {
                return false;
            }
        }
        catch (NullPointerException np) {
            return false;
        }
        toBeRemoved.removed();
        this.getChildren().remove(nodeName);
        return true;
    }

    public boolean remove(Entity entity) {
        entity.removed();
        return this.getEntities().remove(entity);
    }

    public void remove() {
        this.getParent().remove(this);
    }

    public int numberOfEntities() {
        int size = this.getEntities().size();
        for (Node child : this.getChildren().values()) {
            size += child.numberOfEntities();
        }
        return size;
    }

    public void removed() {
        for (Node child : this.getChildren().values()) {
            child.removed();
        }
        for (Entity entity : this.getEntities()) {
            entity.removed();
        }
        this.setEngine(null);
    }

    public <T extends Entity> T getEntity(Class<T> type) {
        if (this.singleEntityRetriever == null) {
            this.singleEntityRetriever = new SingleEntityRetriever();
        }
        this.singleEntityRetriever.scan(this);
        return this.singleEntityRetriever.get(type);
    }

    public void addToWorld(Node node) {
        if (this.getParent() != null) {
            this.getParent().addToWorld(node);
        } else {
            this.add(node);
        }
    }

    public String toString() {
        return "Node: " + this.name + " (" + this.getChildren().size() + " children; " + this.getEntities().size() + " entities)";
    }

    public Map<String, Node> getChildren() {
        return this.children;
    }

    public void setChildren(Map<String, Node> children) {
        this.children = children;
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public void setEntities(ArrayList<Entity> entities) {
        this.entities = entities;
    }

    public Transform getTransform() {
        return this.transform;
    }

    public void setTransform(Transform transform) {
        this.transform = transform;
    }

    @Override
    public CoreEngine getEngine() {
        return this.engine;
    }

    @Override
    public void setEngine(CoreEngine engine) {
        if (this.engine != engine) {
            this.engine = engine;
            for (Node child : this.children.values()) {
                child.setEngine(engine);
            }
            for (Entity e : this.entities) {
                e.setEngine(engine);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }
}

