/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.scenegraph;

import org.achtern.AchternEngine.core.scenegraph.Node;
import org.achtern.AchternEngine.core.scenegraph.entity.Entity;
import org.achtern.AchternEngine.core.util.Callback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortLifeNode
extends Node {
    protected final float maxLifeTime;
    protected float lifeTime;
    protected Mode mode;
    protected Callback<ShortLifeNode> deathCallback;

    public ShortLifeNode(String name, float maxLifeTime, Mode mode, Callback<ShortLifeNode> callback) {
        super(name);
        this.maxLifeTime = maxLifeTime;
        this.lifeTime = 0.0f;
        this.deathCallback = callback;
    }

    public ShortLifeNode(float maxLifeTime, Mode mode, Callback<ShortLifeNode> callback) {
        this.maxLifeTime = maxLifeTime;
        this.lifeTime = 0.0f;
        this.deathCallback = callback;
    }

    public ShortLifeNode(String name, float maxLifeTime) {
        this(name, maxLifeTime, Mode.DETACH, null);
    }

    public ShortLifeNode(float maxLifeTime) {
        this(maxLifeTime, Mode.DETACH, null);
    }

    @Override
    public void update(float delta) {
        super.update(delta);
        this.lifeTime += delta;
        if (this.lifeTime >= this.maxLifeTime) {
            if (this.getDeathCallback() != null) {
                this.getDeathCallback().call(this);
            }
            if (this.mode == Mode.DESTROY) {
                for (Entity e : this.getEntities()) {
                    e.destroy();
                }
            }
            this.getParent().remove(this);
        }
    }

    public Callback<ShortLifeNode> getDeathCallback() {
        return this.deathCallback;
    }

    public void setDeathCallback(Callback<ShortLifeNode> deathCallback) {
        this.deathCallback = deathCallback;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        DETACH,
        DESTROY;

    }
}

