/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.scenegraph.entity;

import org.achtern.AchternEngine.core.audio.openal.Audio;
import org.achtern.AchternEngine.core.audio.openal.AudioSource;
import org.achtern.AchternEngine.core.audio.openal.AudioSourceState;
import org.achtern.AchternEngine.core.audio.openal.binding.AudioPlayer;
import org.achtern.AchternEngine.core.audio.openal.trigger.AudioTrigger;
import org.achtern.AchternEngine.core.math.Vector3f;
import org.achtern.AchternEngine.core.scenegraph.entity.QuickEntity;

public class AudioEmitter
extends QuickEntity
implements Audio {
    public static final String NAME_UNTITLED_AUDIO_ENTITY = "Untitled AudioEmitter";
    protected AudioTrigger trigger;
    protected AudioSource audioSource;
    protected AudioPlayer audioPlayer;

    public AudioEmitter() {
        super(NAME_UNTITLED_AUDIO_ENTITY);
    }

    public void attached() {
        this.audioSource.setPosition(this.getTransform().getPosition());
        this.audioSource.setVelocity(Vector3f.ZERO);
        this.setAudioPlayer(this.getEngine().getBindingProvider().getAudioBindingProvider().getAudioPlayer());
    }

    public void update(float delta) {
        super.update(delta);
        this.audioSource.setPosition(this.getTransform().getPosition());
        AudioSourceState next = this.getTrigger().next(this.getAudioSource());
        if (!next.equals((Object)this.getAudioSource().getState())) {
            switch (next) {
                case PLAYING: {
                    this.getAudioPlayer().play(this.getAudioSource());
                    break;
                }
                case PAUSED: {
                    this.getAudioPlayer().pause(this.getAudioSource());
                    break;
                }
                case STOPPED: {
                    this.getAudioPlayer().stop(this.getAudioSource());
                }
            }
        }
        if (this.getAudioSource().getState().equals((Object)AudioSourceState.PLAYING)) {
            this.getAudioPlayer().getDataBinder().upload(this.getAudioSource());
        }
    }

    public AudioTrigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(AudioTrigger trigger) {
        this.trigger = trigger;
    }

    public AudioSource getAudioSource() {
        return this.audioSource;
    }

    public void setAudioSource(AudioSource audioSource) {
        this.audioSource = audioSource;
    }

    public AudioPlayer getAudioPlayer() {
        return this.audioPlayer;
    }

    public void setAudioPlayer(AudioPlayer audioPlayer) {
        this.audioPlayer = audioPlayer;
    }
}

