/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.scenegraph.entity;

import org.achtern.AchternEngine.core.CoreEngine;
import org.achtern.AchternEngine.core.Window;
import org.achtern.AchternEngine.core.math.Matrix4f;
import org.achtern.AchternEngine.core.math.Vector3f;
import org.achtern.AchternEngine.core.rendering.Dimension;
import org.achtern.AchternEngine.core.scenegraph.entity.QuickEntity;
import org.achtern.AchternEngine.core.util.WindowChangeListener;

public class Camera
extends QuickEntity
implements WindowChangeListener {
    protected float fov;
    protected float aspect;
    protected float zNear;
    protected float zFar;
    protected Matrix4f projection;

    public Camera(Matrix4f projection) {
        this.setProjection(projection);
    }

    public Camera() {
        this(Window.get());
    }

    public Camera(Dimension screen) {
        this(70.0f, (float)screen.getWidth() / (float)screen.getHeight());
    }

    public Camera(float fov, float aspect) {
        this(fov, aspect, 0.1f, 1000.0f);
    }

    public Camera(float fov, float aspect, float zNear, float zFar) {
        this.fov = fov;
        this.aspect = aspect;
        this.zNear = zNear;
        this.zFar = zFar;
        this.setMatrix(fov, aspect, zNear, zFar);
    }

    public Matrix4f getViewProjection() {
        Vector3f cameraPosition = this.getTransform().getTransformedPosition().mul(-1.0f);
        Matrix4f cameraRotMat = this.getTransform().getTransformedRotation().conjugate().toRotationMatrix();
        Matrix4f cameraTransMat = new Matrix4f().initTranslation(cameraPosition.getX(), cameraPosition.getY(), cameraPosition.getZ());
        return this.projection.mul(this.getView());
    }

    public Matrix4f getView() {
        Vector3f cameraPosition = this.getTransform().getTransformedPosition().mul(-1.0f);
        Matrix4f cameraRotMat = this.getTransform().getTransformedRotation().conjugate().toRotationMatrix();
        Matrix4f cameraTransMat = new Matrix4f().initTranslation(cameraPosition.getX(), cameraPosition.getY(), cameraPosition.getZ());
        return cameraRotMat.mul(cameraTransMat);
    }

    public void bindAsMain() {
        this.getEngine().getRenderEngine().setCamera(this);
    }

    public void setEngine(CoreEngine engine) {
        super.setEngine(engine);
        if (engine != null) {
            engine.getRenderEngine().setCamera(this);
            engine.addWindowChangeListener(this);
        }
    }

    public void removed() {
        super.removed();
        this.getEngine().getRenderEngine().setCamera(null);
        this.getEngine().removeWindowChangeListener(this);
    }

    public void setFov(float fov) {
        this.fov = fov;
        this.setMatrix(fov, this.aspect, this.zNear, this.zFar);
    }

    public void setAspect(float aspect) {
        this.aspect = aspect;
        this.setMatrix(this.fov, aspect, this.zNear, this.zFar);
    }

    public void setzNear(float zNear) {
        this.zNear = zNear;
        this.setMatrix(this.fov, this.aspect, zNear, this.zFar);
    }

    public void setzFar(float zFar) {
        this.zFar = zFar;
        this.setMatrix(this.fov, this.aspect, this.zNear, zFar);
    }

    protected void setMatrix(float fov, float aspect, float zNear, float zFar) {
        if (this.projection == null) {
            this.projection = new Matrix4f();
        }
        this.setProjection(this.projection.initPerspective((float)Math.toRadians(fov), aspect, zNear, zFar));
    }

    public void onWindowChange(Window window) {
        this.setAspect((float)window.getWidth() / (float)window.getHeight());
    }

    public float getFov() {
        return this.fov;
    }

    public float getAspect() {
        return this.aspect;
    }

    public float getZNear() {
        return this.zNear;
    }

    public float getZFar() {
        return this.zFar;
    }

    public void setProjection(Matrix4f projection) {
        this.projection = projection;
    }
}

