/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.scenegraph.entity;

import org.achtern.AchternEngine.core.rendering.Material;
import org.achtern.AchternEngine.core.rendering.PassFilter;
import org.achtern.AchternEngine.core.rendering.RenderEngine;
import org.achtern.AchternEngine.core.rendering.drawing.DrawStrategy;
import org.achtern.AchternEngine.core.rendering.drawing.DrawStrategyFactory;
import org.achtern.AchternEngine.core.rendering.mesh.Mesh;
import org.achtern.AchternEngine.core.rendering.shader.Shader;
import org.achtern.AchternEngine.core.scenegraph.Node;
import org.achtern.AchternEngine.core.scenegraph.entity.QuickEntity;

public class Figure
extends QuickEntity {
    protected Mesh mesh;
    protected Material material;
    protected DrawStrategy drawStrategy;

    public Figure(String name) {
        this(name, null);
    }

    public Figure(String name, Mesh mesh) {
        this(name, mesh, new Material());
    }

    public Figure(String name, Mesh mesh, Material material) {
        super(name);
        this.setMesh(mesh);
        this.setMaterial(material);
    }

    public Figure(Mesh mesh) {
        this(mesh, new Material());
    }

    public Figure(Mesh mesh, Material material) {
        this("Untitled Figure", mesh, material);
    }

    public void render(RenderEngine renderEngine) {
        Shader shader = renderEngine.getActiveRenderPass().getShader();
        if (!(renderEngine.getActiveRenderPass() instanceof PassFilter) && this.getMaterial().getShader() != null) {
            shader = this.getMaterial().getShader().getFor(renderEngine.getActiveRenderPass().getClass());
        }
        shader.updateUniforms(renderEngine, this);
        renderEngine.getDataBinder().bind(shader);
        DrawStrategy ds = this.getDrawStrategy();
        if (ds == null) {
            ds = renderEngine.getDrawStrategy();
        }
        if (this.getMaterial().isWireframe()) {
            ds = DrawStrategyFactory.get("wireframe");
        }
        ds.draw(renderEngine.getDataBinder(), this.mesh);
    }

    public Node boxed() {
        return new Node(this.getName()).add(this);
    }

    public int getVertexCount() {
        return this.getMesh().getVertexCount();
    }

    public Mesh getMesh() {
        return this.mesh;
    }

    public void setMesh(Mesh mesh) {
        this.mesh = mesh;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public DrawStrategy getDrawStrategy() {
        return this.drawStrategy;
    }

    public void setDrawStrategy(DrawStrategy drawStrategy) {
        this.drawStrategy = drawStrategy;
    }
}

