/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.scenegraph.entity;

import org.achtern.AchternEngine.core.math.Vector2f;
import org.achtern.AchternEngine.core.rendering.Color;
import org.achtern.AchternEngine.core.rendering.fog.Fog;
import org.achtern.AchternEngine.core.scenegraph.entity.GlobalEntity;
import org.achtern.AchternEngine.core.scenegraph.entity.QuickEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FogGenerator
extends QuickEntity
implements GlobalEntity<Fog> {
    public static final String DEFAULT_NAME = "Fog";
    protected Fog fog;

    public FogGenerator() {
        this(DEFAULT_NAME);
    }

    public FogGenerator(String name) {
        super(name);
        this.fog = new Fog(Color.WHITE, 0.01f);
    }

    public FogGenerator(Color color) {
        this(color, 0.01f);
    }

    public FogGenerator(Color color, float density) {
        this(color, density, Fog.Mode.EXP);
    }

    public FogGenerator(Color color, float density, Fog.Mode mode) {
        this(color, new Vector2f(-1.0f, -1.0f), density, mode);
    }

    public FogGenerator(Color color, Vector2f range) {
        this(color, range, -1.0f, Fog.Mode.LINEAR);
    }

    public FogGenerator(Color color, Vector2f range, float density, Fog.Mode mode) {
        super(DEFAULT_NAME);
        this.fog.setColor(color);
        this.fog.setRange(range);
        this.fog.setDensity(density);
        this.fog.setMode(mode);
    }

    public Color getColor() {
        return this.fog.getColor();
    }

    public void setColor(Color color) {
        this.fog.setColor(color);
    }

    public void setRange(Vector2f range) {
        this.fog.setRange(range);
    }

    public float getDensity() {
        return this.fog.getDensity();
    }

    public Vector2f getRange() {
        return this.fog.getRange();
    }

    public Fog.Mode getMode() {
        return this.fog.getMode();
    }

    public void setMode(Fog.Mode mode) {
        this.fog.setMode(mode);
    }

    public void setDensity(float density) {
        this.fog.setDensity(density);
    }

    @Override
    public Fog getObject() {
        return this.fog;
    }

    @Override
    public void attached() {
        super.attached();
        this.getEngine().getRenderEngine().addGlobal(this);
    }

    @Override
    public void removed() {
        super.removed();
        this.getEngine().getRenderEngine().removeGlobal(this);
    }

    public Fog getFog() {
        return this.fog;
    }
}

