/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.scenegraph.entity.controller;

import org.achtern.AchternEngine.core.Transform;
import org.achtern.AchternEngine.core.input.Key;
import org.achtern.AchternEngine.core.input.event.payload.KeyEvent;
import org.achtern.AchternEngine.core.math.Vector3f;
import org.achtern.AchternEngine.core.scenegraph.entity.controller.SimpleMover;

public class HumanMover
extends SimpleMover {
    public HumanMover(float speed) {
        super(speed);
    }

    public HumanMover(float speed, Key forwardKey, Key backKey, Key leftKey, Key rightKey) {
        super(speed, forwardKey, backKey, leftKey, rightKey);
    }

    public void onAction(KeyEvent event) {
        Vector3f horizontal = this.getTransform().getRotation().getForward().mul(Transform.X_AXIS.add(Transform.Z_AXIS)).normalized();
        float amt = this.getSpeed() * event.getDelta();
        if (event.getKey().equals((Object)this.forwardKey)) {
            this.move(horizontal, amt);
        } else if (event.getKey().equals((Object)this.backKey)) {
            this.move(horizontal, -amt);
        } else if (event.getKey().equals((Object)this.leftKey)) {
            this.move(this.getTransform().getRotation().getLeft(), amt);
        } else if (event.getKey().equals((Object)this.rightKey)) {
            this.move(this.getTransform().getRotation().getRight(), amt);
        }
    }
}

