/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.util;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import org.achtern.AchternEngine.core.math.Vector2f;
import org.achtern.AchternEngine.core.math.Vector3f;
import org.achtern.AchternEngine.core.rendering.Vertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TangentGenerator {
    public static void calculate(Vertex[] vertices, int[] indices) {
        for (int i = 0; i < indices.length; i += 3) {
            int i0 = indices[i];
            int i1 = indices[i + 1];
            int i2 = indices[i + 2];
            Vertex v0 = vertices[i0];
            Vertex v1 = vertices[i1];
            Vertex v2 = vertices[i2];
            Vector3f e1 = v1.getPos().sub(v0.getPos());
            Vector3f e2 = v2.getPos().sub(v0.getPos());
            TriangleDelta delta = TangentGenerator.getTriangleDelta(v0.getTexCor(), v1.getTexCor(), v2.getTexCor());
            Vector3f tangent = TangentGenerator.getTangent(delta, e1, e2);
            if (v0.getTangent() == null) {
                v0.setTangent(Vector3f.ZERO.get());
            }
            if (v1.getTangent() == null) {
                v1.setTangent(Vector3f.ZERO.get());
            }
            if (v2.getTangent() == null) {
                v2.setTangent(Vector3f.ZERO.get());
            }
            v0.getTangent().addLocal(tangent);
            v1.getTangent().addLocal(tangent);
            v2.getTangent().addLocal(tangent);
        }
        for (Vertex vertex : vertices) {
            vertex.getTangent().normalize();
        }
    }

    public static List<Vector3f> calculate(List<Vector3f> positions, List<Integer> indices, List<Vector2f> texCoords) {
        int i;
        ArrayList<Vector3f> tangents = new ArrayList<Vector3f>(indices.size());
        for (i = 0; i < indices.size(); ++i) {
            tangents.add(i, Vector3f.ZERO.get());
        }
        for (i = 0; i < indices.size(); i += 3) {
            int i0 = indices.get(i);
            int i1 = indices.get(i + 1);
            int i2 = indices.get(i + 2);
            Vector3f v0 = positions.get(i0);
            Vector3f v1 = positions.get(i1);
            Vector3f v2 = positions.get(i2);
            Vector2f tex0 = texCoords.get(i0);
            Vector2f tex1 = texCoords.get(i1);
            Vector2f tex2 = texCoords.get(i2);
            Vector3f e1 = v1.sub(v0);
            Vector3f e2 = v2.sub(v0);
            TriangleDelta delta = TangentGenerator.getTriangleDelta(tex0, tex1, tex2);
            Vector3f tangent = TangentGenerator.getTangent(delta, e1, e2);
            ((Vector3f)tangents.get(i)).addLocal(tangent);
            ((Vector3f)tangents.get(i + 1)).addLocal(tangent);
            ((Vector3f)tangents.get(i + 2)).addLocal(tangent);
        }
        return tangents;
    }

    protected static Vector3f getTangent(TriangleDelta delta, Vector3f e1, Vector3f e2) {
        float f = TangentGenerator.getFactor(delta);
        return new Vector3f(f * (delta.v2 * e1.getX() - delta.v1 * e2.getX()), f * (delta.v2 * e1.getY() - delta.v1 * e2.getY()), f * (delta.v2 * e1.getZ() - delta.v1 * e2.getZ()));
    }

    protected static float getFactor(TriangleDelta delta) {
        return 1.0f / (delta.u1 * delta.v2 - delta.u2 * delta.v1);
    }

    protected static TriangleDelta getTriangleDelta(Vector2f tex0, Vector2f tex1, Vector2f tex2) {
        return new TriangleDelta(tex1.getX() - tex0.getX(), tex1.getY() - tex0.getY(), tex2.getX() - tex0.getX(), tex2.getY() - tex0.getY());
    }

    static class TriangleDelta {
        float u1;
        float v1;
        float u2;
        float v2;

        @ConstructorProperties(value={"u1", "v1", "u2", "v2"})
        public TriangleDelta(float u1, float v1, float u2, float v2) {
            this.u1 = u1;
            this.v1 = v1;
            this.u2 = u2;
            this.v2 = v2;
        }

        public float getU1() {
            return this.u1;
        }

        public float getV1() {
            return this.v1;
        }

        public float getU2() {
            return this.u2;
        }

        public float getV2() {
            return this.v2;
        }

        public void setU1(float u1) {
            this.u1 = u1;
        }

        public void setV1(float v1) {
            this.v1 = v1;
        }

        public void setU2(float u2) {
            this.u2 = u2;
        }

        public void setV2(float v2) {
            this.v2 = v2;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TriangleDelta)) {
                return false;
            }
            TriangleDelta other = (TriangleDelta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Float.compare(this.getU1(), other.getU1()) != 0) {
                return false;
            }
            if (Float.compare(this.getV1(), other.getV1()) != 0) {
                return false;
            }
            if (Float.compare(this.getU2(), other.getU2()) != 0) {
                return false;
            }
            return Float.compare(this.getV2(), other.getV2()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof TriangleDelta;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getU1());
            result = result * 59 + Float.floatToIntBits(this.getV1());
            result = result * 59 + Float.floatToIntBits(this.getU2());
            result = result * 59 + Float.floatToIntBits(this.getV2());
            return result;
        }

        public String toString() {
            return "TangentGenerator.TriangleDelta(u1=" + this.getU1() + ", v1=" + this.getV1() + ", u2=" + this.getU2() + ", v2=" + this.getV2() + ")";
        }
    }
}

