/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.util;

import java.util.ArrayList;
import org.achtern.AchternEngine.core.math.Vector2f;
import org.achtern.AchternEngine.core.math.Vector3f;
import org.achtern.AchternEngine.core.rendering.Vertex;

public class UVertex {
    public static Vertex[] toArray(float[] positions) {
        ArrayList<Vertex> r = new ArrayList<Vertex>(positions.length / 3);
        for (int i = 0; i < positions.length; i += 3) {
            r.add(new Vertex(new Vector3f(positions[i], positions[i + 1], positions[i + 2])));
        }
        return r.toArray(new Vertex[r.size()]);
    }

    public static Vertex[] toArray(float[] positions, float[] texCoords) {
        Vertex[] r = UVertex.toArray(positions);
        for (int i = 0; i < texCoords.length; i += 2) {
            r[i].setTexCor(new Vector2f(texCoords[i], texCoords[i + 1]));
        }
        return r;
    }

    public static Vertex[] toArray(float[] positions, float[] texCoords, float[] normals) {
        Vertex[] r = UVertex.toArray(positions, texCoords);
        for (int i = 0; i < normals.length; i += 3) {
            r[i].setNormal(new Vector3f(texCoords[i], texCoords[i + 1], texCoords[i + 2]));
        }
        return r;
    }
}

