/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.util.random;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.achtern.AchternEngine.core.util.random.RandomNumberGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomItemSelector {
    public static <T> T getRandom(List<T> items) {
        return items.get(RandomNumberGenerator.getRandom(items.size()));
    }

    public static <T> T getRandom(Map<?, T> items) {
        return RandomItemSelector.getRandom(new ArrayList<T>(items.values()));
    }

    public static <T> T getSpecificRandom(Map<T, Float> items) {
        return RandomItemSelector.getSpecificRandom(items, 100);
    }

    public static <T> T getSpecificRandom(Map<T, Float> items, int resolution) {
        ArrayList<T> source = new ArrayList<T>(resolution);
        for (Map.Entry<T, Float> entry : items.entrySet()) {
            for (int i = 0; i < (int)((float)resolution * entry.getValue().floatValue()); ++i) {
                source.add(entry.getKey());
            }
        }
        return (T)RandomItemSelector.getRandom(source);
    }
}

