/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.lwjgl;

import org.achtern.AchternEngine.core.Window;
import org.achtern.AchternEngine.core.rendering.Dimension;
import org.achtern.AchternEngine.core.rendering.binding.DataBinder;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.openal.AL;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.PixelFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LWJGLWindow
extends Window {
    public static final Logger LOGGER = LoggerFactory.getLogger(LWJGLWindow.class);
    protected int drawBuffer;
    protected int readBuffer;

    public LWJGLWindow(Dimension copy) {
        super(copy);
        Window.instance = this;
    }

    public LWJGLWindow(int width, int height) {
        super(width, height);
        Window.instance = this;
    }

    public void create(String title) {
        this.setTitle(title);
        this.enableResize(true);
        PixelFormat pixelFormat = new PixelFormat();
        ContextAttribs contextAtrributes = new ContextAttribs(3, 2).withForwardCompatible(true).withProfileCore(true);
        try {
            Display.setDisplayMode((DisplayMode)new DisplayMode(this.getWidth(), this.getHeight()));
            Display.create((PixelFormat)pixelFormat, (ContextAttribs)contextAtrributes);
            Keyboard.create();
            Mouse.create();
            AL.create();
            this.drawBuffer = GL11.glGetInteger((int)3073);
            this.readBuffer = GL11.glGetInteger((int)3074);
        }
        catch (LWJGLException e) {
            LOGGER.error("Error setting up input and window", (Throwable)e);
        }
    }

    public void enableResize(boolean enable) {
        Display.setResizable((boolean)true);
    }

    public void render() {
        Display.update();
    }

    public boolean isCloseRequested() {
        return Display.isCloseRequested();
    }

    public boolean resized() {
        boolean rs = Display.wasResized();
        if (rs) {
            this.setWidth(Display.getWidth());
            this.setHeight(Display.getHeight());
        }
        return rs;
    }

    public void dispose() {
        Display.destroy();
        Keyboard.destroy();
        Mouse.destroy();
        AL.destroy();
    }

    public void bindAsRenderTarget(DataBinder binder) {
        if (binder.getState().getBoundFbo() == null && !this.resized()) {
            return;
        }
        binder.bindAsRenderTarget(null);
        GL30.glBindFramebuffer((int)36160, (int)0);
        GL11.glDrawBuffer((int)this.drawBuffer);
        GL11.glReadBuffer((int)this.readBuffer);
        GL30.glBindFramebuffer((int)36009, (int)0);
        GL11.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
    }

    public String getTitle() {
        return Display.getTitle();
    }

    public void setTitle(String title) {
        Display.setTitle((String)title);
    }
}

