/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.lwjgl.audio.openal.binding;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import org.achtern.AchternEngine.core.audio.openal.AudioSource;
import org.achtern.AchternEngine.core.audio.openal.AudioSourceState;
import org.achtern.AchternEngine.core.audio.openal.binding.AudioPlayer;
import org.achtern.AchternEngine.core.audio.openal.binding.DataBinder;
import org.achtern.AchternEngine.core.util.async.AsyncHandler;
import org.achtern.AchternEngine.lwjgl.audio.openal.binding.LWJGLDataBinder;
import org.lwjgl.openal.AL10;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LWJGLAudioPlayer
implements AudioPlayer {
    public static final Logger LOGGER = LoggerFactory.getLogger(AudioPlayer.class);
    protected LWJGLDataBinder dataBinder;
    protected Map<AudioSource, ScheduledFuture> futures = new HashMap<AudioSource, ScheduledFuture>();

    public LWJGLAudioPlayer(LWJGLDataBinder dataBinder) {
        this.dataBinder = dataBinder;
    }

    @Override
    public void play(final AudioSource source) {
        this.getDataBinder().upload(source);
        AL10.alSourcePlay((int)source.getID());
        this.updateState(source);
        if (source.isLoop()) {
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Adding future for {}, exec in {} seconds", (Object)source, (Object)Float.valueOf(source.getBuffer().getLengthInSeconds()));
        }
        this.addFuture(source, new AsyncHandler().postDelayed(new Runnable(){

            public void run() {
                LWJGLAudioPlayer.this.updateState(source);
            }
        }, (long)source.getBuffer().getLengthInSeconds() * 1000L));
    }

    @Override
    public void stop(AudioSource source) {
        if (source.getID() == -1) {
            throw new IllegalArgumentException("Source is not uploaded yet, thus cannot be running");
        }
        AL10.alSourceStop((int)source.getID());
        this.updateState(source);
        this.cancelFuture(source);
    }

    @Override
    public void rewind(AudioSource source) {
        if (source.getID() == -1) {
            throw new IllegalArgumentException("Source is not uploaded yet, thus cannot be running");
        }
        AL10.alSourceRewind((int)source.getID());
        this.updateState(source);
        this.cancelFuture(source);
    }

    @Override
    public void pause(AudioSource source) {
        if (source.getID() == -1) {
            throw new IllegalArgumentException("Source is not uploaded yet, thus cannot be running");
        }
        AL10.alSourcePause((int)source.getID());
        this.updateState(source);
        this.cancelFuture(source);
    }

    @Override
    public DataBinder getDataBinder() {
        return this.dataBinder;
    }

    protected void updateState(AudioSource source) {
        AudioSourceState state = this.getState(AL10.alGetSourcei((int)source.getID(), (int)4112));
        source.setState(state);
    }

    protected AudioSourceState getState(int code) {
        switch (code) {
            case 4114: {
                return AudioSourceState.PLAYING;
            }
            case 4116: {
                return AudioSourceState.STOPPED;
            }
            case 4115: {
                return AudioSourceState.PAUSED;
            }
        }
        return AudioSourceState.STOPPED;
    }

    protected void addFuture(AudioSource source, ScheduledFuture future) {
        this.getFutures().put(source, future);
    }

    protected void cancelFuture(AudioSource source) {
        if (this.getFutures().containsKey(source)) {
            LOGGER.trace("Canceling future for {}", (Object)source);
            boolean success = this.getFutures().get(source).cancel(true);
            if (!success && LOGGER.isDebugEnabled()) {
                LOGGER.debug("Future has already been canceled or by the engine stopped.");
            }
            this.getFutures().remove(source);
        }
    }

    protected Map<AudioSource, ScheduledFuture> getFutures() {
        return this.futures;
    }
}

