/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.lwjgl.audio.openal.binding;

import java.beans.ConstructorProperties;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.achtern.AchternEngine.core.audio.openal.AudioBuffer;
import org.achtern.AchternEngine.core.audio.openal.AudioListener;
import org.achtern.AchternEngine.core.audio.openal.AudioSource;
import org.achtern.AchternEngine.core.audio.openal.binding.DataBinder;
import org.achtern.AchternEngine.core.audio.openal.binding.IDGenerator;
import org.achtern.AchternEngine.core.math.Vector3f;
import org.achtern.AchternEngine.core.util.UBuffer;
import org.achtern.AchternEngine.lwjgl.audio.openal.binding.LWJGLIDGenerator;
import org.achtern.AchternEngine.lwjgl.util.GLEnum;
import org.lwjgl.openal.AL10;

public class LWJGLDataBinder
implements DataBinder {
    protected LWJGLIDGenerator idGen;

    public void upload(AudioBuffer buffer) {
        if (buffer.getID() == -1) {
            this.idGen.generate(buffer);
        }
        AL10.alBufferData((int)buffer.getID(), (int)GLEnum.getGLEnum(buffer.getFormat()), (ByteBuffer)buffer.getData(), (int)buffer.getFrequency());
    }

    public void upload(AudioSource source) {
        if (source.getID() == -1) {
            this.idGen.generate(source);
        }
        this.uploadIf(source.getBuffer());
        int id = source.getID();
        AL10.alSourcei((int)id, (int)4105, (int)source.getBuffer().getID());
        boolean relative = source.isRelative();
        AL10.alSourcei((int)id, (int)514, (int)(relative ? 1 : 0));
        AL10.alSourcei((int)id, (int)513, (int)(relative ? 0 : 1));
        Vector3f pos = source.getPosition();
        AL10.alSource3f((int)id, (int)4100, (float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
        Vector3f vel = source.getVelocity();
        AL10.alSource3f((int)id, (int)4102, (float)vel.getX(), (float)vel.getY(), (float)vel.getZ());
        boolean loop = source.isLoop();
        AL10.alSourcei((int)id, (int)4103, (int)(loop ? 1 : 0));
        AL10.alSourcef((int)id, (int)4106, (float)source.getGain());
    }

    public void upload(AudioListener listener) {
        AL10.alListener3f((int)4100, (float)listener.getPosition().getX(), (float)listener.getPosition().getY(), (float)listener.getPosition().getZ());
        AL10.alListener3f((int)4102, (float)listener.getVelocity().getX(), (float)listener.getVelocity().getY(), (float)listener.getVelocity().getZ());
        AL10.alListener((int)4111, (FloatBuffer)((FloatBuffer)UBuffer.createFloatBuffer(6).put(new float[]{-listener.getForward().getX(), -listener.getForward().getY(), -listener.getForward().getZ(), listener.getUp().getX(), listener.getUp().getY(), listener.getUp().getZ()}).rewind()));
    }

    private void uploadIf(AudioBuffer buffer) {
        if (buffer.getID() == -1) {
            this.upload(buffer);
        }
    }

    public IDGenerator getIDGenerator() {
        return this.idGen;
    }

    @ConstructorProperties(value={"idGen"})
    public LWJGLDataBinder(LWJGLIDGenerator idGen) {
        this.idGen = idGen;
    }
}

