/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.lwjgl.input;

import java.util.HashMap;
import java.util.Map;
import org.achtern.AchternEngine.core.input.Key;
import org.achtern.AchternEngine.core.input.MouseButton;
import org.achtern.AchternEngine.core.input.adapter.InputAdapter;
import org.achtern.AchternEngine.core.math.Vector2f;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class LWJGLInput
implements InputAdapter {
    public static final int NUM_KEYCODES = 256;
    public static final int NUM_MOUSEBUTTONS = 5;
    public static final int NONE = 0;
    public static final int ESCAPE = 1;
    public static final int N_1 = 2;
    public static final int N_2 = 3;
    public static final int N_3 = 4;
    public static final int N_4 = 5;
    public static final int N_5 = 6;
    public static final int N_6 = 7;
    public static final int N_7 = 8;
    public static final int N_8 = 9;
    public static final int N_9 = 10;
    public static final int N_0 = 11;
    public static final int MINUS = 12;
    public static final int EQUALS = 13;
    public static final int BACK = 14;
    public static final int TAB = 15;
    public static final int Q = 16;
    public static final int W = 17;
    public static final int E = 18;
    public static final int R = 19;
    public static final int T = 20;
    public static final int Y = 21;
    public static final int U = 22;
    public static final int I = 23;
    public static final int O = 24;
    public static final int P = 25;
    public static final int LBRACKET = 26;
    public static final int RBRACKET = 27;
    public static final int RETURN = 28;
    public static final int LCONTROL = 29;
    public static final int A = 30;
    public static final int S = 31;
    public static final int D = 32;
    public static final int F = 33;
    public static final int G = 34;
    public static final int H = 35;
    public static final int J = 36;
    public static final int K = 37;
    public static final int L = 38;
    public static final int SEMICOLON = 39;
    public static final int APOSTROPHE = 40;
    public static final int GRAVE = 41;
    public static final int LSHIFT = 42;
    public static final int BACKSLASH = 43;
    public static final int Z = 44;
    public static final int X = 45;
    public static final int C = 46;
    public static final int V = 47;
    public static final int B = 48;
    public static final int N = 49;
    public static final int M = 50;
    public static final int COMMA = 51;
    public static final int PERIOD = 52;
    public static final int SLASH = 53;
    public static final int RSHIFT = 54;
    public static final int MULTIPLY = 55;
    public static final int LMENU = 56;
    public static final int LALT = 56;
    public static final int SPACE = 57;
    public static final int CAPITAL = 58;
    public static final int F1 = 59;
    public static final int F2 = 60;
    public static final int F3 = 61;
    public static final int F4 = 62;
    public static final int F5 = 63;
    public static final int F6 = 64;
    public static final int F7 = 65;
    public static final int F8 = 66;
    public static final int F9 = 67;
    public static final int F10 = 68;
    public static final int NUMLOCK = 69;
    public static final int SCROLL = 70;
    public static final int NUMPAD7 = 71;
    public static final int NUMPAD8 = 72;
    public static final int NUMPAD9 = 73;
    public static final int SUBTRACT = 74;
    public static final int NUMPAD4 = 75;
    public static final int NUMPAD5 = 76;
    public static final int NUMPAD6 = 77;
    public static final int ADD = 78;
    public static final int NUMPAD1 = 79;
    public static final int NUMPAD2 = 80;
    public static final int NUMPAD3 = 81;
    public static final int NUMPAD0 = 82;
    public static final int DECIMAL = 83;
    public static final int F11 = 87;
    public static final int F12 = 88;
    public static final int F13 = 100;
    public static final int F14 = 101;
    public static final int F15 = 102;
    public static final int KANA = 112;
    public static final int CONVERT = 121;
    public static final int NOCONVERT = 123;
    public static final int YEN = 125;
    public static final int NUMPADEQUALS = 141;
    public static final int CIRCUMFLEX = 144;
    public static final int AT = 145;
    public static final int COLON = 146;
    public static final int UNDERLINE = 147;
    public static final int KANJI = 148;
    public static final int STOP = 149;
    public static final int AX = 150;
    public static final int UNLABELED = 151;
    public static final int NUMPADENTER = 156;
    public static final int RCONTROL = 157;
    public static final int NUMPADCOMMA = 179;
    public static final int DIVIDE = 181;
    public static final int SYSRQ = 183;
    public static final int RMENU = 184;
    public static final int RALT = 184;
    public static final int PAUSE = 197;
    public static final int HOME = 199;
    public static final int UP = 200;
    public static final int PRIOR = 201;
    public static final int LEFT = 203;
    public static final int RIGHT = 205;
    public static final int END = 207;
    public static final int DOWN = 208;
    public static final int NEXT = 209;
    public static final int INSERT = 210;
    public static final int DELETE = 211;
    public static final int LMETA = 219;
    public static final int LWIN = 219;
    public static final int RMETA = 220;
    public static final int RWIN = 220;
    public static final int APPS = 221;
    public static final int POWER = 222;
    public static final int SLEEP = 223;
    public static final Map<Key, Integer> keyIntegerMap = new HashMap<Key, Integer>(256);
    public static final Map<Integer, Key> integerKeyMap = new HashMap<Integer, Key>(256);
    public static final Map<MouseButton, Integer> buttonIntegerMap = new HashMap<MouseButton, Integer>(5);
    public static final Map<Integer, MouseButton> integerButtonMap = new HashMap<Integer, MouseButton>(5);
    private boolean[] lastKeys = new boolean[256];
    private boolean[] lastMouse = new boolean[5];

    public void update() {
        int i;
        for (i = 0; i < 256; ++i) {
            this.lastKeys[i] = this.getKey(i);
        }
        for (i = 0; i < 5; ++i) {
            this.lastMouse[i] = this.getMouse(i);
        }
    }

    public int keysTotal() {
        return 256;
    }

    public boolean getKey(Key key) {
        return this.getKey(this.toInt(key));
    }

    protected boolean getKey(int keyCode) {
        return Keyboard.isKeyDown((int)keyCode);
    }

    public boolean getKeyDown(Key key) {
        return this.getKey(key) && !this.lastKeys[this.toInt(key)];
    }

    public boolean getKeyUp(Key key) {
        return !this.getKey(key) && this.lastKeys[this.toInt(key)];
    }

    public boolean getMouse(MouseButton mouseButton) {
        return this.getMouse(this.toInt(mouseButton));
    }

    protected boolean getMouse(int mouseButton) {
        return Mouse.isButtonDown((int)mouseButton);
    }

    public boolean getMouseDown(MouseButton mouseButton) {
        return this.getMouse(mouseButton) && !this.lastMouse[this.toInt(mouseButton)];
    }

    public boolean getMouseUp(MouseButton mouseButton) {
        return !this.getMouse(mouseButton) && this.lastMouse[this.toInt(mouseButton)];
    }

    public Vector2f getMousePosition() {
        return new Vector2f(Mouse.getX(), Mouse.getY());
    }

    public void setMousePosition(Vector2f position) {
        Mouse.setCursorPosition((int)((int)position.getX()), (int)((int)position.getY()));
    }

    public Vector2f getMouseDelta() {
        return new Vector2f(Mouse.getDX(), Mouse.getDY());
    }

    public void setCursor(boolean enabled) {
        Mouse.setGrabbed((!enabled ? 1 : 0) != 0);
    }

    protected int toInt(Key key) {
        if (key == null) {
            return 0;
        }
        return keyIntegerMap.get((Object)key);
    }

    protected Key toKey(int key) {
        Key k = integerKeyMap.get(key);
        if (k == null) {
            k = Key.NONE;
        }
        return k;
    }

    protected int toInt(MouseButton button) {
        if (button == null) {
            return -1;
        }
        return buttonIntegerMap.get((Object)button);
    }

    protected MouseButton toButton(int key) {
        MouseButton b = integerButtonMap.get(key);
        if (b == null) {
            b = MouseButton.INVALID;
        }
        return b;
    }

    static {
        buttonIntegerMap.put(MouseButton.LEFT, 0);
        buttonIntegerMap.put(MouseButton.RIGHT, 1);
        buttonIntegerMap.put(MouseButton.MIDDLE, 2);
        integerButtonMap.put(0, MouseButton.LEFT);
        integerButtonMap.put(1, MouseButton.RIGHT);
        integerButtonMap.put(2, MouseButton.MIDDLE);
        keyIntegerMap.put(Key.NONE, 0);
        keyIntegerMap.put(Key.ESCAPE, 1);
        keyIntegerMap.put(Key.N_1, 2);
        keyIntegerMap.put(Key.N_2, 3);
        keyIntegerMap.put(Key.N_3, 4);
        keyIntegerMap.put(Key.N_4, 5);
        keyIntegerMap.put(Key.N_5, 6);
        keyIntegerMap.put(Key.N_6, 7);
        keyIntegerMap.put(Key.N_7, 8);
        keyIntegerMap.put(Key.N_8, 9);
        keyIntegerMap.put(Key.N_9, 10);
        keyIntegerMap.put(Key.N_0, 11);
        keyIntegerMap.put(Key.MINUS, 12);
        keyIntegerMap.put(Key.EQUALS, 13);
        keyIntegerMap.put(Key.BACK, 14);
        keyIntegerMap.put(Key.TAB, 15);
        keyIntegerMap.put(Key.Q, 16);
        keyIntegerMap.put(Key.W, 17);
        keyIntegerMap.put(Key.E, 18);
        keyIntegerMap.put(Key.R, 19);
        keyIntegerMap.put(Key.T, 20);
        keyIntegerMap.put(Key.Y, 21);
        keyIntegerMap.put(Key.U, 22);
        keyIntegerMap.put(Key.I, 23);
        keyIntegerMap.put(Key.O, 24);
        keyIntegerMap.put(Key.P, 25);
        keyIntegerMap.put(Key.LBRACKET, 26);
        keyIntegerMap.put(Key.RBRACKET, 27);
        keyIntegerMap.put(Key.RETURN, 28);
        keyIntegerMap.put(Key.LCONTROL, 29);
        keyIntegerMap.put(Key.A, 30);
        keyIntegerMap.put(Key.S, 31);
        keyIntegerMap.put(Key.D, 32);
        keyIntegerMap.put(Key.F, 33);
        keyIntegerMap.put(Key.G, 34);
        keyIntegerMap.put(Key.H, 35);
        keyIntegerMap.put(Key.J, 36);
        keyIntegerMap.put(Key.K, 37);
        keyIntegerMap.put(Key.L, 38);
        keyIntegerMap.put(Key.SEMICOLON, 39);
        keyIntegerMap.put(Key.APOSTROPHE, 40);
        keyIntegerMap.put(Key.GRAVE, 41);
        keyIntegerMap.put(Key.LSHIFT, 42);
        keyIntegerMap.put(Key.BACKSLASH, 43);
        keyIntegerMap.put(Key.Z, 44);
        keyIntegerMap.put(Key.X, 45);
        keyIntegerMap.put(Key.C, 46);
        keyIntegerMap.put(Key.V, 47);
        keyIntegerMap.put(Key.B, 48);
        keyIntegerMap.put(Key.N, 49);
        keyIntegerMap.put(Key.M, 50);
        keyIntegerMap.put(Key.COMMA, 51);
        keyIntegerMap.put(Key.PERIOD, 52);
        keyIntegerMap.put(Key.SLASH, 53);
        keyIntegerMap.put(Key.RSHIFT, 54);
        keyIntegerMap.put(Key.MULTIPLY, 55);
        keyIntegerMap.put(Key.LMENU, 56);
        keyIntegerMap.put(Key.LALT, 56);
        keyIntegerMap.put(Key.SPACE, 57);
        keyIntegerMap.put(Key.CAPITAL, 58);
        keyIntegerMap.put(Key.F1, 59);
        keyIntegerMap.put(Key.F2, 60);
        keyIntegerMap.put(Key.F3, 61);
        keyIntegerMap.put(Key.F4, 62);
        keyIntegerMap.put(Key.F5, 63);
        keyIntegerMap.put(Key.F6, 64);
        keyIntegerMap.put(Key.F7, 65);
        keyIntegerMap.put(Key.F8, 66);
        keyIntegerMap.put(Key.F9, 67);
        keyIntegerMap.put(Key.F10, 68);
        keyIntegerMap.put(Key.NUMLOCK, 69);
        keyIntegerMap.put(Key.SCROLL, 70);
        keyIntegerMap.put(Key.NUMPAD7, 71);
        keyIntegerMap.put(Key.NUMPAD8, 72);
        keyIntegerMap.put(Key.NUMPAD9, 73);
        keyIntegerMap.put(Key.SUBTRACT, 74);
        keyIntegerMap.put(Key.NUMPAD4, 75);
        keyIntegerMap.put(Key.NUMPAD5, 76);
        keyIntegerMap.put(Key.NUMPAD6, 77);
        keyIntegerMap.put(Key.ADD, 78);
        keyIntegerMap.put(Key.NUMPAD1, 79);
        keyIntegerMap.put(Key.NUMPAD2, 80);
        keyIntegerMap.put(Key.NUMPAD3, 81);
        keyIntegerMap.put(Key.NUMPAD0, 82);
        keyIntegerMap.put(Key.DECIMAL, 83);
        keyIntegerMap.put(Key.F11, 87);
        keyIntegerMap.put(Key.F12, 88);
        keyIntegerMap.put(Key.F13, 100);
        keyIntegerMap.put(Key.F14, 101);
        keyIntegerMap.put(Key.F15, 102);
        keyIntegerMap.put(Key.KANA, 112);
        keyIntegerMap.put(Key.CONVERT, 121);
        keyIntegerMap.put(Key.NOCONVERT, 123);
        keyIntegerMap.put(Key.YEN, 125);
        keyIntegerMap.put(Key.NUMPADEQUALS, 141);
        keyIntegerMap.put(Key.CIRCUMFLEX, 144);
        keyIntegerMap.put(Key.AT, 145);
        keyIntegerMap.put(Key.COLON, 146);
        keyIntegerMap.put(Key.UNDERLINE, 147);
        keyIntegerMap.put(Key.KANJI, 148);
        keyIntegerMap.put(Key.STOP, 149);
        keyIntegerMap.put(Key.AX, 150);
        keyIntegerMap.put(Key.UNLABELED, 151);
        keyIntegerMap.put(Key.NUMPADENTER, 156);
        keyIntegerMap.put(Key.RCONTROL, 157);
        keyIntegerMap.put(Key.NUMPADCOMMA, 179);
        keyIntegerMap.put(Key.DIVIDE, 181);
        keyIntegerMap.put(Key.SYSRQ, 183);
        keyIntegerMap.put(Key.RMENU, 184);
        keyIntegerMap.put(Key.RALT, 184);
        keyIntegerMap.put(Key.PAUSE, 197);
        keyIntegerMap.put(Key.HOME, 199);
        keyIntegerMap.put(Key.UP, 200);
        keyIntegerMap.put(Key.PRIOR, 201);
        keyIntegerMap.put(Key.LEFT, 203);
        keyIntegerMap.put(Key.RIGHT, 205);
        keyIntegerMap.put(Key.END, 207);
        keyIntegerMap.put(Key.DOWN, 208);
        keyIntegerMap.put(Key.NEXT, 209);
        keyIntegerMap.put(Key.INSERT, 210);
        keyIntegerMap.put(Key.DELETE, 211);
        keyIntegerMap.put(Key.LMETA, 219);
        keyIntegerMap.put(Key.LWIN, 219);
        keyIntegerMap.put(Key.RMETA, 220);
        keyIntegerMap.put(Key.RWIN, 220);
        keyIntegerMap.put(Key.APPS, 221);
        keyIntegerMap.put(Key.POWER, 222);
        keyIntegerMap.put(Key.SLEEP, 223);
        integerKeyMap.put(0, Key.NONE);
        integerKeyMap.put(1, Key.ESCAPE);
        integerKeyMap.put(2, Key.N_1);
        integerKeyMap.put(3, Key.N_2);
        integerKeyMap.put(4, Key.N_3);
        integerKeyMap.put(5, Key.N_4);
        integerKeyMap.put(6, Key.N_5);
        integerKeyMap.put(7, Key.N_6);
        integerKeyMap.put(8, Key.N_7);
        integerKeyMap.put(9, Key.N_8);
        integerKeyMap.put(10, Key.N_9);
        integerKeyMap.put(11, Key.N_0);
        integerKeyMap.put(12, Key.MINUS);
        integerKeyMap.put(13, Key.EQUALS);
        integerKeyMap.put(14, Key.BACK);
        integerKeyMap.put(15, Key.TAB);
        integerKeyMap.put(16, Key.Q);
        integerKeyMap.put(17, Key.W);
        integerKeyMap.put(18, Key.E);
        integerKeyMap.put(19, Key.R);
        integerKeyMap.put(20, Key.T);
        integerKeyMap.put(21, Key.Y);
        integerKeyMap.put(22, Key.U);
        integerKeyMap.put(23, Key.I);
        integerKeyMap.put(24, Key.O);
        integerKeyMap.put(25, Key.P);
        integerKeyMap.put(26, Key.LBRACKET);
        integerKeyMap.put(27, Key.RBRACKET);
        integerKeyMap.put(28, Key.RETURN);
        integerKeyMap.put(29, Key.LCONTROL);
        integerKeyMap.put(30, Key.A);
        integerKeyMap.put(31, Key.S);
        integerKeyMap.put(32, Key.D);
        integerKeyMap.put(33, Key.F);
        integerKeyMap.put(34, Key.G);
        integerKeyMap.put(35, Key.H);
        integerKeyMap.put(36, Key.J);
        integerKeyMap.put(37, Key.K);
        integerKeyMap.put(38, Key.L);
        integerKeyMap.put(39, Key.SEMICOLON);
        integerKeyMap.put(40, Key.APOSTROPHE);
        integerKeyMap.put(41, Key.GRAVE);
        integerKeyMap.put(42, Key.LSHIFT);
        integerKeyMap.put(43, Key.BACKSLASH);
        integerKeyMap.put(44, Key.Z);
        integerKeyMap.put(45, Key.X);
        integerKeyMap.put(46, Key.C);
        integerKeyMap.put(47, Key.V);
        integerKeyMap.put(48, Key.B);
        integerKeyMap.put(49, Key.N);
        integerKeyMap.put(50, Key.M);
        integerKeyMap.put(51, Key.COMMA);
        integerKeyMap.put(52, Key.PERIOD);
        integerKeyMap.put(53, Key.SLASH);
        integerKeyMap.put(54, Key.RSHIFT);
        integerKeyMap.put(55, Key.MULTIPLY);
        integerKeyMap.put(56, Key.LMENU);
        integerKeyMap.put(56, Key.LALT);
        integerKeyMap.put(57, Key.SPACE);
        integerKeyMap.put(58, Key.CAPITAL);
        integerKeyMap.put(59, Key.F1);
        integerKeyMap.put(60, Key.F2);
        integerKeyMap.put(61, Key.F3);
        integerKeyMap.put(62, Key.F4);
        integerKeyMap.put(63, Key.F5);
        integerKeyMap.put(64, Key.F6);
        integerKeyMap.put(65, Key.F7);
        integerKeyMap.put(66, Key.F8);
        integerKeyMap.put(67, Key.F9);
        integerKeyMap.put(68, Key.F10);
        integerKeyMap.put(69, Key.NUMLOCK);
        integerKeyMap.put(70, Key.SCROLL);
        integerKeyMap.put(71, Key.NUMPAD7);
        integerKeyMap.put(72, Key.NUMPAD8);
        integerKeyMap.put(73, Key.NUMPAD9);
        integerKeyMap.put(74, Key.SUBTRACT);
        integerKeyMap.put(75, Key.NUMPAD4);
        integerKeyMap.put(76, Key.NUMPAD5);
        integerKeyMap.put(77, Key.NUMPAD6);
        integerKeyMap.put(78, Key.ADD);
        integerKeyMap.put(79, Key.NUMPAD1);
        integerKeyMap.put(80, Key.NUMPAD2);
        integerKeyMap.put(81, Key.NUMPAD3);
        integerKeyMap.put(82, Key.NUMPAD0);
        integerKeyMap.put(83, Key.DECIMAL);
        integerKeyMap.put(87, Key.F11);
        integerKeyMap.put(88, Key.F12);
        integerKeyMap.put(100, Key.F13);
        integerKeyMap.put(101, Key.F14);
        integerKeyMap.put(102, Key.F15);
        integerKeyMap.put(112, Key.KANA);
        integerKeyMap.put(121, Key.CONVERT);
        integerKeyMap.put(123, Key.NOCONVERT);
        integerKeyMap.put(125, Key.YEN);
        integerKeyMap.put(141, Key.NUMPADEQUALS);
        integerKeyMap.put(144, Key.CIRCUMFLEX);
        integerKeyMap.put(145, Key.AT);
        integerKeyMap.put(146, Key.COLON);
        integerKeyMap.put(147, Key.UNDERLINE);
        integerKeyMap.put(148, Key.KANJI);
        integerKeyMap.put(149, Key.STOP);
        integerKeyMap.put(150, Key.AX);
        integerKeyMap.put(151, Key.UNLABELED);
        integerKeyMap.put(156, Key.NUMPADENTER);
        integerKeyMap.put(157, Key.RCONTROL);
        integerKeyMap.put(179, Key.NUMPADCOMMA);
        integerKeyMap.put(181, Key.DIVIDE);
        integerKeyMap.put(183, Key.SYSRQ);
        integerKeyMap.put(184, Key.RMENU);
        integerKeyMap.put(184, Key.RALT);
        integerKeyMap.put(197, Key.PAUSE);
        integerKeyMap.put(199, Key.HOME);
        integerKeyMap.put(200, Key.UP);
        integerKeyMap.put(201, Key.PRIOR);
        integerKeyMap.put(203, Key.LEFT);
        integerKeyMap.put(205, Key.RIGHT);
        integerKeyMap.put(207, Key.END);
        integerKeyMap.put(208, Key.DOWN);
        integerKeyMap.put(209, Key.NEXT);
        integerKeyMap.put(210, Key.INSERT);
        integerKeyMap.put(211, Key.DELETE);
        integerKeyMap.put(219, Key.LMETA);
        integerKeyMap.put(219, Key.LWIN);
        integerKeyMap.put(220, Key.RMETA);
        integerKeyMap.put(220, Key.RWIN);
        integerKeyMap.put(221, Key.APPS);
        integerKeyMap.put(222, Key.POWER);
        integerKeyMap.put(223, Key.SLEEP);
    }
}

