/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.lwjgl.rendering.binding;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.achtern.AchternEngine.core.rendering.binding.DataBinder;
import org.achtern.AchternEngine.core.rendering.binding.IDGenerator;
import org.achtern.AchternEngine.core.rendering.binding.UniformManager;
import org.achtern.AchternEngine.core.rendering.exception.FrameBufferException;
import org.achtern.AchternEngine.core.rendering.framebuffer.FrameBuffer;
import org.achtern.AchternEngine.core.rendering.framebuffer.RenderBuffer;
import org.achtern.AchternEngine.core.rendering.mesh.Mesh;
import org.achtern.AchternEngine.core.rendering.mesh.MeshData;
import org.achtern.AchternEngine.core.rendering.shader.Shader;
import org.achtern.AchternEngine.core.rendering.state.RenderEngineState;
import org.achtern.AchternEngine.core.rendering.texture.Texture;
import org.achtern.AchternEngine.core.resource.fileparser.GLSLProgram;
import org.achtern.AchternEngine.core.resource.fileparser.caseclasses.GLSLScript;
import org.achtern.AchternEngine.core.resource.fileparser.caseclasses.Variable;
import org.achtern.AchternEngine.core.util.UBuffer;
import org.achtern.AchternEngine.lwjgl.rendering.binding.LWJGLIDGenerator;
import org.achtern.AchternEngine.lwjgl.rendering.binding.LWJGLUniformManager;
import org.achtern.AchternEngine.lwjgl.util.GLEnum;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LWJGLDataBinder
implements DataBinder {
    public static final Logger LOGGER = LoggerFactory.getLogger(DataBinder.class);
    protected LWJGLIDGenerator idGen;
    protected LWJGLUniformManager uniformManager;
    protected RenderEngineState state;
    private IntBuffer intBuffer = UBuffer.createIntBuffer(16);

    public LWJGLDataBinder(RenderEngineState state) {
        this.state = state;
        this.idGen = new LWJGLIDGenerator();
        this.uniformManager = new LWJGLUniformManager();
    }

    public void bind(Texture texture) {
        this.bind(texture, 0);
    }

    public void bind(Texture texture, int samplerslot) {
        if (samplerslot < 0) {
            throw new IllegalArgumentException("SamplerSlot MUST be a positive integer!");
        }
        if (texture.getID() == -1) {
            this.getIDGenerator().generate(texture);
            this.upload(texture);
        }
        if (this.state.getBoundTexture() != null && this.state.getBoundTexture().getID() == texture.getID()) {
            return;
        }
        int type = GLEnum.getGLEnum(texture.getType());
        LOGGER.trace("Calling glActiveTexture({})", (Object)(33984 + samplerslot));
        GL13.glActiveTexture((int)(33984 + samplerslot));
        LOGGER.trace("Calling glBindTexture({}, {})", (Object)type, (Object)texture.getID());
        GL11.glBindTexture((int)type, (int)texture.getID());
        this.state.setBound(texture);
    }

    public void upload(Texture texture) {
        this.bind(texture);
        int type = GLEnum.getGLEnum(texture.getType());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Calling glTexParamteri() 4 times, CLAMP_TO_EDGE and MIN/MAG Filter {}/{}", (Object)GLEnum.getGLEnum(texture.getMinFilter()), (Object)GLEnum.getGLEnum(texture.getMagFilter()));
        }
        GL11.glTexParameteri((int)type, (int)10242, (int)33071);
        GL11.glTexParameteri((int)type, (int)10243, (int)33071);
        GL11.glTexParameteri((int)type, (int)10241, (int)GLEnum.getGLEnum(texture.getMinFilter()));
        GL11.glTexParameteri((int)type, (int)10240, (int)GLEnum.getGLEnum(texture.getMagFilter()));
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Calling glTexImage2D({}, 0, {}, {}, {}, 0, {}, GL_UNSIGNED_BYTE, {})", new Object[]{type, 0, GLEnum.getGLEnum(texture.getInternalFormat()), texture.getDimension().getWidth(), texture.getDimension().getHeight(), GLEnum.getGLEnum(texture.getFormat()), texture.getData()});
        }
        GL11.glTexImage2D((int)type, (int)0, (int)GLEnum.getGLEnum(texture.getInternalFormat()), (int)texture.getDimension().getWidth(), (int)texture.getDimension().getHeight(), (int)0, (int)GLEnum.getGLEnum(texture.getFormat()), (int)5121, (ByteBuffer)texture.getData());
        LOGGER.trace("Calling glTexParamteri({}, GL_TEXTURE_BASE_LEVEL, 0)", (Object)type);
        GL11.glTexParameteri((int)type, (int)33084, (int)0);
        LOGGER.trace("Calling glTexParamteri({}, GL_TEXTURE_MAX_LEVEL, 0)", (Object)type);
        GL11.glTexParameteri((int)type, (int)33085, (int)0);
    }

    public void bind(Mesh mesh) {
        if (mesh == null) {
            LOGGER.trace("Calling glBindVertexArray(0)");
            GL30.glBindVertexArray((int)0);
        } else {
            int id = mesh.getData().getID();
            if (this.state.getBoundMesh() != null && this.state.getBoundMesh().getData().getID() == id) {
                return;
            }
            LOGGER.trace("Calling glBindVertexArray({})", (Object)id);
            GL30.glBindVertexArray((int)id);
        }
        this.state.setBound(mesh);
    }

    public void upload(Mesh mesh) {
        MeshData data = mesh.getData();
        if (data.getID() != -1) {
            LOGGER.warn("MeshData already uploaded to context. Re-uploading...");
        }
        this.getIDGenerator().generate(mesh);
        this.bind(mesh);
        LOGGER.trace("Calling glBindBuffer(GL_ARRAY_BUFFER, {})", (Object)data.getVbo());
        GL15.glBindBuffer((int)34962, (int)data.getVbo());
        LOGGER.trace("Calling glBufferData(GL_ARRAY_BUFFER, <data=vertices>, GL_STATIC_DRAW)");
        GL15.glBufferData((int)34962, (FloatBuffer)((FloatBuffer)UBuffer.create(data.getVertices()).flip()), (int)35044);
        LOGGER.trace("Calling glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, {})", (Object)data.getIbo());
        GL15.glBindBuffer((int)34963, (int)data.getIbo());
        LOGGER.trace("Calling glBufferData(GL_ELEMENT_ARRAY_BUFFER, <data=indices>, GL_STATIC_DRAW)");
        GL15.glBufferData((int)34963, (IntBuffer)((IntBuffer)UBuffer.create(data.getIndices()).flip()), (int)35044);
        LOGGER.trace("Calling glVertexAttribPointer(0, 3, GL_FLOAT, false, Vertex.SIZE * 4 = {}, 0)", (Object)44);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)44, (long)0L);
        LOGGER.trace("Calling glVertexAttribPointer(1, 2, GL_FLOAT, false, Vertex.SIZE * 4 = {}, 12)", (Object)44);
        GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)44, (long)12L);
        LOGGER.trace("Calling glVertexAttribPointer(2, 3, GL_FLOAT, false, Vertex.SIZE * 4 = {}, 20)", (Object)44);
        GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)44, (long)20L);
        LOGGER.trace("Calling glVertexAttribPointer(3, 3, GL_FLOAT, false, Vertex.SIZE * 4 = {}, 32)", (Object)44);
        GL20.glVertexAttribPointer((int)3, (int)3, (int)5126, (boolean)false, (int)44, (long)32L);
        LOGGER.trace("Calling glEnableVertexAttribArray(0)");
        GL20.glEnableVertexAttribArray((int)0);
        LOGGER.trace("Calling glEnableVertexAttribArray(1)");
        GL20.glEnableVertexAttribArray((int)1);
        LOGGER.trace("Calling glEnableVertexAttribArray(2)");
        GL20.glEnableVertexAttribArray((int)2);
        LOGGER.trace("Calling glEnableVertexAttribArray(3)");
        GL20.glEnableVertexAttribArray((int)3);
        this.bind((Mesh)null);
    }

    public void draw(Mesh mesh) {
        if (mesh.getData().getID() == -1) {
            this.upload(mesh);
        }
        this.bind(mesh);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Calling glDrawElements({}, {}, GL_UNSIGNED_INT, 0)", (Object)GLEnum.getGLEnum(mesh.getData().getMode()), (Object)mesh.getData().getSize());
        }
        GL11.glDrawElements((int)GLEnum.getGLEnum(mesh.getData().getMode()), (int)mesh.getData().getSize(), (int)5125, (long)0L);
    }

    public void bind(Shader shader) {
        if (shader.getProgram().getID() == -1) {
            this.upload(shader);
        }
        if (this.state.getBoundShader() != null && this.state.getBoundShader().getProgram().getID() == shader.getProgram().getID()) {
            return;
        }
        LOGGER.trace("Calling glUseProgram({})", (Object)shader.getProgram().getID());
        GL20.glUseProgram((int)shader.getProgram().getID());
        this.state.setBound(shader);
    }

    public void upload(Shader shader) {
        GLSLProgram program = shader.getProgram();
        if (program.getID() == -1) {
            this.getIDGenerator().generate(shader);
        }
        for (GLSLScript script : program.getScripts()) {
            LOGGER.trace("Calling glShaderSource({}, <data=shader_source>)", (Object)script.getID());
            GL20.glShaderSource((int)script.getID(), (CharSequence)script.getSource());
            LOGGER.trace("Calling glCompileShader({})", (Object)script.getID());
            GL20.glCompileShader((int)script.getID());
            LOGGER.trace("Calling glGetShaderi({}, GL_COMPILE_STATUS)", (Object)script.getID());
            if (GL20.glGetShaderi((int)script.getID(), (int)35713) == 0) {
                LOGGER.warn(GL20.glGetShaderInfoLog((int)script.getID(), (int)1024));
            }
            LOGGER.trace("Calling glAttachShader({}, {})", (Object)program.getID(), (Object)script.getID());
            GL20.glAttachShader((int)program.getID(), (int)script.getID());
        }
        LOGGER.trace("Calling glLinkProgram({})", (Object)program.getID());
        GL20.glLinkProgram((int)program.getID());
        LOGGER.trace("Calling glGetProgrami({}, GL_LINK_STATUS)", (Object)program.getID());
        if (GL20.glGetProgrami((int)program.getID(), (int)35714) == 0) {
            LOGGER.trace("Calling glGetProgramInfoLog({}, 1024)", (Object)program.getID());
            LOGGER.warn("Link Status: {} @ {}", (Object)GL20.glGetProgramInfoLog((int)program.getID(), (int)1024), (Object)shader.getClass().getSimpleName());
        }
        LOGGER.trace("Calling glValidateProgram({})", (Object)program.getID());
        GL20.glValidateProgram((int)program.getID());
        LOGGER.trace("Calling glGetProgrami({}, GL_VALIDATE_STATUS)", (Object)program.getID());
        if (GL20.glGetProgrami((int)program.getID(), (int)35715) == 0) {
            LOGGER.trace("Calling glGetProgramInfoLog({}, 1024)", (Object)program.getID());
            String error = GL20.glGetProgramInfoLog((int)program.getID(), (int)1024);
            if (!error.contains("Validation Failed: No vertex array object bound")) {
                LOGGER.warn("Validation Status: {} @ {}", (Object)error, (Object)shader.getClass().getSimpleName());
            }
        }
        this.getUniformManager().addUniforms(shader);
        for (GLSLScript script : program.getScripts()) {
            int loc = 0;
            for (Variable attr : script.getAttributes()) {
                LOGGER.debug("{}: attribute {} got added at {}", new Object[]{this.getClass().getSimpleName(), attr.getName(), loc});
                LOGGER.trace("Calling glBindAttribLocation({}, {}, {})", new Object[]{program.getID(), loc, attr.getName()});
                GL20.glBindAttribLocation((int)program.getID(), (int)loc, (CharSequence)attr.getName());
                ++loc;
            }
        }
    }

    public void bindAsRenderTarget(FrameBuffer fbo) {
        if (fbo == null) {
            this.state.setBound((FrameBuffer)null);
            LOGGER.trace("Calling glDrawBuffer(GL_NONE)");
            GL11.glDrawBuffer((int)0);
            LOGGER.trace("Calling glReadBuffer(GL_NONE)");
            GL11.glReadBuffer((int)0);
            return;
        }
        if (this.state.getBoundFbo() != null && this.state.getBoundFbo().getID() == fbo.getID()) {
            return;
        }
        if (fbo.getID() == -1) {
            this.upload(fbo);
        }
        this.bind(fbo);
        if (fbo.sizeColorTargets() == 0) {
            LOGGER.trace("Calling glDrawBuffer(GL_NONE)");
            GL11.glDrawBuffer((int)0);
            LOGGER.trace("Calling glReadBuffer(GL_NONE)");
            GL11.glReadBuffer((int)0);
        } else if (fbo.sizeColorTargets() > 1) {
            this.intBuffer.clear();
            for (int i = 0; i < fbo.sizeColorTargets(); ++i) {
                this.intBuffer.put(36064 + i);
            }
            this.intBuffer.flip();
            LOGGER.trace("Calling glDrawBuffers(<data=color_attachments>)");
            GL20.glDrawBuffers((IntBuffer)this.intBuffer);
        } else {
            LOGGER.trace("Calling glDrawBuffer(GL_COLOR_ATTACHMENT0)");
            GL11.glDrawBuffer((int)36064);
        }
        try {
            this.validateFrameBufferStatus(fbo);
        }
        catch (FrameBufferException e) {
            LOGGER.error("Error binding FrameBuffer", (Throwable)e);
        }
    }

    public void bind(FrameBuffer fbo) {
        if (this.state.getBoundFbo() != null && this.state.getBoundFbo().getID() == fbo.getID()) {
            return;
        }
        LOGGER.trace("Calling glBindFramebuffer(GL_FRAMEBUFFER, {})", (Object)fbo.getID());
        GL30.glBindFramebuffer((int)36160, (int)fbo.getID());
        LOGGER.trace("Calling glViewport(0, 0, {}, {}", (Object)fbo.getWidth(), (Object)fbo.getHeight());
        GL11.glViewport((int)0, (int)0, (int)fbo.getWidth(), (int)fbo.getHeight());
        this.state.setBound(fbo);
    }

    public void upload(FrameBuffer fbo) {
        if (fbo.getID() == -1) {
            this.getIDGenerator().generate(fbo);
        }
        this.bind(fbo);
        RenderBuffer depthTarget = fbo.getDepthTarget();
        if (depthTarget != null) {
            this.fboUploadRenderBufferSetup(fbo, depthTarget, 6402, 36096);
        }
        for (int i = 0; i < fbo.sizeColorTargets(); ++i) {
            RenderBuffer colorTarget = fbo.getColorTarget(i);
            if (colorTarget.getTexture() != null) continue;
            this.fboUploadRenderBufferSetup(fbo, colorTarget, 32854, 36064 + i);
        }
    }

    public IDGenerator getIDGenerator() {
        return this.idGen;
    }

    public UniformManager getUniformManager() {
        return this.uniformManager;
    }

    public RenderEngineState getState() {
        return this.state;
    }

    protected void fboUploadRenderBufferSetup(FrameBuffer fbo, RenderBuffer rbo, int iFormat, int attachment) {
        if (rbo.getTexture() == null) {
            if (rbo.getID() == -1) {
                this.getIDGenerator().generate(rbo);
            }
            LOGGER.trace("Calling glBindRenderbuffer(GL_RENDERBUFFER, {})", (Object)rbo.getID());
            GL30.glBindRenderbuffer((int)36161, (int)rbo.getID());
            LOGGER.trace("Calling glRenderbufferStorage(GL_RENDERBUFFER, {}, {}, {})", new Object[]{iFormat, fbo.getWidth(), fbo.getHeight()});
            GL30.glRenderbufferStorage((int)36161, (int)iFormat, (int)fbo.getWidth(), (int)fbo.getHeight());
            LOGGER.trace("Calling glFramebufferRenderbuffer(GL_FRAMEBUFFER, {}, GL_RENDERBUFFER, {})", (Object)attachment, (Object)rbo.getID());
            GL30.glFramebufferRenderbuffer((int)36160, (int)attachment, (int)36161, (int)rbo.getID());
        } else {
            if (rbo.getTexture().getID() == -1) {
                this.upload(rbo.getTexture());
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Calling glFramebufferTexture2D(GL_FRAMEBUFFER, {}, {}, {}, {}, 0)", new Object[]{attachment, GLEnum.getGLEnum(rbo.getTexture().getType()), rbo.getTexture().getID()});
            }
            GL30.glFramebufferTexture2D((int)36160, (int)attachment, (int)GLEnum.getGLEnum(rbo.getTexture().getType()), (int)rbo.getTexture().getID(), (int)0);
        }
    }

    protected void validateFrameBufferStatus(FrameBuffer fbo) throws FrameBufferException {
        LOGGER.trace("Calling glCheckFramebufferStatus(GL_FRAMEBUFFER)");
        int status = GL30.glCheckFramebufferStatus((int)36160);
        LOGGER.trace("-> got {}", (Object)status);
        switch (status) {
            case 36053: {
                break;
            }
            case 36054: {
                throw new FrameBufferException("Incomplete or corrupt attachments");
            }
            case 36055: {
                throw new FrameBufferException("FrameBuffer doesn't have any RenderBuffers attached");
            }
            case 36059: {
                throw new FrameBufferException("Incomplete DrawBuffer setup");
            }
            case 36182: {
                throw new FrameBufferException("Incomplete Multisample setup");
            }
            case 36060: {
                throw new FrameBufferException("Incomplete ReadBuffer setup");
            }
            default: {
                throw new UnsupportedOperationException("Unknown FBO status Code " + status);
            }
        }
    }
}

