/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.lwjgl.rendering.binding;

import org.achtern.AchternEngine.core.rendering.binding.IDGenerator;
import org.achtern.AchternEngine.core.rendering.framebuffer.FrameBuffer;
import org.achtern.AchternEngine.core.rendering.framebuffer.RenderBuffer;
import org.achtern.AchternEngine.core.rendering.mesh.Mesh;
import org.achtern.AchternEngine.core.rendering.mesh.MeshData;
import org.achtern.AchternEngine.core.rendering.shader.Shader;
import org.achtern.AchternEngine.core.rendering.texture.Texture;
import org.achtern.AchternEngine.core.resource.fileparser.caseclasses.GLSLScript;
import org.achtern.AchternEngine.lwjgl.util.GLEnum;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class LWJGLIDGenerator
implements IDGenerator {
    public void generate(Texture texture) {
        int id = GL11.glGenTextures();
        texture.setID(id);
    }

    public void generate(Mesh mesh) {
        MeshData data = mesh.getData();
        int vbo = GL15.glGenBuffers();
        int ibo = GL15.glGenBuffers();
        int vao = GL30.glGenVertexArrays();
        data.setBufferIDs(vbo, ibo);
        data.setID(vao);
    }

    public void generate(Shader shader) {
        int id = GL20.glCreateProgram();
        shader.getProgram().setID(id);
        for (GLSLScript script : shader.getProgram().getScripts()) {
            int sId = GL20.glCreateShader((int)GLEnum.getGLEnum(script.getType()));
            script.setID(sId);
        }
    }

    public void generate(FrameBuffer fbo) {
        int id = GL30.glGenFramebuffers();
        fbo.setID(id);
    }

    public void generate(RenderBuffer rbo) {
        int id = GL30.glGenRenderbuffers();
        rbo.setID(id);
    }
}

