/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.lwjgl.rendering.state;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.achtern.AchternEngine.core.rendering.Color;
import org.achtern.AchternEngine.core.rendering.framebuffer.FrameBuffer;
import org.achtern.AchternEngine.core.rendering.mesh.Mesh;
import org.achtern.AchternEngine.core.rendering.shader.Shader;
import org.achtern.AchternEngine.core.rendering.state.BlendFunction;
import org.achtern.AchternEngine.core.rendering.state.DepthFunction;
import org.achtern.AchternEngine.core.rendering.state.Face;
import org.achtern.AchternEngine.core.rendering.state.Feature;
import org.achtern.AchternEngine.core.rendering.state.FillMode;
import org.achtern.AchternEngine.core.rendering.state.FrontFaceMethod;
import org.achtern.AchternEngine.core.rendering.state.RenderEngineState;
import org.achtern.AchternEngine.core.rendering.texture.Texture;
import org.achtern.AchternEngine.lwjgl.util.GLEnum;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LWJGLRenderEngineState
implements RenderEngineState {
    public static final Logger LOGGER = LoggerFactory.getLogger(RenderEngineState.class);
    protected String version;
    protected final boolean throwUnchanged;
    protected Map<Feature, Boolean> enabled = new HashMap<Feature, Boolean>(Feature.values().length);
    protected DepthFunction depthFunction = DepthFunction.LESS;
    protected Face cullFace = Face.BACK;
    protected Color clearColor = Color.BLACK;
    protected FrontFaceMethod frontFace = FrontFaceMethod.COUNTER_CLOCKWISE;
    protected boolean depthWrite = true;
    protected BlendFunction[] blendFunction = new BlendFunction[]{BlendFunction.ONE, BlendFunction.ZERO};
    protected FillMode polygonMode = FillMode.FILL;
    protected boolean[] colorMask = new boolean[]{true, true, true, true};
    protected FrameBuffer boundFbo;
    protected Texture boundTexture;
    protected Mesh boundMesh;
    protected Shader boundShader;

    public LWJGLRenderEngineState() {
        this(true);
    }

    public LWJGLRenderEngineState(boolean throwUnchanged) {
        this.throwUnchanged = throwUnchanged;
    }

    public String getVersion() {
        if (this.version == null) {
            LOGGER.trace("Calling glGetString(GL_VERSION)");
            this.version = GL11.glGetString((int)7938);
        } else {
            LOGGER.trace("Using cached Version string");
        }
        return this.version;
    }

    public void clear(boolean color, boolean depth, boolean stencil) {
        if (!(color || depth || stencil)) {
            throw new IllegalArgumentException("At least one target has to be cleared, otherwise do not call clear()");
        }
        int mask = 0;
        if (color) {
            mask = 16384;
        }
        if (depth) {
            mask |= 0x100;
        }
        if (stencil) {
            mask |= 0x400;
        }
        LOGGER.trace("Clearing Screen Buffers color:{}, depth:{}, stencil:{}", new Object[]{color, depth, stencil});
        GL11.glClear((int)mask);
    }

    public void enable(Feature feature) {
        if (this.isEnabled(feature)) {
            if (this.throwUnchanged) {
                throw new IllegalStateException((Object)((Object)feature) + " is already enabled");
            }
            LOGGER.debug("{} is already enabled", (Object)feature);
            return;
        }
        LOGGER.trace("Calling glEnable({})", (Object)feature);
        GL11.glEnable((int)GLEnum.getGLEnum(feature));
        this.enabled.put(feature, true);
    }

    public void disable(Feature feature) {
        if (!this.isEnabled(feature)) {
            if (this.throwUnchanged) {
                throw new IllegalStateException((Object)((Object)feature) + " is not enabled");
            }
            LOGGER.debug("{} is not enabled", (Object)feature);
            return;
        }
        LOGGER.trace("Calling glDisable({})", (Object)feature);
        GL11.glDisable((int)GLEnum.getGLEnum(feature));
        this.enabled.put(feature, false);
    }

    public boolean isEnabled(Feature feature) {
        if (!this.enabled.containsKey((Object)feature)) {
            LOGGER.trace("Calling glIsEnabled({})", (Object)feature);
            this.enabled.put(feature, GL11.glIsEnabled((int)GLEnum.getGLEnum(feature)));
        }
        return this.enabled.get((Object)feature);
    }

    public void cullFace(Face face) {
        if (!this.isEnabled(Feature.CULL_FACE)) {
            throw new IllegalStateException("CullFace is not enabled!");
        }
        if (face.equals((Object)this.cullFace)) {
            if (this.throwUnchanged) {
                throw new IllegalStateException("CullFace already " + (Object)((Object)face));
            }
            LOGGER.debug("Cull Face is already {}", (Object)face);
            return;
        }
        LOGGER.trace("Calling glCullFace({})", (Object)face);
        GL11.glCullFace((int)GLEnum.getGLEnum(face));
        this.cullFace = face;
    }

    public Face getCullFace() {
        if (!this.isEnabled(Feature.CULL_FACE)) {
            throw new IllegalStateException("Cull Face is not enabled!");
        }
        return this.cullFace;
    }

    public void setFrontFace(FrontFaceMethod face) {
        if (face.equals((Object)this.frontFace)) {
            if (this.throwUnchanged) {
                throw new IllegalStateException("FrontFace already " + (Object)((Object)face));
            }
            LOGGER.debug("FrontFace is already {}", (Object)face);
            return;
        }
        LOGGER.trace("Calling glFrontFace({})", (Object)face);
        GL11.glFrontFace((int)GLEnum.getGLEnum(face));
        this.frontFace = face;
    }

    public FrontFaceMethod getFrontFace() {
        return this.frontFace;
    }

    public void setClearColor(Color color) {
        if (this.clearColor.equals(color)) {
            if (this.throwUnchanged) {
                throw new IllegalStateException("Clear Color already " + color);
            }
            LOGGER.debug("ClearColor is already {}", (Object)color);
            return;
        }
        LOGGER.trace("Calling glClearColor({})", (Object)color);
        GL11.glClearColor((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)color.getAlpha());
        this.clearColor = color;
    }

    public Color getClearColor() {
        return this.clearColor;
    }

    public void setDepthFunction(DepthFunction function) {
        if (this.depthFunction.equals((Object)function)) {
            if (this.throwUnchanged) {
                throw new IllegalStateException("DepthFunction is already " + (Object)((Object)function));
            }
            LOGGER.debug("DepthFunction is already {}", (Object)function);
            return;
        }
        LOGGER.trace("Calling glDepthFunc({})", (Object)function);
        GL11.glDepthFunc((int)GLEnum.getGLEnum(function));
        this.depthFunction = function;
    }

    public DepthFunction getDepthFunction() {
        return this.depthFunction;
    }

    public void setBlendFunction(BlendFunction sfactor, BlendFunction dfactor) {
        if (sfactor.equals((Object)this.blendFunction[0]) && dfactor.equals((Object)this.blendFunction[1])) {
            if (this.throwUnchanged) {
                throw new IllegalStateException("BlendFunction is already " + (Object)((Object)sfactor) + "-" + (Object)((Object)dfactor));
            }
            LOGGER.debug("DepthFunction is already {}-{}", (Object)sfactor, (Object)dfactor);
            return;
        }
        LOGGER.trace("Calling glBlendFunc({}, {})", (Object)sfactor, (Object)dfactor);
        GL11.glBlendFunc((int)GLEnum.getGLEnum(sfactor), (int)GLEnum.getGLEnum(dfactor));
        this.blendFunction[0] = sfactor;
        this.blendFunction[1] = dfactor;
    }

    public BlendFunction[] getBlendFunction() {
        return this.blendFunction;
    }

    public void enableDepthWrite(boolean enable) {
        if (this.depthWrite && enable) {
            if (this.throwUnchanged) {
                throw new IllegalStateException("DepthWriting is already enabled");
            }
            LOGGER.debug("DepthWriting is already enabled");
            return;
        }
        if (!this.depthWrite && !enable) {
            if (this.throwUnchanged) {
                throw new IllegalStateException("DepthWriting is already disabled");
            }
            LOGGER.debug("DepthWriting is already disabled");
            return;
        }
        LOGGER.trace("Calling glDepthMask({})", (Object)enable);
        GL11.glDepthMask((boolean)enable);
        this.depthWrite = enable;
    }

    public boolean isDepthWrite() {
        return this.depthWrite;
    }

    public void setPolygonMode(FillMode mode) {
        if (this.polygonMode.equals((Object)mode)) {
            if (this.throwUnchanged) {
                throw new IllegalStateException("PolygonMode is already " + (Object)((Object)mode));
            }
            LOGGER.debug("PolygonMode is already {}", (Object)mode);
            return;
        }
        LOGGER.trace("Calling glDepthMask(GL_FRONT_AND_BACK, {})", (Object)mode);
        GL11.glPolygonMode((int)1032, (int)GLEnum.getGLEnum(mode));
        this.polygonMode = mode;
    }

    public FillMode getPolygonMode() {
        return this.polygonMode;
    }

    public void setColorWrite(boolean r, boolean g, boolean b, boolean a) {
        boolean[] updated = new boolean[]{r, g, b, a};
        if (Arrays.equals(updated, this.colorMask)) {
            if (this.throwUnchanged) {
                throw new IllegalStateException("ColorWrite (Mask) already <" + r + g + b + a + ">!");
            }
            LOGGER.debug("ColorWrite (Mask) is already <{},{},{},{}>", new Object[]{r, g, b, a});
            return;
        }
        LOGGER.trace("Calling glColorMask({}, {}, {}, {})", new Object[]{r, g, b, a});
        GL11.glColorMask((boolean)r, (boolean)g, (boolean)b, (boolean)a);
        this.colorMask = updated;
    }

    public boolean[] isColorWrite() {
        return this.colorMask;
    }

    public void setBound(FrameBuffer fbo) {
        if (fbo != null && fbo.getID() == -1) {
            throw new IllegalStateException("Given fbo cannot be bound (INVALID_ID)");
        }
        this.boundFbo = fbo;
    }

    public FrameBuffer getBoundFbo() {
        return this.boundFbo;
    }

    public void setBound(Texture texture) {
        if (texture != null && texture.getID() == -1) {
            throw new IllegalStateException("Given Texture cannot be bound (INVALID_ID)");
        }
        this.boundTexture = texture;
    }

    public Texture getBoundTexture() {
        return this.boundTexture;
    }

    public void setBound(Mesh mesh) {
        if (mesh != null && mesh.getData().getID() == -1) {
            throw new IllegalStateException("Given Mesh cannot be bound (INVALID_ID)");
        }
        this.boundMesh = mesh;
    }

    public Mesh getBoundMesh() {
        return this.boundMesh;
    }

    public void setBound(Shader shader) {
        if (shader != null && shader.getProgram().getID() == -1) {
            throw new IllegalStateException("Given Shader cannot be bound (INVALID_ID)");
        }
        this.boundShader = shader;
    }

    public Shader getBoundShader() {
        return this.boundShader;
    }
}

