package org.ada.web.runnables.pdchallenge

import javax.inject.Inject
import org.incal.core.runnables.{InputFutureRunnable, InputFutureRunnableExt}
import org.incal.core.util.seqFutures

import scala.concurrent.ExecutionContext.Implicits.global

class LinkMDSWithFeatureInfo @Inject()(
    linkFeatureFile: LinkFeatureFileWithFeatureInfo
  ) extends InputFutureRunnableExt[LinkMDSWithFeatureInfoSpec] {

  private val kMeansTypes = Seq("kMeans", "bisKMeans")
  private val ks = Seq(2, 5, 10, 20)

  override def runAsFuture(input: LinkMDSWithFeatureInfoSpec) = {
    val inputFileNames = fileNames(input.fileNamePrefix + "-scaled")

    seqFutures(inputFileNames) { fileName =>
      val dataSetId = fileName.toLowerCase.substring(0, fileName.size - 4).replaceAllLiterally(".", "_")
      val dataSetName = dataSetId.capitalize.replaceAllLiterally("_", " ").replaceAllLiterally("-", " ")

      val spec = LinkFeatureFileWithFeatureInfoSpec(
        input.featureMetaInfoDataSetId,
        input.scoreDataSetId,
        input.featureFolderName + "/" + fileName,
        input.dataSpacePrefix + "." + dataSetId,
        dataSetName
      )

      linkFeatureFile.runAsFuture(spec)
    }.map(_ => ())
  }

  private def fileNames(prefix: String) =
    for (
      kMeansType <- kMeansTypes;
      k <- ks
    ) yield
      s"$prefix-mds_eigen_unscaled-${kMeansType}_${k}_iter_50.csv"
}

case class LinkMDSWithFeatureInfoSpec(
  featureMetaInfoDataSetId: String,
  scoreDataSetId: String,
  featureFolderName: String,
  fileNamePrefix: String,
  dataSpacePrefix: String
)