/*
 * Decompiled with CFR 0.152.
 */
package org.ada.server.dataaccess;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.ada.server.dataaccess.AdaConversionException;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class ConversionUtil$ {
    public static final ConversionUtil$ MODULE$;
    private final int org$ada$server$dataaccess$ConversionUtil$$minValidYear;
    private final int org$ada$server$dataaccess$ConversionUtil$$maxValidYear;

    static {
        new ConversionUtil$();
    }

    public int org$ada$server$dataaccess$ConversionUtil$$minValidYear() {
        return this.org$ada$server$dataaccess$ConversionUtil$$minValidYear;
    }

    public int org$ada$server$dataaccess$ConversionUtil$$maxValidYear() {
        return this.org$ada$server$dataaccess$ConversionUtil$$maxValidYear;
    }

    public Function1<String, Object> toDouble() {
        Serializable serializable = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toDouble();
            }
        };
        return new Serializable((Function1)serializable){
            public static final long serialVersionUID = 0L;
            private final Function1 eta$0$1$1;

            public final double apply(String text) {
                return BoxesRunTime.unboxToDouble(ConversionUtil$.MODULE$.org$ada$server$dataaccess$ConversionUtil$$convert(this.eta$0$1$1, text, ClassTag$.MODULE$.Double()));
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        };
    }

    public Function1<String, Object> toInt() {
        Serializable serializable = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
            }
        };
        return new Serializable((Function1)serializable){
            public static final long serialVersionUID = 0L;
            private final Function1 eta$0$2$1;

            public final int apply(String text) {
                return BoxesRunTime.unboxToInt(ConversionUtil$.MODULE$.org$ada$server$dataaccess$ConversionUtil$$convert(this.eta$0$2$1, text, ClassTag$.MODULE$.Int()));
            }
            {
                this.eta$0$2$1 = eta$0$2$1;
            }
        };
    }

    public Function1<String, Object> toLong() {
        Serializable serializable = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(String x$3) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3)).toLong();
            }
        };
        return new Serializable((Function1)serializable){
            public static final long serialVersionUID = 0L;
            private final Function1 eta$0$3$1;

            public final long apply(String text) {
                return BoxesRunTime.unboxToLong(ConversionUtil$.MODULE$.org$ada$server$dataaccess$ConversionUtil$$convert(this.eta$0$3$1, text, ClassTag$.MODULE$.Long()));
            }
            {
                this.eta$0$3$1 = eta$0$3$1;
            }
        };
    }

    public Function1<String, Object> toFloat() {
        Serializable serializable = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final float apply(String x$4) {
                return new StringOps(Predef$.MODULE$.augmentString(x$4)).toFloat();
            }
        };
        return new Serializable((Function1)serializable){
            public static final long serialVersionUID = 0L;
            private final Function1 eta$0$4$1;

            public final float apply(String text) {
                return BoxesRunTime.unboxToFloat(ConversionUtil$.MODULE$.org$ada$server$dataaccess$ConversionUtil$$convert(this.eta$0$4$1, text, ClassTag$.MODULE$.Float()));
            }
            {
                this.eta$0$4$1 = eta$0$4$1;
            }
        };
    }

    public Function1<String, Object> toBoolean(boolean includeNumbers) {
        Serializable serializable = new Serializable(includeNumbers){
            public static final long serialVersionUID = 0L;
            private final boolean includeNumbers$1;

            public final boolean apply(String text) {
                return ConversionUtil$.MODULE$.org$ada$server$dataaccess$ConversionUtil$$toBooleanAux(this.includeNumbers$1, text);
            }
            {
                this.includeNumbers$1 = includeNumbers$1;
            }
        };
        return new Serializable((Function1)serializable){
            public static final long serialVersionUID = 0L;
            private final Function1 eta$0$5$1;

            public final boolean apply(String text) {
                return BoxesRunTime.unboxToBoolean(ConversionUtil$.MODULE$.org$ada$server$dataaccess$ConversionUtil$$convert(this.eta$0$5$1, text, ClassTag$.MODULE$.Boolean()));
            }
            {
                this.eta$0$5$1 = eta$0$5$1;
            }
        };
    }

    public boolean toBoolean$default$1() {
        return true;
    }

    public Function1<String, Date> toDate(Traversable<String> dateFormats) {
        Serializable serializable = new Serializable(dateFormats){
            public static final long serialVersionUID = 0L;
            private final Traversable dateFormats$1;

            public final Date apply(String text) {
                return ConversionUtil$.MODULE$.org$ada$server$dataaccess$ConversionUtil$$toDateAux((Traversable<String>)this.dateFormats$1, text);
            }
            {
                this.dateFormats$1 = dateFormats$1;
            }
        };
        return new Serializable((Function1)serializable){
            public static final long serialVersionUID = 0L;
            private final Function1 eta$0$6$1;

            public final Date apply(String text) {
                return (Date)ConversionUtil$.MODULE$.org$ada$server$dataaccess$ConversionUtil$$convert(this.eta$0$6$1, text, ClassTag$.MODULE$.apply(Date.class));
            }
            {
                this.eta$0$6$1 = eta$0$6$1;
            }
        };
    }

    public Function1<String, Date> toDateFromMsString() {
        Serializable serializable = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Date apply(String text) {
                return ConversionUtil$.MODULE$.org$ada$server$dataaccess$ConversionUtil$$toDateFromMsStringAux(text);
            }
        };
        return new Serializable((Function1)serializable){
            public static final long serialVersionUID = 0L;
            private final Function1 eta$0$7$1;

            public final Date apply(String text) {
                return (Date)ConversionUtil$.MODULE$.org$ada$server$dataaccess$ConversionUtil$$convert(this.eta$0$7$1, text, ClassTag$.MODULE$.apply(Date.class));
            }
            {
                this.eta$0$7$1 = eta$0$7$1;
            }
        };
    }

    public Date org$ada$server$dataaccess$ConversionUtil$$toDateAux(Traversable<String> dateFormats, String text) {
        Traversable dates = (Traversable)((GenericTraversableTemplate)dateFormats.map((Function1)new Serializable(text){
            public static final long serialVersionUID = 0L;
            private final String text$1;

            public final Option<Date> apply(String format) {
                Object object;
                try {
                    int year1900;
                    SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                    ParsePosition parsePosition = new ParsePosition(0);
                    Date date = dateFormat.parse(this.text$1, parsePosition);
                    object = parsePosition.getIndex() == this.text$1.length() ? ((year1900 = date.getYear()) > ConversionUtil$.MODULE$.org$ada$server$dataaccess$ConversionUtil$$minValidYear() - 1900 && year1900 < ConversionUtil$.MODULE$.org$ada$server$dataaccess$ConversionUtil$$maxValidYear() - 1900 ? new Some((Object)date) : None$.MODULE$) : None$.MODULE$;
                }
                catch (ParseException parseException) {
                    object = None$.MODULE$;
                }
                return object;
            }
            {
                this.text$1 = text$1;
            }
        }, Traversable$.MODULE$.canBuildFrom())).flatten((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<Date> apply(Option<Date> xo) {
                return Option$.MODULE$.option2Iterable(xo);
            }
        });
        return (Date)dates.headOption().getOrElse((Function0)new Serializable(text){
            public static final long serialVersionUID = 0L;
            private final String text$1;

            public final Nothing$ apply() {
                throw ConversionUtil$.MODULE$.typeExpectedException(this.text$1, Date.class);
            }
            {
                this.text$1 = text$1;
            }
        });
    }

    public Date org$ada$server$dataaccess$ConversionUtil$$toDateFromMsStringAux(String text) {
        long ms;
        try {
            ms = BoxesRunTime.unboxToLong((Object)this.toLong().apply((Object)text));
        }
        catch (AdaConversionException adaConversionException) {
            throw this.typeExpectedException(text, Date.class);
        }
        return this.toDateFromMs(ms);
    }

    public Date toDateFromMs(long ms) {
        Date date = new Date(ms);
        int year1900 = date.getYear();
        if (year1900 > this.org$ada$server$dataaccess$ConversionUtil$$minValidYear() - 1900 && year1900 < this.org$ada$server$dataaccess$ConversionUtil$$maxValidYear() - 1900) {
            return date;
        }
        throw this.typeExpectedException(((Object)BoxesRunTime.boxToLong((long)ms)).toString(), Date.class);
    }

    public boolean org$ada$server$dataaccess$ConversionUtil$$toBooleanAux(boolean includeNumbers, String text) {
        block4: {
            block5: {
                boolean bl;
                try {
                    bl = new StringOps(Predef$.MODULE$.augmentString(text)).toBoolean();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    boolean bl2;
                    if (!includeNumbers) break block4;
                    String string = text;
                    if ("0".equals(string)) {
                        bl2 = false;
                    } else {
                        if (!"1".equals(string)) break block5;
                        bl2 = true;
                    }
                    bl = bl2;
                }
                return bl;
            }
            throw this.typeExpectedException(text, Boolean.TYPE);
        }
        throw this.typeExpectedException(text, Boolean.TYPE);
    }

    public Function1<String, Object> isDouble() {
        Serializable serializable = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(String x$5) {
                return new StringOps(Predef$.MODULE$.augmentString(x$5)).toDouble();
            }
        };
        return new Serializable((Function1)serializable){
            public static final long serialVersionUID = 0L;
            private final Function1 eta$0$8$1;

            public final boolean apply(String text) {
                return ConversionUtil$.MODULE$.org$ada$server$dataaccess$ConversionUtil$$isConvertible(this.eta$0$8$1, text, ClassTag$.MODULE$.Double());
            }
            {
                this.eta$0$8$1 = eta$0$8$1;
            }
        };
    }

    public Function1<String, Object> isInt() {
        Serializable serializable = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$6) {
                return new StringOps(Predef$.MODULE$.augmentString(x$6)).toInt();
            }
        };
        return new Serializable((Function1)serializable){
            public static final long serialVersionUID = 0L;
            private final Function1 eta$0$9$1;

            public final boolean apply(String text) {
                return ConversionUtil$.MODULE$.org$ada$server$dataaccess$ConversionUtil$$isConvertible(this.eta$0$9$1, text, ClassTag$.MODULE$.Int());
            }
            {
                this.eta$0$9$1 = eta$0$9$1;
            }
        };
    }

    public Function1<String, Object> isLong() {
        Serializable serializable = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(String x$7) {
                return new StringOps(Predef$.MODULE$.augmentString(x$7)).toLong();
            }
        };
        return new Serializable((Function1)serializable){
            public static final long serialVersionUID = 0L;
            private final Function1 eta$0$10$1;

            public final boolean apply(String text) {
                return ConversionUtil$.MODULE$.org$ada$server$dataaccess$ConversionUtil$$isConvertible(this.eta$0$10$1, text, ClassTag$.MODULE$.Long());
            }
            {
                this.eta$0$10$1 = eta$0$10$1;
            }
        };
    }

    public Function1<String, Object> isFloat() {
        Serializable serializable = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final float apply(String x$8) {
                return new StringOps(Predef$.MODULE$.augmentString(x$8)).toFloat();
            }
        };
        return new Serializable((Function1)serializable){
            public static final long serialVersionUID = 0L;
            private final Function1 eta$0$11$1;

            public final boolean apply(String text) {
                return ConversionUtil$.MODULE$.org$ada$server$dataaccess$ConversionUtil$$isConvertible(this.eta$0$11$1, text, ClassTag$.MODULE$.Float());
            }
            {
                this.eta$0$11$1 = eta$0$11$1;
            }
        };
    }

    public Function1<String, Object> isBoolean() {
        Serializable serializable = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String text) {
                return ConversionUtil$.MODULE$.org$ada$server$dataaccess$ConversionUtil$$toBooleanAux(true, text);
            }
        };
        return new Serializable((Function1)serializable){
            public static final long serialVersionUID = 0L;
            private final Function1 eta$0$12$1;

            public final boolean apply(String text) {
                return ConversionUtil$.MODULE$.org$ada$server$dataaccess$ConversionUtil$$isConvertible(this.eta$0$12$1, text, ClassTag$.MODULE$.Boolean());
            }
            {
                this.eta$0$12$1 = eta$0$12$1;
            }
        };
    }

    public Function1<String, Object> isDate(Traversable<String> dateFormats) {
        Serializable serializable = new Serializable(dateFormats){
            public static final long serialVersionUID = 0L;
            private final Traversable dateFormats$2;

            public final Date apply(String text) {
                return ConversionUtil$.MODULE$.org$ada$server$dataaccess$ConversionUtil$$toDateAux((Traversable<String>)this.dateFormats$2, text);
            }
            {
                this.dateFormats$2 = dateFormats$2;
            }
        };
        return new Serializable((Function1)serializable){
            public static final long serialVersionUID = 0L;
            private final Function1 eta$0$13$1;

            public final boolean apply(String text) {
                return ConversionUtil$.MODULE$.org$ada$server$dataaccess$ConversionUtil$$isConvertible(this.eta$0$13$1, text, ClassTag$.MODULE$.apply(Date.class));
            }
            {
                this.eta$0$13$1 = eta$0$13$1;
            }
        };
    }

    public <T> T org$ada$server$dataaccess$ConversionUtil$$convert(Function1<String, T> fun, String text, ClassTag<T> tag) {
        try {
            return (T)fun.apply((Object)text.trim());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.typeExpectedException(text, tag.runtimeClass());
        }
        catch (NumberFormatException numberFormatException) {
            throw this.typeExpectedException(text, tag.runtimeClass());
        }
    }

    public <T> boolean org$ada$server$dataaccess$ConversionUtil$$isConvertible(Function1<String, T> fun, String text, ClassTag<T> tag) {
        boolean bl;
        try {
            this.org$ada$server$dataaccess$ConversionUtil$$convert(fun, text, tag);
            bl = true;
        }
        catch (AdaConversionException adaConversionException) {
            bl = false;
        }
        return bl;
    }

    public Nothing$ typeExpectedException(String value, Class<?> expectedType) {
        throw new AdaConversionException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"String '", "' is not ", "-convertible."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value, expectedType.getSimpleName()})));
    }

    private ConversionUtil$() {
        MODULE$ = this;
        this.org$ada$server$dataaccess$ConversionUtil$$minValidYear = 1000;
        this.org$ada$server$dataaccess$ConversionUtil$$maxValidYear = 1900 + new Date().getYear() + 1000;
    }
}

