/*
 * Decompiled with CFR 0.152.
 */
package org.ada.server.calc;

import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.special.Beta;
import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.util.ContinuedFraction;
import org.apache.commons.math3.util.FastMath;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;

public final class CommonsMathUtil$ {
    public static final CommonsMathUtil$ MODULE$;

    static {
        new CommonsMathUtil$();
    }

    public Option<BigDecimal> regularizedGammaP(double a, double x, double epsilon, int maxIterations) throws MaxCountExceededException {
        None$ none$;
        if (Double.isNaN(a) || Double.isNaN(x) || a <= 0.0 || x < 0.0) {
            none$ = None$.MODULE$;
        } else if (x == 0.0) {
            none$ = new Some((Object)BigDecimal$.MODULE$.double2bigDecimal(0.0));
        } else if (x >= a + 1.0) {
            BigDecimal gammaQ = BigDecimal$.MODULE$.double2bigDecimal(Gamma.regularizedGammaQ((double)a, (double)x, (double)epsilon, (int)maxIterations));
            none$ = new Some((Object)BigDecimal$.MODULE$.double2bigDecimal(1.0).$minus(gammaQ));
        } else {
            double sum;
            double an;
            double n = 0.0;
            for (sum = an = 1.0 / a; FastMath.abs((double)(an / sum)) > epsilon && n < (double)maxIterations && sum < Double.POSITIVE_INFINITY; sum += (an *= x / (a + (n += 1.0)))) {
            }
            if (n >= (double)maxIterations) {
                throw new MaxCountExceededException((Number)Predef$.MODULE$.int2Integer(maxIterations));
            }
            if (Double.isInfinite(sum)) {
                none$ = new Some((Object)BigDecimal$.MODULE$.double2bigDecimal(1.0));
            } else {
                BigDecimal result = BigDecimal$.MODULE$.double2bigDecimal(FastMath.exp((double)(-x + a * FastMath.log((double)x) - Gamma.logGamma((double)a))) * sum);
                none$ = new Some((Object)result);
            }
        }
        return none$;
    }

    public Option<BigDecimal> regularizedBeta(double x, double a, double b, double epsilon, int maxIterations) throws MaxCountExceededException {
        None$ none$;
        if (Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b) || x < 0.0 || x > 1.0 || a <= 0.0 || b <= 0.0) {
            none$ = None$.MODULE$;
        } else if (x > (a + 1.0) / ((double)2 + b + a) && 1.0 - x <= (b + 1.0) / ((double)2 + b + a)) {
            none$ = this.regularizedBeta(1.0 - x, b, a, epsilon, maxIterations).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final BigDecimal apply(BigDecimal beta) {
                    return BigDecimal$.MODULE$.double2bigDecimal(1.0).$minus(beta);
                }
            });
        } else {
            ContinuedFraction fraction = new ContinuedFraction(a, b){
                private final double a$1;
                private final double b$1;

                public double getB(int n, double x) {
                    double ret = 0.0;
                    double m = 0.0;
                    if (n % 2 == 0) {
                        m = (double)n / 2.0;
                        ret = m * (this.b$1 - m) * x / ((this.a$1 + (double)2 * m - 1.0) * (this.a$1 + (double)2 * m));
                    } else {
                        m = ((double)n - 1.0) / 2.0;
                        ret = -((this.a$1 + m) * (this.a$1 + this.b$1 + m) * x) / ((this.a$1 + (double)2 * m) * (this.a$1 + (double)2 * m + 1.0));
                    }
                    return ret;
                }

                public double getA(int n, double x) {
                    return 1.0;
                }
                {
                    this.a$1 = a$1;
                    this.b$1 = b$1;
                }
            };
            BigDecimal result = BigDecimal$.MODULE$.double2bigDecimal(FastMath.exp((double)(a * FastMath.log((double)x) + b * FastMath.log1p((double)(-x)) - FastMath.log((double)a) - Beta.logBeta((double)a, (double)b))) * 1.0 / fraction.evaluate(x, epsilon, maxIterations));
            none$ = new Some((Object)result);
        }
        return none$;
    }

    private CommonsMathUtil$() {
        MODULE$ = this;
    }
}

