/*
 * Decompiled with CFR 0.152.
 */
package org.ada.server.runnables.core;

import com.banda.core.plotter.Plotter$;
import java.io.File;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import org.ada.server.models.ml.unsupervised.BisectingKMeans;
import org.ada.server.models.ml.unsupervised.KMeans;
import org.ada.server.models.ml.unsupervised.UnsupervisedLearning;
import org.ada.server.runnables.core.CalcKMeansHelper;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.incal.core.util.package$;
import play.api.Logger$;
import reactivemongo.bson.BSONObjectID;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random$;

public abstract class CalcKMeansHelper$class {
    public static void calcKMeansAux(CalcKMeansHelper $this, String inputFileName, Option delimiter, String exportFileName, Option exportPlotFileName, UnsupervisedLearning model) {
        String unescapedDelimiter = StringEscapeUtils.unescapeJava((String)((String)delimiter.getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CalcKMeansHelper $outer;

            public final String apply() {
                return this.$outer.org$ada$server$runnables$core$CalcKMeansHelper$$defaultDelimiter();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })));
        Dataset df = $this.org$ada$server$runnables$core$CalcKMeansHelper$$session().read().format("csv").option("header", "true").option("delimiter", unescapedDelimiter).option("inferSchema", "true").load(inputFileName);
        String idColumnName = df.columns()[0];
        Traversable idClusters = (Traversable)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).foldLeft((Object)Nil$.MODULE$, (Function2)new Serializable($this, df, idColumnName, model){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CalcKMeansHelper $outer;
            private final Dataset df$1;
            private final String idColumnName$1;
            private final UnsupervisedLearning model$2;

            public final Traversable<Tuple2<String, Object>> apply(Traversable<Tuple2<String, Object>> x0$1, int x1$1) {
                Tuple2 tuple2 = new Tuple2(x0$1, (Object)BoxesRunTime.boxToInteger((int)x1$1));
                if (tuple2 != null) {
                    Traversable<Tuple2<String, Object>> traversable;
                    Traversable<Tuple2<String, Object>> idClusters = (Traversable<Tuple2<String, Object>>)tuple2._1();
                    int trial = tuple2._2$mcI$sp();
                    if (idClusters.isEmpty() || idClusters.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<String, Object> x$3) {
                            return x$3._2$mcI$sp() == 1;
                        }
                    })) {
                        UnsupervisedLearning unsupervisedLearning;
                        if (trial > 0) {
                            this.$outer.logger().error((Function0)new Serializable(this, trial){
                                public static final long serialVersionUID = 0L;
                                private final int trial$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A single cluster obtained! Repeating the clustering (trial ", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.trial$1)}));
                                }
                                {
                                    this.trial$1 = trial$1;
                                }
                            });
                            unsupervisedLearning = CalcKMeansHelper$class.org$ada$server$runnables$core$CalcKMeansHelper$$setCurrentTimeAsSeed(this.$outer, this.model$2);
                        } else {
                            unsupervisedLearning = this.model$2;
                        }
                        UnsupervisedLearning newModel = unsupervisedLearning;
                        traversable = this.$outer.machineLearningService().clusterDf((Dataset<Row>)this.df$1, this.idColumnName$1, newModel, (Option<Enumeration.Value>)None$.MODULE$, (Option<Object>)None$.MODULE$);
                    } else {
                        traversable = idClusters;
                    }
                    Traversable<Tuple2<String, Object>> traversable2 = traversable;
                    return traversable2;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.df$1 = df$1;
                this.idColumnName$1 = idColumnName$1;
                this.model$2 = model$2;
            }
        });
        List rows = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)idClusters.toList().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Row apply(Product tuple) {
                return Row$.MODULE$.fromTuple(tuple);
            }
        }, List$.MODULE$.canBuildFrom())).asJava();
        StructType schema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField(idColumnName, (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField($this.org$ada$server$runnables$core$CalcKMeansHelper$$clusterClassColumnName(), (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4())})));
        Dataset idClustersDf = $this.org$ada$server$runnables$core$CalcKMeansHelper$$session().createDataFrame(rows, schema);
        Dataset finalDf = df.join(idClustersDf, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{idColumnName})));
        String exportDir = CalcKMeansHelper$class.createRandomTempDirName($this);
        finalDf.write().option("header", "true").csv(exportDir);
        String file = $this.org$ada$server$runnables$core$CalcKMeansHelper$$fs().globStatus(new Path(new StringBuilder().append((Object)exportDir).append((Object)"/part*").toString()))[0].getPath().getName();
        $this.org$ada$server$runnables$core$CalcKMeansHelper$$fs().rename(new Path(new StringBuilder().append((Object)exportDir).append((Object)"/").append((Object)file).toString()), new Path(exportFileName));
        $this.org$ada$server$runnables$core$CalcKMeansHelper$$fs().delete(new Path(exportDir), true);
        if (exportPlotFileName.isDefined()) {
            Seq featureColumnNames = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])df.columns()).filterNot((Function1)new Serializable($this, idColumnName){
                public static final long serialVersionUID = 0L;
                private final String idColumnName$1;

                public final boolean apply(String x$4) {
                    return x$4.equals(this.idColumnName$1);
                }
                {
                    this.idColumnName$1 = idColumnName$1;
                }
            })).toSeq();
            Row[] finalDfRows = (Row[])finalDf.select($this.org$ada$server$runnables$core$CalcKMeansHelper$$clusterClassColumnName(), featureColumnNames).collect();
            IndexedSeq[] values = (IndexedSeq[])Predef$.MODULE$.refArrayOps((Object[])finalDfRows).map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final IndexedSeq<Object> apply(Row row) {
                    return (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), row.size() - 1).map((Function1)new Serializable(this, row){
                        public static final long serialVersionUID = 0L;
                        private final Row row$1;

                        public final double apply(int i) {
                            return this.apply$mcDI$sp(i);
                        }

                        public double apply$mcDI$sp(int i) {
                            return this.row$1.getDouble(i);
                        }
                        {
                            this.row$1 = row$1;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(IndexedSeq.class)));
            int[] labels = (int[])Predef$.MODULE$.refArrayOps((Object[])finalDfRows).map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final int apply(Row x$5) {
                    return x$5.getInt(0);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            String output = (String)$this.org$ada$server$runnables$core$CalcKMeansHelper$$plotter().plotXY((Traversable)Predef$.MODULE$.wrapRefArray((Object[])values), "k-Means");
            package$.MODULE$.writeStringAsStream(output, new File((String)exportPlotFileName.get()));
        }
    }

    public static UnsupervisedLearning org$ada$server$runnables$core$CalcKMeansHelper$$setCurrentTimeAsSeed(CalcKMeansHelper $this, UnsupervisedLearning model) {
        UnsupervisedLearning unsupervisedLearning;
        UnsupervisedLearning unsupervisedLearning2 = model;
        if (unsupervisedLearning2 instanceof KMeans) {
            KMeans kMeans = (KMeans)unsupervisedLearning2;
            Some x$6 = new Some((Object)BoxesRunTime.boxToLong((long)new Date().getTime()));
            Option<BSONObjectID> x$7 = kMeans.copy$default$1();
            int x$8 = kMeans.copy$default$2();
            Option<Object> x$9 = kMeans.copy$default$3();
            Option<Object> x$10 = kMeans.copy$default$4();
            Option<Enumeration.Value> x$11 = kMeans.copy$default$6();
            Option<Object> x$12 = kMeans.copy$default$7();
            Option<String> x$13 = kMeans.copy$default$8();
            Option<BSONObjectID> x$14 = kMeans.copy$default$9();
            Date x$15 = kMeans.copy$default$10();
            unsupervisedLearning = kMeans.copy(x$7, x$8, x$9, x$10, (Option<Object>)x$6, x$11, x$12, x$13, x$14, x$15);
        } else if (unsupervisedLearning2 instanceof BisectingKMeans) {
            BisectingKMeans bisectingKMeans = (BisectingKMeans)unsupervisedLearning2;
            Some x$16 = new Some((Object)BoxesRunTime.boxToLong((long)new Date().getTime()));
            Option<BSONObjectID> x$17 = bisectingKMeans.copy$default$1();
            int x$18 = bisectingKMeans.copy$default$2();
            Option<Object> x$19 = bisectingKMeans.copy$default$3();
            Option<Object> x$20 = bisectingKMeans.copy$default$5();
            Option<String> x$21 = bisectingKMeans.copy$default$6();
            Option<BSONObjectID> x$22 = bisectingKMeans.copy$default$7();
            Date x$23 = bisectingKMeans.copy$default$8();
            unsupervisedLearning = bisectingKMeans.copy(x$17, x$18, x$19, (Option<Object>)x$16, x$20, x$21, x$22, x$23);
        } else {
            unsupervisedLearning = model;
        }
        return unsupervisedLearning;
    }

    private static String createRandomTempDirName(CalcKMeansHelper $this) {
        java.nio.file.Path tmpDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
        java.nio.file.Path name = tmpDir.getFileSystem().getPath(((Object)BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong())).toString(), new String[0]);
        if (name.getParent() == null) {
            return ((Object)tmpDir.resolve(name)).toString();
        }
        throw new IllegalArgumentException("Invalid prefix or suffix");
    }

    public static void $init$(CalcKMeansHelper $this) {
        $this.org$ada$server$runnables$core$CalcKMeansHelper$_setter_$logger_$eq(Logger$.MODULE$);
        $this.org$ada$server$runnables$core$CalcKMeansHelper$_setter_$org$ada$server$runnables$core$CalcKMeansHelper$$session_$eq($this.sparkApp().session());
        $this.org$ada$server$runnables$core$CalcKMeansHelper$_setter_$org$ada$server$runnables$core$CalcKMeansHelper$$fs_$eq(FileSystem.get((Configuration)$this.sparkApp().sc().hadoopConfiguration()));
        $this.org$ada$server$runnables$core$CalcKMeansHelper$_setter_$org$ada$server$runnables$core$CalcKMeansHelper$$clusterClassColumnName_$eq("clazz");
        $this.org$ada$server$runnables$core$CalcKMeansHelper$_setter_$org$ada$server$runnables$core$CalcKMeansHelper$$plotter_$eq(Plotter$.MODULE$.apply("svg"));
        $this.org$ada$server$runnables$core$CalcKMeansHelper$_setter_$org$ada$server$runnables$core$CalcKMeansHelper$$defaultDelimiter_$eq(",");
    }
}

