/*
 * Decompiled with CFR 0.152.
 */
package org.ada.server.services.ldap;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.PostConnectProcessor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.ada.server.AdaException;
import org.ada.server.models.LdapUser;
import org.ada.server.models.UserGroup;
import org.ada.server.services.ldap.LDAPInterfaceFactory$;
import org.ada.server.services.ldap.LdapService;
import org.ada.server.services.ldap.LdapSettings;
import play.api.Logger$;
import play.api.inject.ApplicationLifecycle;
import reactivemongo.bson.BSONObjectID;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Singleton
@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001B\u0001\u0003\u00115\u0011q\u0002\u00143baN+'O^5dK&k\u0007\u000f\u001c\u0006\u0003\u0007\u0011\tA\u0001\u001c3ba*\u0011QAB\u0001\tg\u0016\u0014h/[2fg*\u0011q\u0001C\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005%Q\u0011aA1eC*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u0017\u001b\u0005\u0011\u0011BA\f\u0003\u0005-aE-\u00199TKJ4\u0018nY3\t\u0011e\u0001!\u0011!Q\u0001\ni\t\u0001b]3ui&twm\u001d\t\u0003+mI!\u0001\b\u0002\u0003\u00191#\u0017\r]*fiRLgnZ:\t\u0011y\u0001!\u0011!Q\u0001\n}\tA#\u00199qY&\u001c\u0017\r^5p]2Kg-Z2zG2,\u0007C\u0001\u0011(\u001b\u0005\t#B\u0001\u0012$\u0003\u0019IgN[3di*\u0011A%J\u0001\u0004CBL'\"\u0001\u0014\u0002\tAd\u0017-_\u0005\u0003Q\u0005\u0012A#\u00119qY&\u001c\u0017\r^5p]2Kg-Z2zG2,\u0007\"\u0002\u0016\u0001\t\u0003Y\u0013A\u0002\u001fj]&$h\bF\u0002-[9\u0002\"!\u0006\u0001\t\u000beI\u0003\u0019\u0001\u000e\t\u000byI\u0003\u0019A\u0010)\u0005%\u0002\u0004CA\u00196\u001b\u0005\u0011$B\u0001\u00124\u0015\u0005!\u0014!\u00026bm\u0006D\u0018B\u0001\u001c3\u0005\u0019IeN[3di\"9\u0001\b\u0001b\u0001\n\u0013I\u0014!C5oi\u0016\u0014h-Y2f+\u0005Q\u0004cA\b<{%\u0011A\b\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005y2U\"A \u000b\u0005\u0001\u000b\u0015aA:eW*\u00111A\u0011\u0006\u0003\u0007\u0012\u000b\u0011\"\u001e8c_VtG-\u001b3\u000b\u0003\u0015\u000b1aY8n\u0013\t9uHA\u0007M\t\u0006\u0003\u0016J\u001c;fe\u001a\f7-\u001a\u0005\u0007\u0013\u0002\u0001\u000b\u0011\u0002\u001e\u0002\u0015%tG/\u001a:gC\u000e,\u0007\u0005C\u0004L\u0001\t\u0007I\u0011\u0002'\u0002\r1|wmZ3s+\u0005ieB\u0001(P\u001b\u0005\u0019\u0013B\u0001)$\u0003\u0019aunZ4fe\"1!\u000b\u0001Q\u0001\n5\u000bq\u0001\\8hO\u0016\u0014\b\u0005C\u0003U\u0001\u0011\u0005S+A\u0005mSN$Xk]3sgV\ta\u000bE\u0002X?\nt!\u0001W/\u000f\u0005ecV\"\u0001.\u000b\u0005mc\u0011A\u0002\u001fs_>$h(C\u0001\u0012\u0013\tq\u0006#A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0001\f'a\u0003+sCZ,'o]1cY\u0016T!A\u0018\t\u0011\u0005\r4W\"\u00013\u000b\u0005\u00154\u0011AB7pI\u0016d7/\u0003\u0002hI\nAA\nZ1q+N,'\u000fC\u0003j\u0001\u0011%!.A\bf]R\u0014\u0018\u0010V8MI\u0006\u0004Xk]3s)\tYG\u000eE\u0002\u0010w\tDQ!\u001c5A\u00029\fQ!\u001a8uef\u0004\"AP8\n\u0005A|$!B#oiJL\b\"\u0002:\u0001\t\u0013\u0019\u0018\u0001E3oiJLHk\\+tKJ<%o\\;q)\t!\b\u0010E\u0002\u0010wU\u0004\"a\u0019<\n\u0005]$'!C+tKJ<%o\\;q\u0011\u0015i\u0017\u000f1\u0001o\u0011\u0015Q\b\u0001\"\u0003|\u00039\u0019X\r^;q\u0013:$XM\u001d4bG\u0016$\u0012A\u000f\u0005\u0006{\u0002!\tE`\u0001\bG\u0006t')\u001b8e)\u0015y\u0018QAA\f!\ry\u0011\u0011A\u0005\u0004\u0003\u0007\u0001\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u000fa\b\u0019AA\u0005\u0003\r)\u0018\u000e\u001a\t\u0005\u0003\u0017\t\tBD\u0002\u0010\u0003\u001bI1!a\u0004\u0011\u0003\u0019\u0001&/\u001a3fM&!\u00111CA\u000b\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0002\t\t\u000f\u0005eA\u00101\u0001\u0002\n\u0005A\u0001/Y:to>\u0014H\rC\u0004\u0002\u001e\u0001!I!a\b\u0002\u0015\r\fgNQ5oI\u0006+\b\u0010F\u0003\u0000\u0003C\t)\u0003\u0003\u0005\u0002$\u0005m\u0001\u0019AA\u0005\u0003\u0019)8/\u001a:E\u001d\"A\u0011\u0011DA\u000e\u0001\u0004\tI\u0001C\u0004\u0002*\u0001!I!a\u000b\u0002%1L7\u000f^+tKJ\u001cVOY#oiJLWm\u001d\u000b\u0007\u0003[\ty#!\r\u0011\u0007]{f\u000e\u0003\u0005\u0002\b\u0005\u001d\u0002\u0019AA\u0005\u0011!\t\u0019$a\nA\u0002\u0005%\u0011A\u00022bg\u0016$e\nC\u0004\u00028\u0001!\t%!\u000f\u0002\u0011\u001d,G/\u00128uef$B!a\u000f\u0002>A\u0019qb\u000f8\t\u0011\u0005}\u0012Q\u0007a\u0001\u0003\u0013\t!\u0001\u001a8\t\u000f\u0005\r\u0003\u0001\"\u0011\u0002F\u0005YA.[:u\u000b:$(/[3t+\t\t9\u0005\u0005\u0003X?\u0006%\u0001bBA&\u0001\u0011%\u0011QJ\u0001\u0007g\u0016\f'o\u00195\u0015\t\u00055\u0012q\n\u0005\t\u0003#\nI\u00051\u0001\u0002T\u0005i1/Z1sG\"\u0014V-];fgR\u00042APA+\u0013\r\t9f\u0010\u0002\u000e'\u0016\f'o\u00195SKF,Xm\u001d;\t\u000f\u0005m\u0003\u0001\"\u0003\u0002^\u0005)B-[:qCR\u001c\u0007nU3be\u000eD'+Z9vKN$HCBA\u0017\u0003?\n\t\u0007\u0003\u00049\u00033\u0002\r!\u0010\u0005\t\u0003G\nI\u00061\u0001\u0002T\u00059!/Z9vKN$\bf\u0001\u0001\u0002hA\u0019\u0011'!\u001b\n\u0007\u0005-$GA\u0005TS:<G.\u001a;p]\u0002")
public class LdapServiceImpl
implements LdapService {
    private final LdapSettings settings;
    private final ApplicationLifecycle applicationLifecycle;
    private final Option<LDAPInterface> interface;
    private final Logger$ logger;

    private Option<LDAPInterface> interface() {
        return this.interface;
    }

    private Logger$ logger() {
        return this.logger;
    }

    @Override
    public Traversable<LdapUser> listUsers() {
        Filter filter;
        Filter personFilter = Filter.createEqualityFilter((String)"objectClass", (String)"person");
        if (this.settings.groups().nonEmpty()) {
            Seq memberFilter = (Seq)this.settings.groups().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Filter apply(String groupname) {
                    return Filter.createEqualityFilter((String)"memberof", (String)groupname);
                }
            }, Seq$.MODULE$.canBuildFrom());
            filter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createORFilter((List)JavaConversions$.MODULE$.seqAsJavaList(memberFilter)), personFilter});
        } else {
            filter = personFilter;
        }
        Filter filterUsers = filter;
        SearchRequest request = new SearchRequest(this.settings.dit(), SearchScope.SUB, filterUsers, new String[0]);
        Traversable<Entry> entries = this.search(request);
        return (Traversable)((GenericTraversableTemplate)entries.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LdapServiceImpl $outer;

            public final Option<LdapUser> apply(Entry entry) {
                return this.$outer.org$ada$server$services$ldap$LdapServiceImpl$$entryToLdapUser(entry);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Traversable$.MODULE$.canBuildFrom())).flatten((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<LdapUser> apply(Option<LdapUser> xo) {
                return Option$.MODULE$.option2Iterable(xo);
            }
        });
    }

    public Option<LdapUser> org$ada$server$services$ldap$LdapServiceImpl$$entryToLdapUser(Entry entry) {
        return Option$.MODULE$.apply((Object)entry).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LdapUser apply(Entry entry) {
                String uid = entry.getAttributeValue("uid");
                String name = entry.getAttributeValue("cn");
                String email = entry.getAttributeValue("mail");
                String ou = entry.getAttributeValue("ou");
                String[] permissions = (String[])Option$.MODULE$.apply((Object)entry.getAttributeValues("memberof")).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String[] apply() {
                        return (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
                    }
                });
                return new LdapUser(uid, name, email, ou, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])permissions));
            }
        });
    }

    private Option<UserGroup> entryToUserGroup(Entry entry) {
        None$ none$;
        Option option = Option$.MODULE$.apply((Object)entry);
        if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            String name = entry.getAttributeValue("cn");
            String[] members = (String[])Option$.MODULE$.apply((Object)entry.getAttributeValues("member")).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String[] apply() {
                    return (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
                }
            });
            Option description = Option$.MODULE$.apply((Object)entry.getAttributeValue("description"));
            String[] nested = (String[])Option$.MODULE$.apply((Object)entry.getAttributeValues("memberof")).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String[] apply() {
                    return (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
                }
            });
            none$ = new Some((Object)new UserGroup((Option<BSONObjectID>)None$.MODULE$, name, (Option<String>)description, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])members), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])nested)));
        }
        return none$;
    }

    private Option<LDAPInterface> setupInterface() {
        Option<LDAPConnectionPool> option;
        String string = this.settings.mode();
        if ("local".equals(string)) {
            option = new Some((Object)LDAPInterfaceFactory$.MODULE$.local(this.settings.dit(), this.settings.port(), this.applicationLifecycle));
        } else if ("remote".equals(string)) {
            String password = (String)this.settings.bindPassword().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    throw new AdaException("Environmental variable 'ADA_LDAP_BIND_PASSWORD' or a conf entry 'ldap.bindPassword' not set but expected.");
                }
            });
            option = LDAPInterfaceFactory$.MODULE$.remote(this.settings.host(), this.settings.port(), this.settings.encryption(), this.settings.trustStore(), this.settings.bindDN(), password, this.applicationLifecycle, this.settings.connectTimeout(), this.settings.responseTimeout(), this.settings.pooledSchemaTimeout(), this.settings.abandonOnTimeout());
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    @Override
    public boolean canBind(String uid, String password) {
        boolean bl;
        if (this.settings.recursiveDitAuthenticationSearch()) {
            bl = BoxesRunTime.unboxToBoolean((Object)this.listUserSubEntries(uid, this.settings.dit()).headOption().map((Function1)new Serializable(this, password){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LdapServiceImpl $outer;
                private final String password$1;

                public final boolean apply(Entry userEntry) {
                    return this.$outer.org$ada$server$services$ldap$LdapServiceImpl$$canBindAux(userEntry.getDN(), this.password$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.password$1 = password$1;
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return false;
                }
            }));
        } else {
            String userDN = new StringBuilder().append((Object)"uid=").append((Object)uid).append((Object)",").append((Object)this.settings.dit()).toString();
            bl = this.org$ada$server$services$ldap$LdapServiceImpl$$canBindAux(userDN, password);
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean org$ada$server$services$ldap$LdapServiceImpl$$canBindAux(String userDN, String password) {
        ResultCode resultCode;
        LDAPConnection connection2;
        LDAPConnection lDAPConnection;
        this.logger().info((Function0)new Serializable(this, userDN){
            public static final long serialVersionUID = 0L;
            private final String userDN$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking the user credentials for ", " in LDAP."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.userDN$1}));
            }
            {
                this.userDN$1 = userDN$1;
            }
        });
        Tuple2<LDAPConnection, Option<PostConnectProcessor>> tuple2 = LDAPInterfaceFactory$.MODULE$.createConnection(this.settings.host(), this.settings.port(), this.settings.encryption(), this.settings.trustStore(), LDAPInterfaceFactory$.MODULE$.createConnection$default$5());
        if (tuple2 == null) throw new MatchError(tuple2);
        LDAPConnection connection = lDAPConnection = (connection2 = (LDAPConnection)tuple2._1());
        try {
            resultCode = connection.bind(userDN, password).getResultCode();
        }
        catch (LDAPException lDAPException) {
            resultCode = ResultCode.NO_SUCH_OBJECT;
        }
        ResultCode result = resultCode;
        connection.close();
        ResultCode resultCode2 = result;
        ResultCode resultCode3 = ResultCode.SUCCESS;
        String successfulWord = !(resultCode2 != null ? !resultCode2.equals(resultCode3) : resultCode3 != null) ? "successful" : "unsuccessful";
        this.logger().info((Function0)new Serializable(this, userDN, successfulWord){
            public static final long serialVersionUID = 0L;
            private final String userDN$1;
            private final String successfulWord$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The LDAP verification for ", " is ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.userDN$1, this.successfulWord$1.toUpperCase()}));
            }
            {
                this.userDN$1 = userDN$1;
                this.successfulWord$1 = successfulWord$1;
            }
        });
        ResultCode resultCode4 = result;
        ResultCode resultCode5 = ResultCode.SUCCESS;
        if (resultCode4 != null) {
            if (!resultCode4.equals(resultCode5)) return false;
            return true;
        }
        if (resultCode5 == null) return true;
        return false;
    }

    private Traversable<Entry> listUserSubEntries(String uid, String baseDN) {
        Filter personFilter = Filter.createEqualityFilter((String)"objectClass", (String)"person");
        Filter idFilter = Filter.createEqualityFilter((String)"uid", (String)uid);
        Filter idPersonFilter = Filter.createANDFilter((Filter[])new Filter[]{idFilter, personFilter});
        SearchRequest request = new SearchRequest(baseDN, SearchScope.SUB, idPersonFilter, new String[0]);
        return this.search(request);
    }

    @Override
    public Option<Entry> getEntry(String dn) {
        return this.interface().flatMap((Function1)new Serializable(this, dn){
            public static final long serialVersionUID = 0L;
            private final String dn$1;

            public final Option<SearchResultEntry> apply(LDAPInterface lDAPInterface) {
                return Option$.MODULE$.apply((Object)lDAPInterface.getEntry(this.dn$1));
            }
            {
                this.dn$1 = dn$1;
            }
        });
    }

    @Override
    public Traversable<String> listEntries() {
        Option<LDAPInterface> option;
        block4: {
            Nil$ nil$;
            block3: {
                block2: {
                    option = this.interface();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    LDAPInterface lDAPInterface = (LDAPInterface)some.x();
                    SearchRequest searchRequest = new SearchRequest(this.settings.dit(), SearchScope.SUB, Filter.create((String)"(objectClass=*)"), new String[0]);
                    Traversable<Entry> entries = this.dispatchSearchRequest(lDAPInterface, searchRequest);
                    nil$ = (Traversable)entries.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Entry x$1) {
                            return x$1.toString();
                        }
                    }, Traversable$.MODULE$.canBuildFrom());
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                nil$ = Nil$.MODULE$;
            }
            return nil$;
        }
        throw new MatchError(option);
    }

    private Traversable<Entry> search(SearchRequest searchRequest) {
        Option<LDAPInterface> option;
        block4: {
            Traversable<Entry> traversable;
            block3: {
                block2: {
                    option = this.interface();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    LDAPInterface lDAPInterface = (LDAPInterface)some.x();
                    traversable = this.dispatchSearchRequest(lDAPInterface, searchRequest);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                traversable = Nil$.MODULE$;
            }
            return traversable;
        }
        throw new MatchError(option);
    }

    private Traversable<Entry> dispatchSearchRequest(LDAPInterface lDAPInterface, SearchRequest request) {
        Nil$ nil$;
        try {
            nil$ = JavaConversions$.MODULE$.asScalaBuffer(lDAPInterface.search(request).getSearchEntries());
        }
        catch (Throwable throwable) {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    @Inject
    public LdapServiceImpl(LdapSettings settings, ApplicationLifecycle applicationLifecycle) {
        this.settings = settings;
        this.applicationLifecycle = applicationLifecycle;
        this.interface = this.setupInterface();
        this.logger = Logger$.MODULE$;
    }
}

