/*
 * Decompiled with CFR 0.152.
 */
package org.ada.server.services.ldap;

import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.PostConnectProcessor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.StartTLSPostConnectProcessor;
import com.unboundid.ldap.sdk.extensions.StartTLSExtendedRequest;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustAllTrustManager;
import com.unboundid.util.ssl.TrustStoreTrustManager;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.ada.server.services.ldap.LDAPInterfaceFactory$;
import play.api.Logger$;
import play.api.inject.ApplicationLifecycle;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Unit$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class LDAPInterfaceFactory$ {
    public static final LDAPInterfaceFactory$ MODULE$;

    static {
        new LDAPInterfaceFactory$();
    }

    public LDAPInterface createLocalServer(String dit, int port, ApplicationLifecycle applicationLifecycle) {
        InMemoryDirectoryServerConfig config = new InMemoryDirectoryServerConfig(new String[]{dit});
        config.setSchema(null);
        config.setAuthenticationRequiredOperationTypes(new OperationType[]{OperationType.DELETE, OperationType.ADD, OperationType.MODIFY, OperationType.MODIFY_DN});
        InMemoryListenerConfig listenerConfig = new InMemoryListenerConfig("defaultListener", null, port, null, null, null);
        config.setListenerConfigs(new InMemoryListenerConfig[]{listenerConfig});
        InMemoryDirectoryServer server = new InMemoryDirectoryServer(config);
        server.startListening();
        server.add(new String[]{new StringBuilder().append((Object)"dn: ").append((Object)dit).toString(), "objectClass:top", "objectClass:domain", dit.replace("=", ":")});
        server.add(new String[]{new StringBuilder().append((Object)"dn:dc=groups,").append((Object)dit).toString(), "objectClass:top", "objectClass:domain", "dc:roles"});
        server.add(new String[]{new StringBuilder().append((Object)"dn:dc=users,").append((Object)dit).toString(), "objectClass:top", "objectClass:domain", "dc:users"});
        applicationLifecycle.addStopHook((Function0)new Serializable(server){
            public static final long serialVersionUID = 0L;
            public final InMemoryDirectoryServer server$1;

            public final Future<Object> apply() {
                return Future$.MODULE$.apply((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.createLocalServer.1 $outer;

                    public final Object apply() {
                        return LDAPInterfaceFactory$.MODULE$.org$ada$server$services$ldap$LDAPInterfaceFactory$$terminateInterface((LDAPInterface)this.$outer.server$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
            }
            {
                this.server$1 = server$1;
            }
        });
        Logger$.MODULE$.info((Function0)new Serializable(port){
            public static final long serialVersionUID = 0L;
            private final int port$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Local LDAP server started at the port ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.port$1)}));
            }
            {
                this.port$1 = port$1;
            }
        });
        return server;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<LDAPConnectionPool> createConnectionPool(String host, int port, String encryption, Option<String> trustStore, String bindDN, String password, ApplicationLifecycle applicationLifecycle, LDAPConnectionOptions options) {
        None$ none$;
        ResultCode result;
        ResultCode resultCode;
        Tuple2 tuple22;
        Tuple2<LDAPConnection, Option<PostConnectProcessor>> tuple2 = this.createConnection(host, port, encryption, trustStore, options);
        if (tuple2 == null) throw new MatchError(tuple2);
        LDAPConnection connection2 = (LDAPConnection)tuple2._1();
        Option processor2 = (Option)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)connection2, (Object)processor2);
        LDAPConnection connection = (LDAPConnection)tuple23._1();
        Option processor = (Option)tuple23._2();
        try {
            resultCode = connection.bind(bindDN, password).getResultCode();
        }
        catch (Throwable throwable) {
            resultCode = ResultCode.NO_SUCH_OBJECT;
        }
        ResultCode resultCode2 = result = resultCode;
        ResultCode resultCode3 = ResultCode.SUCCESS;
        if (!(resultCode2 != null ? !resultCode2.equals(resultCode3) : resultCode3 != null)) {
            Logger$.MODULE$.info((Function0)new Serializable(host, port, encryption){
                public static final long serialVersionUID = 0L;
                private final String host$1;
                private final int port$2;
                private final String encryption$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " LDAP connection to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.encryption$1}))).append((Object)this.host$1).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)this.port$2)).append((Object)" established").toString();
                }
                {
                    this.host$1 = host$1;
                    this.port$2 = port$2;
                    this.encryption$1 = encryption$1;
                }
            });
            none$ = new Some((Object)this.createConnectionPool(connection, (Option<PostConnectProcessor>)processor, applicationLifecycle));
            return none$;
        } else {
            Logger$.MODULE$.warn((Function0)new Serializable(host, port){
                public static final long serialVersionUID = 0L;
                private final String host$1;
                private final int port$2;

                public final String apply() {
                    return new StringBuilder().append((Object)"Failed to establish connection to ").append((Object)this.host$1).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)this.port$2)).toString();
                }
                {
                    this.host$1 = host$1;
                    this.port$2 = port$2;
                }
            });
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Tuple2<LDAPConnection, Option<PostConnectProcessor>> createConnection(String host, int port, String encryption, Option<String> trustStore, LDAPConnectionOptions options) {
        Tuple2 tuple2;
        SSLUtil sslUtil = this.setupSSLUtil(trustStore);
        String string = encryption;
        if ("ssl".equals(string)) {
            SSLSocketFactory sslSocketFactory = sslUtil.createSSLSocketFactory();
            LDAPConnection connection = new LDAPConnection((SocketFactory)sslSocketFactory, options, host, port);
            tuple2 = new Tuple2((Object)connection, (Object)None$.MODULE$);
        } else if ("starttls".equals(string)) {
            LDAPConnection connection = new LDAPConnection(options, host, port);
            SSLContext sslContext = sslUtil.createSSLContext();
            connection.processExtendedOperation((ExtendedRequest)new StartTLSExtendedRequest(sslContext));
            StartTLSPostConnectProcessor processor = new StartTLSPostConnectProcessor(sslContext);
            tuple2 = new Tuple2((Object)connection, (Object)new Some((Object)processor));
        } else {
            LDAPConnection connection = new LDAPConnection(options, host, port);
            tuple2 = new Tuple2((Object)connection, (Object)None$.MODULE$);
        }
        return tuple2;
    }

    public LDAPConnectionOptions createConnection$default$5() {
        return new LDAPConnectionOptions();
    }

    private LDAPConnectionPool createConnectionPool(LDAPConnection connection, Option<PostConnectProcessor> processor, ApplicationLifecycle applicationLifecycle) {
        LDAPConnectionPool connectionPool = (LDAPConnectionPool)processor.map((Function1)new Serializable(connection){
            public static final long serialVersionUID = 0L;
            private final LDAPConnection connection$1;

            public final LDAPConnectionPool apply(PostConnectProcessor x$2) {
                return new LDAPConnectionPool(this.connection$1, 1, 10, x$2);
            }
            {
                this.connection$1 = connection$1;
            }
        }).getOrElse((Function0)new Serializable(connection){
            public static final long serialVersionUID = 0L;
            private final LDAPConnection connection$1;

            public final LDAPConnectionPool apply() {
                return new LDAPConnectionPool(this.connection$1, 1, 10);
            }
            {
                this.connection$1 = connection$1;
            }
        });
        applicationLifecycle.addStopHook((Function0)new Serializable(connectionPool){
            public static final long serialVersionUID = 0L;
            public final LDAPConnectionPool connectionPool$1;

            public final Future<Object> apply() {
                return Future$.MODULE$.apply((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.createConnectionPool.3 $outer;

                    public final Object apply() {
                        return LDAPInterfaceFactory$.MODULE$.org$ada$server$services$ldap$LDAPInterfaceFactory$$terminateInterface((LDAPInterface)this.$outer.connectionPool$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
            }
            {
                this.connectionPool$1 = connectionPool$1;
            }
        });
        return connectionPool;
    }

    public LDAPConnectionOptions createConnectionPool$default$8() {
        return new LDAPConnectionOptions();
    }

    private SSLUtil setupSSLUtil(Option<String> trustStore) {
        Option<String> option;
        block4: {
            SSLUtil sSLUtil;
            block3: {
                block2: {
                    option = trustStore;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String path = (String)some.x();
                    sSLUtil = new SSLUtil((TrustManager)new TrustStoreTrustManager(path));
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                sSLUtil = new SSLUtil((TrustManager)new TrustAllTrustManager());
            }
            return sSLUtil;
        }
        throw new MatchError(option);
    }

    public Object org$ada$server$services$ldap$LDAPInterfaceFactory$$terminateInterface(LDAPInterface lDAPInterface) {
        BoxedUnit boxedUnit;
        LDAPInterface lDAPInterface2 = lDAPInterface;
        if (lDAPInterface2 instanceof InMemoryDirectoryServer) {
            InMemoryDirectoryServer inMemoryDirectoryServer = (InMemoryDirectoryServer)lDAPInterface2;
            inMemoryDirectoryServer.shutDown(true);
            boxedUnit = BoxedUnit.UNIT;
        } else if (lDAPInterface2 instanceof LDAPConnection) {
            LDAPConnection lDAPConnection = (LDAPConnection)lDAPInterface2;
            lDAPConnection.close();
            boxedUnit = BoxedUnit.UNIT;
        } else if (lDAPInterface2 instanceof LDAPConnectionPool) {
            LDAPConnectionPool lDAPConnectionPool = (LDAPConnectionPool)lDAPInterface2;
            lDAPConnectionPool.close();
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = Unit$.MODULE$;
        }
        return boxedUnit;
    }

    private LDAPInterfaceFactory$() {
        MODULE$ = this;
    }
}

