/*
 * Decompiled with CFR 0.152.
 */
package org.ada.server.services.ldap;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.ada.server.AdaException;
import org.ada.server.models.LdapUser;
import org.ada.server.models.UserGroup;
import org.ada.server.services.ldap.LDAPInterfaceFactory$;
import org.ada.server.services.ldap.LdapService;
import org.ada.server.services.ldap.LdapSettings;
import play.api.Logger$;
import play.api.inject.ApplicationLifecycle;
import reactivemongo.bson.BSONObjectID;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Singleton
@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\u0001\u0003\u00115\u0011q\u0002\u00143baN+'O^5dK&k\u0007\u000f\u001c\u0006\u0003\u0007\u0011\tA\u0001\u001c3ba*\u0011QAB\u0001\tg\u0016\u0014h/[2fg*\u0011q\u0001C\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005%Q\u0011aA1eC*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u0017\u001b\u0005\u0011\u0011BA\f\u0003\u0005-aE-\u00199TKJ4\u0018nY3\t\u0011e\u0001!\u0011!Q\u0001\ni\t\u0001b]3ui&twm\u001d\t\u0003+mI!\u0001\b\u0002\u0003\u00191#\u0017\r]*fiRLgnZ:\t\u0011y\u0001!\u0011!Q\u0001\n}\tA#\u00199qY&\u001c\u0017\r^5p]2Kg-Z2zG2,\u0007C\u0001\u0011(\u001b\u0005\t#B\u0001\u0012$\u0003\u0019IgN[3di*\u0011A%J\u0001\u0004CBL'\"\u0001\u0014\u0002\tAd\u0017-_\u0005\u0003Q\u0005\u0012A#\u00119qY&\u001c\u0017\r^5p]2Kg-Z2zG2,\u0007\"\u0002\u0016\u0001\t\u0003Y\u0013A\u0002\u001fj]&$h\bF\u0002-[9\u0002\"!\u0006\u0001\t\u000beI\u0003\u0019\u0001\u000e\t\u000byI\u0003\u0019A\u0010)\u0005%\u0002\u0004CA\u00196\u001b\u0005\u0011$B\u0001\u00124\u0015\u0005!\u0014!\u00026bm\u0006D\u0018B\u0001\u001c3\u0005\u0019IeN[3di\"9\u0001\b\u0001b\u0001\n\u0013I\u0014!C5oi\u0016\u0014h-Y2f+\u0005Q\u0004cA\b<{%\u0011A\b\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005y2U\"A \u000b\u0005\u0001\u000b\u0015aA:eW*\u00111A\u0011\u0006\u0003\u0007\u0012\u000b\u0011\"\u001e8c_VtG-\u001b3\u000b\u0003\u0015\u000b1aY8n\u0013\t9uHA\u0007M\t\u0006\u0003\u0016J\u001c;fe\u001a\f7-\u001a\u0005\u0007\u0013\u0002\u0001\u000b\u0011\u0002\u001e\u0002\u0015%tG/\u001a:gC\u000e,\u0007\u0005C\u0004L\u0001\t\u0007I\u0011\u0002'\u0002#\r|gN\\3di&|gn\u00149uS>t7/F\u0001N!\tqd*\u0003\u0002P\u007f\t)B\nR!Q\u0007>tg.Z2uS>tw\n\u001d;j_:\u001c\bBB)\u0001A\u0003%Q*\u0001\nd_:tWm\u0019;j_:|\u0005\u000f^5p]N\u0004\u0003bB*\u0001\u0005\u0004%I\u0001V\u0001\u0007Y><w-\u001a:\u0016\u0003Us!AV,\u000e\u0003\rJ!\u0001W\u0012\u0002\r1{wmZ3s\u0011\u0019Q\u0006\u0001)A\u0005+\u00069An\\4hKJ\u0004\u0003\"\u0002/\u0001\t\u0003j\u0016!\u00037jgR,6/\u001a:t+\u0005q\u0006cA0hU:\u0011\u0001-\u001a\b\u0003C\u0012l\u0011A\u0019\u0006\u0003G2\ta\u0001\u0010:p_Rt\u0014\"A\t\n\u0005\u0019\u0004\u0012a\u00029bG.\fw-Z\u0005\u0003Q&\u00141\u0002\u0016:bm\u0016\u00148/\u00192mK*\u0011a\r\u0005\t\u0003W:l\u0011\u0001\u001c\u0006\u0003[\u001a\ta!\\8eK2\u001c\u0018BA8m\u0005!aE-\u00199Vg\u0016\u0014\b\"B9\u0001\t\u0013\u0011\u0018aD3oiJLHk\u001c'eCB,6/\u001a:\u0015\u0005M$\bcA\b<U\")Q\u000f\u001da\u0001m\u0006)QM\u001c;ssB\u0011ah^\u0005\u0003q~\u0012Q!\u00128uefDQA\u001f\u0001\u0005\nm\f\u0001#\u001a8uef$v.V:fe\u001e\u0013x.\u001e9\u0015\u0007q\f\t\u0001E\u0002\u0010wu\u0004\"a\u001b@\n\u0005}d'!C+tKJ<%o\\;q\u0011\u0015)\u0018\u00101\u0001w\u0011\u0019\t)\u0001\u0001C\u0005s\u0005q1/\u001a;va&sG/\u001a:gC\u000e,\u0007bBA\u0005\u0001\u0011\u0005\u00131B\u0001\bG\u0006t')\u001b8e)\u0019\ti!a\u0005\u0002&A\u0019q\"a\u0004\n\u0007\u0005E\u0001CA\u0004C_>dW-\u00198\t\u0011\u0005U\u0011q\u0001a\u0001\u0003/\t1!^5e!\u0011\tI\"a\b\u000f\u0007=\tY\"C\u0002\u0002\u001eA\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0011\u0003G\u0011aa\u0015;sS:<'bAA\u000f!!A\u0011qEA\u0004\u0001\u0004\t9\"\u0001\u0005qCN\u001cxo\u001c:e\u0011\u001d\tY\u0003\u0001C\u0005\u0003[\t!bY1o\u0005&tG-Q;y)\u0019\ti!a\f\u00024!A\u0011\u0011GA\u0015\u0001\u0004\t9\"\u0001\u0004vg\u0016\u0014HI\u0014\u0005\t\u0003O\tI\u00031\u0001\u0002\u0018!9\u0011q\u0007\u0001\u0005\n\u0005e\u0012A\u00057jgR,6/\u001a:Tk\n,e\u000e\u001e:jKN$b!a\u000f\u0002>\u0005}\u0002cA0hm\"A\u0011QCA\u001b\u0001\u0004\t9\u0002\u0003\u0005\u0002B\u0005U\u0002\u0019AA\f\u0003\u0019\u0011\u0017m]3E\u001d\"9\u0011Q\t\u0001\u0005B\u0005\u001d\u0013\u0001C4fi\u0016sGO]=\u0015\t\u0005%\u00131\n\t\u0004\u001fm2\b\u0002CA'\u0003\u0007\u0002\r!a\u0006\u0002\u0005\u0011t\u0007bBA)\u0001\u0011\u0005\u00131K\u0001\fY&\u001cH/\u00128ue&,7/\u0006\u0002\u0002VA!qlZA\f\u0011\u001d\tI\u0006\u0001C\u0005\u00037\naa]3be\u000eDG\u0003BA\u001e\u0003;B\u0001\"a\u0018\u0002X\u0001\u0007\u0011\u0011M\u0001\u000eg\u0016\f'o\u00195SKF,Xm\u001d;\u0011\u0007y\n\u0019'C\u0002\u0002f}\u0012QbU3be\u000eD'+Z9vKN$\bbBA5\u0001\u0011%\u00111N\u0001\u0016I&\u001c\b/\u0019;dQN+\u0017M]2i%\u0016\fX/Z:u)\u0019\tY$!\u001c\u0002p!1\u0001(a\u001aA\u0002uB\u0001\"!\u001d\u0002h\u0001\u0007\u0011\u0011M\u0001\be\u0016\fX/Z:u\u0011\u0019\t)\b\u0001C\u0005\u0019\u000692M]3bi\u0016\u001cuN\u001c8fGRLwN\\(qi&|gn\u001d\u0015\u0004\u0001\u0005e\u0004cA\u0019\u0002|%\u0019\u0011Q\u0010\u001a\u0003\u0013MKgn\u001a7fi>t\u0007")
public class LdapServiceImpl
implements LdapService {
    private final LdapSettings settings;
    private final ApplicationLifecycle applicationLifecycle;
    private final Option<LDAPInterface> interface;
    private final LDAPConnectionOptions connectionOptions;
    private final Logger$ logger;

    private Option<LDAPInterface> interface() {
        return this.interface;
    }

    private LDAPConnectionOptions connectionOptions() {
        return this.connectionOptions;
    }

    private Logger$ logger() {
        return this.logger;
    }

    @Override
    public Traversable<LdapUser> listUsers() {
        Filter filter;
        Filter personFilter = Filter.createEqualityFilter((String)"objectClass", (String)"person");
        if (this.settings.groups().nonEmpty()) {
            Seq memberFilter = (Seq)this.settings.groups().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Filter apply(String groupname) {
                    return Filter.createEqualityFilter((String)"memberof", (String)groupname);
                }
            }, Seq$.MODULE$.canBuildFrom());
            filter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createORFilter((List)JavaConversions$.MODULE$.seqAsJavaList(memberFilter)), personFilter});
        } else {
            filter = personFilter;
        }
        Filter filterUsers = filter;
        SearchRequest request = new SearchRequest(this.settings.dit(), SearchScope.SUB, filterUsers, new String[0]);
        Traversable<Entry> entries = this.search(request);
        return (Traversable)((GenericTraversableTemplate)entries.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LdapServiceImpl $outer;

            public final Option<LdapUser> apply(Entry entry) {
                return this.$outer.org$ada$server$services$ldap$LdapServiceImpl$$entryToLdapUser(entry);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Traversable$.MODULE$.canBuildFrom())).flatten((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<LdapUser> apply(Option<LdapUser> xo) {
                return Option$.MODULE$.option2Iterable(xo);
            }
        });
    }

    public Option<LdapUser> org$ada$server$services$ldap$LdapServiceImpl$$entryToLdapUser(Entry entry) {
        return Option$.MODULE$.apply((Object)entry).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LdapUser apply(Entry entry) {
                String uid = entry.getAttributeValue("uid");
                String name = entry.getAttributeValue("cn");
                String email = entry.getAttributeValue("mail");
                String ou = entry.getAttributeValue("ou");
                String[] permissions = (String[])Option$.MODULE$.apply((Object)entry.getAttributeValues("memberof")).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String[] apply() {
                        return (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
                    }
                });
                return new LdapUser(uid, name, email, ou, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])permissions));
            }
        });
    }

    private Option<UserGroup> entryToUserGroup(Entry entry) {
        None$ none$;
        Option option = Option$.MODULE$.apply((Object)entry);
        if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            String name = entry.getAttributeValue("cn");
            String[] members = (String[])Option$.MODULE$.apply((Object)entry.getAttributeValues("member")).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String[] apply() {
                    return (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
                }
            });
            Option description = Option$.MODULE$.apply((Object)entry.getAttributeValue("description"));
            String[] nested = (String[])Option$.MODULE$.apply((Object)entry.getAttributeValues("memberof")).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String[] apply() {
                    return (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
                }
            });
            none$ = new Some((Object)new UserGroup((Option<BSONObjectID>)None$.MODULE$, name, (Option<String>)description, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])members), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])nested)));
        }
        return none$;
    }

    private Option<LDAPInterface> setupInterface() {
        Option<LDAPConnectionPool> option;
        String string = this.settings.mode();
        if ("local".equals(string)) {
            option = new Some((Object)LDAPInterfaceFactory$.MODULE$.createLocalServer(this.settings.dit(), this.settings.port(), this.applicationLifecycle));
        } else if ("remote".equals(string)) {
            String password = (String)this.settings.bindPassword().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    throw new AdaException("Environmental variable 'ADA_LDAP_BIND_PASSWORD' or a conf entry 'ldap.bindPassword' not set but expected.");
                }
            });
            option = LDAPInterfaceFactory$.MODULE$.createConnectionPool(this.settings.host(), this.settings.port(), this.settings.encryption(), this.settings.trustStore(), this.settings.bindDN(), password, this.applicationLifecycle, this.connectionOptions());
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    @Override
    public boolean canBind(String uid, String password) {
        boolean bl;
        if (this.settings.recursiveDitAuthenticationSearch()) {
            bl = BoxesRunTime.unboxToBoolean((Object)this.listUserSubEntries(uid, this.settings.dit()).headOption().map((Function1)new Serializable(this, password){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LdapServiceImpl $outer;
                private final String password$1;

                public final boolean apply(Entry userEntry) {
                    return this.$outer.org$ada$server$services$ldap$LdapServiceImpl$$canBindAux(userEntry.getDN(), this.password$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.password$1 = password$1;
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return false;
                }
            }));
        } else {
            String userDN = new StringBuilder().append((Object)"uid=").append((Object)uid).append((Object)",").append((Object)this.settings.dit()).toString();
            bl = this.org$ada$server$services$ldap$LdapServiceImpl$$canBindAux(userDN, password);
        }
        return bl;
    }

    public boolean org$ada$server$services$ldap$LdapServiceImpl$$canBindAux(String userDN, String password) {
        ResultCode result;
        this.logger().info((Function0)new Serializable(this, userDN){
            public static final long serialVersionUID = 0L;
            private final String userDN$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking the user credentials for ", " in LDAP."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.userDN$1}));
            }
            {
                this.userDN$1 = userDN$1;
            }
        });
        String string = this.settings.mode();
        Object object = "local".equals(string) ? new Some(LDAPInterfaceFactory$.MODULE$.createConnection("localhost", this.settings.port(), this.settings.encryption(), this.settings.trustStore(), this.connectionOptions())._1()) : ("remote".equals(string) ? new Some(LDAPInterfaceFactory$.MODULE$.createConnection(this.settings.host(), this.settings.port(), this.settings.encryption(), this.settings.trustStore(), this.connectionOptions())._1()) : None$.MODULE$);
        None$ connection = object;
        ResultCode resultCode = result = (ResultCode)connection.map((Function1)new Serializable(this, userDN, password){
            public static final long serialVersionUID = 0L;
            private final String userDN$1;
            private final String password$2;

            public final ResultCode apply(LDAPConnection connection) {
                ResultCode resultCode;
                try {
                    try {
                        resultCode = connection.bind(this.userDN$1, this.password$2).getResultCode();
                    }
                    catch (LDAPException lDAPException) {
                        resultCode = ResultCode.NO_SUCH_OBJECT;
                    }
                }
                finally {
                    connection.close();
                }
                return resultCode;
            }
            {
                this.userDN$1 = userDN$1;
                this.password$2 = password$2;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ResultCode apply() {
                return ResultCode.AUTH_UNKNOWN;
            }
        });
        ResultCode resultCode2 = ResultCode.SUCCESS;
        String successfulWord = !(resultCode != null ? !resultCode.equals(resultCode2) : resultCode2 != null) ? "successful" : "unsuccessful";
        this.logger().info((Function0)new Serializable(this, userDN, successfulWord){
            public static final long serialVersionUID = 0L;
            private final String userDN$1;
            private final String successfulWord$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The LDAP verification for ", " is ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.userDN$1, this.successfulWord$1.toUpperCase()}));
            }
            {
                this.userDN$1 = userDN$1;
                this.successfulWord$1 = successfulWord$1;
            }
        });
        ResultCode resultCode3 = result;
        ResultCode resultCode4 = ResultCode.SUCCESS;
        return !(resultCode3 != null ? !resultCode3.equals(resultCode4) : resultCode4 != null);
    }

    private Traversable<Entry> listUserSubEntries(String uid, String baseDN) {
        Filter personFilter = Filter.createEqualityFilter((String)"objectClass", (String)"person");
        Filter idFilter = Filter.createEqualityFilter((String)"uid", (String)uid);
        Filter idPersonFilter = Filter.createANDFilter((Filter[])new Filter[]{idFilter, personFilter});
        SearchRequest request = new SearchRequest(baseDN, SearchScope.SUB, idPersonFilter, new String[0]);
        return this.search(request);
    }

    @Override
    public Option<Entry> getEntry(String dn) {
        return this.interface().flatMap((Function1)new Serializable(this, dn){
            public static final long serialVersionUID = 0L;
            private final String dn$1;

            public final Option<SearchResultEntry> apply(LDAPInterface lDAPInterface) {
                return Option$.MODULE$.apply((Object)lDAPInterface.getEntry(this.dn$1));
            }
            {
                this.dn$1 = dn$1;
            }
        });
    }

    @Override
    public Traversable<String> listEntries() {
        Option<LDAPInterface> option;
        block4: {
            Nil$ nil$;
            block3: {
                block2: {
                    option = this.interface();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    LDAPInterface lDAPInterface = (LDAPInterface)some.x();
                    SearchRequest searchRequest = new SearchRequest(this.settings.dit(), SearchScope.SUB, Filter.create((String)"(objectClass=*)"), new String[0]);
                    Traversable<Entry> entries = this.dispatchSearchRequest(lDAPInterface, searchRequest);
                    nil$ = (Traversable)entries.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Entry x$1) {
                            return x$1.toString();
                        }
                    }, Traversable$.MODULE$.canBuildFrom());
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                nil$ = Nil$.MODULE$;
            }
            return nil$;
        }
        throw new MatchError(option);
    }

    private Traversable<Entry> search(SearchRequest searchRequest) {
        Option<LDAPInterface> option;
        block4: {
            Traversable<Entry> traversable;
            block3: {
                block2: {
                    option = this.interface();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    LDAPInterface lDAPInterface = (LDAPInterface)some.x();
                    traversable = this.dispatchSearchRequest(lDAPInterface, searchRequest);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                traversable = Nil$.MODULE$;
            }
            return traversable;
        }
        throw new MatchError(option);
    }

    private Traversable<Entry> dispatchSearchRequest(LDAPInterface lDAPInterface, SearchRequest request) {
        Nil$ nil$;
        try {
            nil$ = JavaConversions$.MODULE$.asScalaBuffer(lDAPInterface.search(request).getSearchEntries());
        }
        catch (Throwable throwable) {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    /*
     * WARNING - void declaration
     */
    private LDAPConnectionOptions createConnectionOptions() {
        void var1_1;
        LDAPConnectionOptions options = new LDAPConnectionOptions();
        this.settings.connectTimeout().foreach((Function1)new Serializable(this, options){
            public static final long serialVersionUID = 0L;
            private final LDAPConnectionOptions options$1;

            public final void apply(int x$2) {
                this.apply$mcVI$sp(x$2);
            }

            public void apply$mcVI$sp(int x$2) {
                this.options$1.setConnectTimeoutMillis(x$2);
            }
            {
                this.options$1 = options$1;
            }
        });
        this.settings.responseTimeout().foreach((Function1)new Serializable(this, options){
            public static final long serialVersionUID = 0L;
            private final LDAPConnectionOptions options$1;

            public final void apply(long x$3) {
                this.apply$mcVJ$sp(x$3);
            }

            public void apply$mcVJ$sp(long x$3) {
                this.options$1.setResponseTimeoutMillis(x$3);
            }
            {
                this.options$1 = options$1;
            }
        });
        this.settings.pooledSchemaTimeout().foreach((Function1)new Serializable(this, options){
            public static final long serialVersionUID = 0L;
            private final LDAPConnectionOptions options$1;

            public final void apply(long x$4) {
                this.apply$mcVJ$sp(x$4);
            }

            public void apply$mcVJ$sp(long x$4) {
                this.options$1.setPooledSchemaTimeoutMillis(x$4);
            }
            {
                this.options$1 = options$1;
            }
        });
        this.settings.abandonOnTimeout().foreach((Function1)new Serializable(this, options){
            public static final long serialVersionUID = 0L;
            private final LDAPConnectionOptions options$1;

            public final void apply(boolean x$5) {
                this.options$1.setAbandonOnTimeout(x$5);
            }
            {
                this.options$1 = options$1;
            }
        });
        return var1_1;
    }

    @Inject
    public LdapServiceImpl(LdapSettings settings, ApplicationLifecycle applicationLifecycle) {
        this.settings = settings;
        this.applicationLifecycle = applicationLifecycle;
        this.interface = this.setupInterface();
        this.connectionOptions = this.createConnectionOptions();
        this.logger = Logger$.MODULE$;
    }
}

