/*
 * Decompiled with CFR 0.152.
 */
package org.ada.server.calc.impl;

import org.ada.server.calc.CommonsMathUtil$;
import org.ada.server.calc.impl.ChiSquareHelper;
import org.ada.server.calc.impl.ChiSquareHelper$;
import org.ada.server.calc.impl.ChiSquareResult;
import org.apache.commons.math3.exception.MaxCountExceededException;
import play.api.Logger$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public abstract class ChiSquareHelper$class {
    public static Option calcChiSquareSafe(ChiSquareHelper $this, Map countsMap) {
        None$ none$;
        Seq values1 = ((TraversableOnce)countsMap.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final T1 apply(Tuple2<Tuple2<T1, T2>, Object> x$1) {
                return (T1)((Tuple2)x$1._1())._1();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet().toSeq();
        Seq values2 = ((TraversableOnce)countsMap.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final T2 apply(Tuple2<Tuple2<T1, T2>, Object> x$2) {
                return (T2)((Tuple2)x$2._1())._2();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet().toSeq();
        Seq counts = (Seq)values1.map((Function1)new Serializable($this, values2, countsMap){
            public static final long serialVersionUID = 0L;
            private final Seq values2$1;
            public final Map countsMap$1;

            public final Seq<Object> apply(T1 value1) {
                return (Seq)this.values2$1.map((Function1)new Serializable(this, value1){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ChiSquareHelper$.anonfun.4 $outer;
                    private final Object value1$1;

                    public final int apply(T2 value2) {
                        return BoxesRunTime.unboxToInt((Object)this.$outer.countsMap$1.get((Object)new Tuple2(this.value1$1, value2)).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return 0;
                            }
                        }));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.value1$1 = value1$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                void var3_3;
                this.values2$1 = values2$1;
                this.countsMap$1 = var3_3;
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (values1.size() < 2 || values2.size() < 2) {
            Logger$.MODULE$.warn((Function0)new Serializable($this, values1, values2){
                public static final long serialVersionUID = 0L;
                private final Seq values1$1;
                private final Seq values2$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not enough values to perform Chi-Square test for: ", " x ", " counts."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.values1$1.size()), BoxesRunTime.boxToInteger((int)this.values2$1.size())}));
                }
                {
                    void var3_3;
                    this.values1$1 = values1$1;
                    this.values2$1 = var3_3;
                }
            });
            none$ = None$.MODULE$;
        } else {
            try {
                none$ = $this.calcChiSquare((Seq<Seq<Object>>)counts);
            }
            catch (MaxCountExceededException maxCountExceededException) {
                Logger$.MODULE$.warn((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max number of iterations reached for a Chi-Square test."})).s((Seq)Nil$.MODULE$);
                    }
                });
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    public static Option calcChiSquare(ChiSquareHelper $this, Seq counts) {
        Some some;
        double stats = ChiSquareHelper$class.chiSquareStatistics($this, counts);
        double df = ((double)counts.length() - 1.0) * ((double)((SeqLike)counts.apply(0)).length() - 1.0);
        double shape = df / (double)2;
        int scale = 2;
        if (stats <= 0.0) {
            some = new Some((Object)ChiSquareHelper$class.result$1($this, BigDecimal$.MODULE$.double2bigDecimal(1.0), stats, df));
        } else {
            Option<BigDecimal> gamma = CommonsMathUtil$.MODULE$.regularizedGammaP(shape, stats / (double)scale, $this.org$ada$server$calc$impl$ChiSquareHelper$$epsilon(), Integer.MAX_VALUE);
            some = gamma.map((Function1)new Serializable($this, stats, df){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ChiSquareHelper $outer;
                private final double stats$1;
                private final double df$1;

                public final ChiSquareResult apply(BigDecimal gamma) {
                    return ChiSquareHelper$class.result$1(this.$outer, BigDecimal$.MODULE$.double2bigDecimal(1.0).$minus(gamma), this.stats$1, this.df$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.stats$1 = stats$1;
                    this.df$1 = df$1;
                }
            });
        }
        return some;
    }

    private static double chiSquareStatistics(ChiSquareHelper $this, Seq counts) {
        int colsNum = ((SeqLike)counts.apply(0)).size();
        Seq rowSums = (Seq)counts.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(Seq<Object> x$3) {
                return BoxesRunTime.unboxToInt((Object)x$3.sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            }
        }, Seq$.MODULE$.canBuildFrom());
        IndexedSeq colSums = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), colsNum - 1).map((Function1)new Serializable($this, counts){
            public static final long serialVersionUID = 0L;
            private final Seq counts$1;

            public final int apply(int col) {
                return this.apply$mcII$sp(col);
            }

            public int apply$mcII$sp(int col) {
                return BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.counts$1.map((Function1)new Serializable(this, col){
                    public static final long serialVersionUID = 0L;
                    private final int col$1;

                    public final int apply(Seq<Object> x$4) {
                        return BoxesRunTime.unboxToInt((Object)x$4.apply(this.col$1));
                    }
                    {
                        this.col$1 = col$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            }
            {
                this.counts$1 = counts$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        double total = BoxesRunTime.unboxToInt((Object)rowSums.sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)counts.zipWithIndex(Seq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable($this, rowSums, colSums, total){
            public static final long serialVersionUID = 0L;
            public final Seq rowSums$1;
            public final IndexedSeq colSums$1;
            public final double total$1;

            public final Seq<Object> apply(Tuple2<Seq<Object>, Object> x0$1) {
                Tuple2<Seq<Object>, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Seq row = (Seq)tuple2._1();
                    int rowIndex = tuple2._2$mcI$sp();
                    Seq seq = (Seq)((TraversableLike)row.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, rowIndex){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ChiSquareHelper$.anonfun.chiSquareStatistics.1 $outer;
                        private final int rowIndex$1;

                        public final double apply(Tuple2<Object, Object> x0$2) {
                            Tuple2<Object, Object> tuple2 = x0$2;
                            if (tuple2 != null) {
                                int value2 = tuple2._1$mcI$sp();
                                int colIndex = tuple2._2$mcI$sp();
                                double expected = (double)(BoxesRunTime.unboxToInt((Object)this.$outer.rowSums$1.apply(this.rowIndex$1)) * BoxesRunTime.unboxToInt((Object)this.$outer.colSums$1.apply(colIndex))) / this.$outer.total$1;
                                double d = ((double)value2 - expected) * ((double)value2 - expected) / expected;
                                return d;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.rowIndex$1 = rowIndex$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    return seq;
                }
                throw new MatchError(tuple2);
            }
            {
                void var3_3;
                this.rowSums$1 = rowSums$1;
                this.colSums$1 = var3_3;
                this.total$1 = total$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public static final ChiSquareResult result$1(ChiSquareHelper $this, BigDecimal pValue, double stats$1, double df$1) {
        return new ChiSquareResult(pValue.doubleValue(), stats$1, (int)df$1);
    }

    public static void $init$(ChiSquareHelper $this) {
        $this.org$ada$server$calc$impl$ChiSquareHelper$_setter_$org$ada$server$calc$impl$ChiSquareHelper$$epsilon_$eq(1.0E-100);
    }
}

