/*
 * Decompiled with CFR 0.152.
 */
package org.ada.server.services.importers;

import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.stream.ActorMaterializer;
import akka.stream.ActorMaterializer$;
import akka.stream.Materializer;
import com.fasterxml.jackson.core.JsonParseException;
import com.google.inject.assistedinject.Assisted;
import javax.inject.Inject;
import org.ada.server.dataaccess.JsonUtil$;
import org.ada.server.models.redcap.ExportField;
import org.ada.server.models.redcap.JsonFormat$;
import org.ada.server.models.redcap.LockRecordResponse;
import org.ada.server.models.redcap.Metadata;
import org.ada.server.services.AdaRestException;
import org.ada.server.services.AdaUnauthorizedAccessRestException;
import org.ada.server.services.importers.RedCapService;
import org.ada.server.services.importers.RedCapService$class;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import play.api.Configuration;
import play.api.http.Writeable$;
import play.api.libs.concurrent.Execution;
import play.api.libs.json.JsArray;
import play.api.libs.json.JsObject;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.ws.WSClient;
import play.api.libs.ws.WSRequest;
import play.api.libs.ws.WSResponse;
import play.api.libs.ws.ahc.AhcWSClient;
import play.api.mvc.Codec$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\tec!B\u0001\u0003\u0011\u0011a!a\u0005*fI\u000e\u000b\u0007oU3sm&\u001cWmV*J[Bd'BA\u0002\u0005\u0003%IW\u000e]8si\u0016\u00148O\u0003\u0002\u0006\r\u0005A1/\u001a:wS\u000e,7O\u0003\u0002\b\u0011\u000511/\u001a:wKJT!!\u0003\u0006\u0002\u0007\u0005$\u0017MC\u0001\f\u0003\ry'oZ\n\u0004\u00015\u0019\u0002C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g\r\u0005\u0002\u0015+5\t!!\u0003\u0002\u0017\u0005\ti!+\u001a3DCB\u001cVM\u001d<jG\u0016D\u0001\u0002\u0007\u0001\u0003\u0006\u0004%IAG\u0001\u0004kJd7\u0001A\u000b\u00027A\u0011Ad\b\b\u0003\u001duI!AH\b\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0013E\u0001\u0004TiJLgn\u001a\u0006\u0003==A\u0001b\t\u0001\u0003\u0002\u0003\u0006IaG\u0001\u0005kJd\u0007\u0005\u0003\u0005&\u0001\t\u0015\r\u0011\"\u0003\u001b\u0003\u0015!xn[3o\u0011!9\u0003A!A!\u0002\u0013Y\u0012A\u0002;pW\u0016t\u0007\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0003\t98\u000f\u0005\u0002,g5\tAF\u0003\u0002*[)\u0011afL\u0001\u0005Y&\u00147O\u0003\u00021c\u0005\u0019\u0011\r]5\u000b\u0003I\nA\u0001\u001d7bs&\u0011A\u0007\f\u0002\t/N\u001bE.[3oi\"Aa\u0007\u0001B\u0001B\u0003%q'A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0003qej\u0011aL\u0005\u0003u=\u0012QbQ8oM&<WO]1uS>t\u0007\"\u0002\u001f\u0001\t\u0003i\u0014A\u0002\u001fj]&$h\bF\u0003?\u007f=\u00136\u000b\u0005\u0002\u0015\u0001!)\u0001d\u000fa\u00017!\"q(Q'O!\t\u00115*D\u0001D\u0015\t!U)\u0001\bbgNL7\u000f^3eS:TWm\u0019;\u000b\u0005\u0019;\u0015AB5oU\u0016\u001cGO\u0003\u0002I\u0013\u00061qm\\8hY\u0016T\u0011AS\u0001\u0004G>l\u0017B\u0001'D\u0005!\t5o]5ti\u0016$\u0017!\u0002<bYV,\u0017%\u0001\r\t\u000b\u0015Z\u0004\u0019A\u000e)\t=\u000bU*U\u0011\u0002K!)\u0011f\u000fa\u0001U!)ag\u000fa\u0001o!\u00121(\u0016\t\u0003-jk\u0011a\u0016\u0006\u0003\rbS\u0011!W\u0001\u0006U\u00064\u0018\r_\u0005\u00037^\u0013a!\u00138kK\u000e$\bbB/\u0001\u0005\u0004%IAX\u0001\bi&lWm\\;u+\u0005y\u0006C\u0001\ba\u0013\t\twB\u0001\u0003M_:<\u0007BB2\u0001A\u0003%q,\u0001\u0005uS6,w.\u001e;!\u0011\u001d)\u0007A1A\u0005\n\u0019\fQc\u0019:fCR,WK\\:fGV\u0014X\rZ\"mS\u0016tG/F\u0001h!\tq\u0001.\u0003\u0002j\u001f\t9!i\\8mK\u0006t\u0007BB6\u0001A\u0003%q-\u0001\fde\u0016\fG/Z+og\u0016\u001cWO]3e\u00072LWM\u001c;!\u0011\u001di\u0007A1A\u0005\n9\f\u0001b^:DY&,g\u000e^\u000b\u0002U!1\u0001\u000f\u0001Q\u0001\n)\n\u0011b^:DY&,g\u000e\u001e\u0011\t\u000fI\u0004!\u0019!C\u0005g\u0006\u0019!/Z9\u0016\u0003Q\u0004\"aK;\n\u0005Yd#!C,T%\u0016\fX/Z:u\u0011\u0019A\b\u0001)A\u0005i\u0006!!/Z9!\u0011\u001dQ\bA1A\u0005\nm\fqBY1tKJ+\u0017/^3ti\u0012\u000bG/Y\u000b\u0002yB9Q0!\u0002\u0002\n\u0005%Q\"\u0001@\u000b\u0007}\f\t!A\u0005j[6,H/\u00192mK*\u0019\u00111A\b\u0002\u0015\r|G\u000e\\3di&|g.C\u0002\u0002\by\u00141!T1q!\u0011\tY!!\u0006\u000e\u0005\u00055!\u0002BA\b\u0003#\tA\u0001\\1oO*\u0011\u00111C\u0001\u0005U\u00064\u0018-C\u0002!\u0003\u001bAq!!\u0007\u0001A\u0003%A0\u0001\tcCN,'+Z9vKN$H)\u0019;bA!9\u0011Q\u0004\u0001\u0005\n\u0005}\u0011!\u0004:fG>\u0014HMU3rk\u0016\u001cH\u000fF\u0002}\u0003CA!\"a\t\u0002\u001cA\u0005\t\u0019AA\u0013\u0003\u0019)g/\u001a8ugB)\u0011qEA\u001c79!\u0011\u0011FA\u001a\u001d\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u00183\u00051AH]8pizJ\u0011\u0001E\u0005\u0004\u0003ky\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003s\tYDA\u0002TKFT1!!\u000e\u0010\u0011!\ty\u0004\u0001b\u0001\n\u0013Y\u0018aE7fi\u0006$\u0017\r^1SKF,Xm\u001d;ECR\f\u0007bBA\"\u0001\u0001\u0006I\u0001`\u0001\u0015[\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u0012\u000bG/\u0019\u0011\t\u0011\u0005\u001d\u0003A1A\u0005\nm\fQCZ5fY\u0012t\u0015-\\3t%\u0016\fX/Z:u\t\u0006$\u0018\rC\u0004\u0002L\u0001\u0001\u000b\u0011\u0002?\u0002-\u0019LW\r\u001c3OC6,7OU3rk\u0016\u001cH\u000fR1uC\u0002Bq!a\u0014\u0001\t\u0003\n\t&\u0001\bmSN$\u0018\t\u001c7SK\u000e|'\u000fZ:\u0016\u0005\u0005M\u0003CBA+\u00037\ny&\u0004\u0002\u0002X)\u0019\u0011\u0011L\b\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002^\u0005]#A\u0002$viV\u0014X\r\u0005\u0004\u0002(\u0005]\u0012\u0011\r\t\u0005\u0003G\nI'\u0004\u0002\u0002f)\u0019\u0011qM\u0017\u0002\t)\u001cxN\\\u0005\u0005\u0003W\n)G\u0001\u0005Kg>\u0013'.Z2u\u0011\u001d\ty\u0007\u0001C!\u0003c\n\u0001\u0003\\5ti\u00163XM\u001c;SK\u000e|'\u000fZ:\u0015\t\u0005M\u00131\u000f\u0005\t\u0003G\ti\u00071\u0001\u0002&!9\u0011q\u000f\u0001\u0005B\u0005e\u0014!\u00047jgRlU\r^1eCR\f7/\u0006\u0002\u0002|A1\u0011QKA.\u0003{\u0002b!a\n\u00028\u0005}\u0004\u0003BAA\u0003\u0017k!!a!\u000b\t\u0005\u0015\u0015qQ\u0001\u0007e\u0016$7-\u00199\u000b\u0007\u0005%e!\u0001\u0004n_\u0012,Gn]\u0005\u0005\u0003\u001b\u000b\u0019I\u0001\u0005NKR\fG-\u0019;b\u0011\u001d\t\t\n\u0001C!\u0003'\u000b\u0001\u0003\\5ti\u0016C\bo\u001c:u\r&,G\u000eZ:\u0016\u0005\u0005U\u0005CBA+\u00037\n9\n\u0005\u0004\u0002(\u0005]\u0012\u0011\u0014\t\u0005\u0003\u0003\u000bY*\u0003\u0003\u0002\u001e\u0006\r%aC#ya>\u0014HOR5fY\u0012Dq!!)\u0001\t\u0003\n\u0019+\u0001\u0007d_VtGOU3d_J$7/\u0006\u0002\u0002&B1\u0011QKA.\u0003O\u00032ADAU\u0013\r\tYk\u0004\u0002\u0004\u0013:$\bbBAX\u0001\u0011\u0005\u0013\u0011W\u0001\nO\u0016$(+Z2pe\u0012$B!a-\u0002<B1\u0011QKA.\u0003k\u0003b!a.\u0002:\u0006\u0005TBAA\u0001\u0013\u0011\tI$!\u0001\t\u000f\u0005u\u0016Q\u0016a\u00017\u0005\u0011\u0011\u000e\u001a\u0005\b\u0003\u0003\u0004A\u0011IAb\u0003-9W\r^'fi\u0006$\u0017\r^1\u0015\t\u0005M\u0016Q\u0019\u0005\b\u0003{\u000by\f1\u0001\u001c\u0011\u001d\tI\r\u0001C!\u0003\u0017\fabZ3u\u000bb\u0004xN\u001d;GS\u0016dG\r\u0006\u0003\u00024\u00065\u0007bBA_\u0003\u000f\u0004\ra\u0007\u0005\b\u0003#\u0004A\u0011IAj\u0003\u0011awnY6\u0015\u001d\u0005U\u0017q\\Az\u0003o\u0014\tA!\u0002\u0003\fA1\u0011QKA.\u0003/\u0004b!a\n\u00028\u0005e\u0007\u0003BAA\u00037LA!!8\u0002\u0004\n\u0011Bj\\2l%\u0016\u001cwN\u001d3SKN\u0004xN\\:f\u0011!\t\t/a4A\u0002\u0005\r\u0018AB1di&|g\u000e\u0005\u0003\u0002f\u0006-hb\u0001\u000b\u0002h&\u0019\u0011\u0011\u001e\u0002\u0002!I+GmQ1q\u0019>\u001c7.Q2uS>t\u0017\u0002BAw\u0003_\u0014QAV1mk\u0016L1!!=\u0010\u0005-)e.^7fe\u0006$\u0018n\u001c8\t\u000f\u0005U\u0018q\u001aa\u00017\u00051!/Z2pe\u0012D!\"!?\u0002PB\u0005\t\u0019AA~\u0003\u0015)g/\u001a8u!\u0011q\u0011Q`\u000e\n\u0007\u0005}xB\u0001\u0004PaRLwN\u001c\u0005\u000b\u0005\u0007\ty\r%AA\u0002\u0005m\u0018AC5ogR\u0014X/\\3oi\"Q!qAAh!\u0003\u0005\rA!\u0003\u0002\u0011%t7\u000f^1oG\u0016\u0004RADA\u007f\u0003OC!B!\u0004\u0002PB\u0005\t\u0019\u0001B\u0005\u0003%\u0001(o\u001c6fGRLE\rC\u0004\u0003\u0012\u0001!IAa\u0005\u0002\u001dI,hNU3e\u0007\u0006\u0004\u0018+^3ssR1\u00111\u000bB\u000b\u0005;A\u0001Ba\u0006\u0003\u0010\u0001\u0007!\u0011D\u0001\fe\u0016\fX/Z:u\t\u0006$\u0018\rE\u0003\u001d\u00057Y2$C\u0002\u0002\b\u0005B!Ba\b\u0003\u0010A\u0005\t\u0019\u0001B\r\u0003-\tX/\u001a:z!\u0006\u0014\u0018-\\:\t\u000f\t\r\u0002\u0001\"\u0003\u0003&\u0005\u0019\u0002.\u00198eY\u0016,%O]8s%\u0016\u001c\bo\u001c8tKR!!q\u0005B\u0017!\rq!\u0011F\u0005\u0004\u0005Wy!\u0001B+oSRD\u0001Ba\f\u0003\"\u0001\u0007!\u0011G\u0001\te\u0016\u001c\bo\u001c8tKB\u00191Fa\r\n\u0007\tUBF\u0001\u0006X'J+7\u000f]8og\u0016D\u0011B!\u000f\u0001#\u0003%IAa\u000f\u0002/I,7m\u001c:e%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012\nTC\u0001B\u001fU\u0011\t)Ca\u0010,\u0005\t\u0005\u0003\u0003\u0002B\"\u0005\u001bj!A!\u0012\u000b\t\t\u001d#\u0011J\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0013\u0010\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u001f\u0012)EA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011Ba\u0015\u0001#\u0003%IA!\u0016\u00021I,hNU3e\u0007\u0006\u0004\u0018+^3ss\u0012\"WMZ1vYR$#'\u0006\u0002\u0003X)\"!\u0011\u0004B \u0001")
public class RedCapServiceWSImpl
implements RedCapService {
    private final String url;
    private final String token;
    private final long timeout;
    private final boolean createUnsecuredClient;
    private final WSClient wsClient;
    private final WSRequest req;
    private final Map<String, String> baseRequestData;
    private final Map<String, String> metadataRequestData;
    private final Map<String, String> fieldNamesRequestData;

    @Override
    public Option<String> lock$default$3() {
        return RedCapService$class.lock$default$3(this);
    }

    @Override
    public Option<String> lock$default$4() {
        return RedCapService$class.lock$default$4(this);
    }

    @Override
    public Option<Object> lock$default$5() {
        return RedCapService$class.lock$default$5(this);
    }

    @Override
    public Option<Object> lock$default$6() {
        return RedCapService$class.lock$default$6(this);
    }

    private String url() {
        return this.url;
    }

    private String token() {
        return this.token;
    }

    private long timeout() {
        return this.timeout;
    }

    private boolean createUnsecuredClient() {
        return this.createUnsecuredClient;
    }

    private WSClient wsClient() {
        return this.wsClient;
    }

    private WSRequest req() {
        return this.req;
    }

    private Map<String, String> baseRequestData() {
        return this.baseRequestData;
    }

    private Map<String, String> recordRequest(Seq<String> events) {
        Nil$ eventsParam = events.nonEmpty() ? (scala.collection.immutable.Iterable)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"events"), (Object)events.mkString(","))})) : Nil$.MODULE$;
        return this.baseRequestData().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"content"), (Object)"record"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"flat")}))).$plus$plus((GenTraversableOnce)eventsParam);
    }

    private Seq<String> recordRequest$default$1() {
        return Nil$.MODULE$;
    }

    private Map<String, String> metadataRequestData() {
        return this.metadataRequestData;
    }

    private Map<String, String> fieldNamesRequestData() {
        return this.fieldNamesRequestData;
    }

    @Override
    public Future<Seq<JsObject>> listAllRecords() {
        return this.runRedCapQuery(this.recordRequest(this.recordRequest$default$1()), this.runRedCapQuery$default$2());
    }

    @Override
    public Future<Seq<JsObject>> listEventRecords(Seq<String> events) {
        return this.runRedCapQuery(this.recordRequest(events), this.runRedCapQuery$default$2());
    }

    @Override
    public Future<Seq<Metadata>> listMetadatas() {
        return this.runRedCapQuery(this.metadataRequestData(), this.runRedCapQuery$default$2()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Metadata> apply(Seq<JsObject> x$1) {
                return (Seq)x$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Metadata apply(JsObject x$2) {
                        return (Metadata)x$2.as(JsonFormat$.MODULE$.metadataFormat());
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Execution.Implicits$.MODULE$.defaultContext());
    }

    @Override
    public Future<Seq<ExportField>> listExportFields() {
        return this.runRedCapQuery(this.fieldNamesRequestData(), this.runRedCapQuery$default$2()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<ExportField> apply(Seq<JsObject> x$3) {
                return (Seq)x$3.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ExportField apply(JsObject x$4) {
                        return (ExportField)x$4.as(JsonFormat$.MODULE$.exportFieldFormat());
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Execution.Implicits$.MODULE$.defaultContext());
    }

    @Override
    public Future<Object> countRecords() {
        return this.runRedCapQuery(this.recordRequest(this.recordRequest$default$1()), this.runRedCapQuery$default$2()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Seq<JsObject> items) {
                return JsonUtil$.MODULE$.count(items, "", "");
            }
        }, Execution.Implicits$.MODULE$.defaultContext());
    }

    @Override
    public Future<Seq<JsObject>> getRecord(String id) {
        return this.runRedCapQuery(this.recordRequest(this.recordRequest$default$1()), this.runRedCapQuery$default$2()).map((Function1)new Serializable(this, id){
            public static final long serialVersionUID = 0L;
            private final String id$1;

            public final Seq<JsObject> apply(Seq<JsObject> items) {
                return JsonUtil$.MODULE$.findBy(items, this.id$1, "cdisc_dm_usubjd");
            }
            {
                this.id$1 = id$1;
            }
        }, Execution.Implicits$.MODULE$.defaultContext());
    }

    @Override
    public Future<Seq<JsObject>> getMetadata(String id) {
        return this.runRedCapQuery(this.metadataRequestData(), this.runRedCapQuery$default$2()).map((Function1)new Serializable(this, id){
            public static final long serialVersionUID = 0L;
            private final String id$2;

            public final Seq<JsObject> apply(Seq<JsObject> items) {
                return JsonUtil$.MODULE$.findBy(items, this.id$2, "field_name");
            }
            {
                this.id$2 = id$2;
            }
        }, Execution.Implicits$.MODULE$.defaultContext());
    }

    @Override
    public Future<Seq<JsObject>> getExportField(String id) {
        return this.runRedCapQuery(this.fieldNamesRequestData(), this.runRedCapQuery$default$2()).map((Function1)new Serializable(this, id){
            public static final long serialVersionUID = 0L;
            private final String id$3;

            public final Seq<JsObject> apply(Seq<JsObject> items) {
                return JsonUtil$.MODULE$.findBy(items, this.id$3, "export_field_name");
            }
            {
                this.id$3 = id$3;
            }
        }, Execution.Implicits$.MODULE$.defaultContext());
    }

    @Override
    public Future<Seq<LockRecordResponse>> lock(Enumeration.Value action, String record, Option<String> event, Option<String> instrument, Option<Object> instance, Option<Object> projectId) {
        Map requestData = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"token"), (Object)this.token()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"returnFormat"), (Object)"json"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"record"), (Object)record)}))).$plus$plus((GenTraversableOnce)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{event.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String x$5) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"event"), (Object)x$5);
            }
        }), instrument.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String x$6) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"instrument"), (Object)x$6);
            }
        }), instance.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(int x$7) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"instance"), (Object)((Object)BoxesRunTime.boxToInteger((int)x$7)).toString());
            }
        })})).flatten((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple2<String, String>> apply(Option<Tuple2<String, String>> xo) {
                return Option$.MODULE$.option2Iterable(xo);
            }
        })).toMap(Predef$.MODULE$.$conforms()));
        Map queryParams = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NOAUTH"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"module"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prefix"), (Object)"locking_api"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"page"), (Object)action.toString())}))).$plus$plus((GenTraversableOnce)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{projectId.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(int x$8) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pid"), (Object)((Object)BoxesRunTime.boxToInteger((int)x$8)).toString());
            }
        })})).flatten((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple2<String, String>> apply(Option<Tuple2<String, String>> xo) {
                return Option$.MODULE$.option2Iterable(xo);
            }
        })).toMap(Predef$.MODULE$.$conforms()));
        return this.runRedCapQuery((Map<String, String>)requestData, (Map<String, String>)queryParams).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<LockRecordResponse> apply(Seq<JsObject> jsons) {
                return (Seq)jsons.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LockRecordResponse apply(JsObject x$9) {
                        return (LockRecordResponse)x$9.as(JsonFormat$.MODULE$.responseFormat());
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Execution.Implicits$.MODULE$.defaultContext());
    }

    private Future<Seq<JsObject>> runRedCapQuery(Map<String, String> requestData, Map<String, String> queryParams) {
        return this.req().withQueryString(queryParams.toSeq()).post(requestData.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Seq<String>> apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String a = (String)tuple2._1();
                    String b = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)a, (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{b})));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom()), Writeable$.MODULE$.writeableOf_urlEncodedForm(Codec$.MODULE$.utf_8())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RedCapServiceWSImpl $outer;

            public final Seq<JsObject> apply(WSResponse response) {
                try {
                    this.$outer.org$ada$server$services$importers$RedCapServiceWSImpl$$handleErrorResponse(response);
                    return (Seq)response.json().asOpt((Reads)Reads$.MODULE$.JsArrayReads()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Seq<JsObject> apply(JsArray x$10) {
                            return x$10.value();
                        }
                    }).getOrElse((Function0)new Serializable(this, response){
                        public static final long serialVersionUID = 0L;
                        private final WSResponse response$1;

                        public final Nothing$ apply() {
                            throw new AdaRestException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JSON array response expected but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.response$1.body()})));
                        }
                        {
                            this.response$1 = response$1;
                        }
                    });
                }
                catch (JsonParseException jsonParseException) {
                    throw new AdaRestException("Couldn't parse Red Cap JSON response.");
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Execution.Implicits$.MODULE$.defaultContext());
    }

    private Map<String, String> runRedCapQuery$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public void org$ada$server$services$importers$RedCapServiceWSImpl$$handleErrorResponse(WSResponse response) {
        int n = response.status();
        if (n >= 200 && n <= 299) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        boolean bl = 401 == n ? true : 403 == n;
        if (bl) {
            throw new AdaUnauthorizedAccessRestException(new StringBuilder().append(response.status()).append((Object)": Unauthorized access.").toString());
        }
        throw new AdaRestException(new StringBuilder().append(response.status()).append((Object)": ").append((Object)response.statusText()).append((Object)"; ").append((Object)response.body()).toString());
    }

    @Inject
    public RedCapServiceWSImpl(@Assisted(value="url") String url, @Assisted(value="token") String token, WSClient ws, Configuration configuration) {
        WSClient wSClient;
        this.url = url;
        this.token = token;
        RedCapService$class.$init$(this);
        this.timeout = BoxesRunTime.unboxToLong((Object)configuration.getLong("redcap.request.timeout").getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 600000L;
            }
        }));
        this.createUnsecuredClient = BoxesRunTime.unboxToBoolean((Object)configuration.getBoolean("redcap.create_unsecured_client").getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }));
        if (this.createUnsecuredClient()) {
            ActorSystem system = ActorSystem$.MODULE$.apply();
            ActorMaterializer materializer = ActorMaterializer$.MODULE$.apply(ActorMaterializer$.MODULE$.apply$default$1(), ActorMaterializer$.MODULE$.apply$default$2(), (ActorRefFactory)system);
            DefaultAsyncHttpClientConfig.Builder config = new DefaultAsyncHttpClientConfig.Builder();
            config.setAcceptAnyCertificate(true);
            config.setFollowRedirect(true);
            config.setReadTimeout((int)this.timeout());
            wSClient = new AhcWSClient((AsyncHttpClientConfig)config.build(), (Materializer)materializer);
        } else {
            wSClient = ws;
        }
        this.wsClient = wSClient;
        this.req = this.wsClient().url(url).withRequestTimeout((Duration)new package.DurationLong(package$.MODULE$.DurationLong(this.timeout())).millis());
        this.baseRequestData = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"token"), (Object)token), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"format"), (Object)"json")}));
        this.metadataRequestData = this.baseRequestData().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"content"), (Object)"metadata")})));
        this.fieldNamesRequestData = this.baseRequestData().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"content"), (Object)"exportFieldNames")})));
    }
}

