/*
 * Decompiled with CFR 0.152.
 */
package org.ada.server.calc.impl;

import org.ada.server.calc.CommonsMathUtil$;
import org.ada.server.calc.impl.BasicStatsResult;
import org.ada.server.calc.impl.OneWayAnovaHelper;
import org.ada.server.calc.impl.OneWayAnovaResult;
import org.apache.commons.math3.exception.MaxCountExceededException;
import play.api.Logger$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;

public abstract class OneWayAnovaHelper$class {
    public static Option calcAnovaFromStats(OneWayAnovaHelper $this, Traversable statsResults) {
        Traversable anovaInputs = (Traversable)statsResults.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OneWayAnovaHelper $outer;

            public final OneWayAnovaHelper.OneWayAnovaStatsInputAux apply(BasicStatsResult basicStatsResult) {
                return new OneWayAnovaHelper.OneWayAnovaStatsInputAux(this.$outer, basicStatsResult.sum(), basicStatsResult.sqSum(), basicStatsResult.definedCount());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Traversable$.MODULE$.canBuildFrom());
        return $this.calcAnovaSafe((Traversable<OneWayAnovaHelper.OneWayAnovaStatsInputAux>)anovaInputs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Option calcAnovaSafe(OneWayAnovaHelper $this, Traversable groups) {
        None$ none$;
        int totalCount = BoxesRunTime.unboxToInt((Object)((TraversableOnce)groups.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(OneWayAnovaHelper.OneWayAnovaStatsInputAux x$1) {
                return x$1.count();
            }
        }, Traversable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        if (groups.size() > 1 && totalCount - groups.size() > 0) {
            try {
                none$ = OneWayAnovaHelper$class.calcAnova($this, groups);
                return none$;
            }
            catch (MaxCountExceededException maxCountExceededException) {
                Logger$.MODULE$.warn((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max number of iterations reached for a one-way ANOVA test."})).s((Seq)Nil$.MODULE$);
                    }
                });
                none$ = None$.MODULE$;
                return none$;
            }
        } else {
            Logger$.MODULE$.warn((Function0)new Serializable($this, groups){
                public static final long serialVersionUID = 0L;
                private final Traversable groups$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not enough values to perform a one-way ANOVA test for: ", " groups."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.groups$1.size())}));
                }
                {
                    this.groups$1 = groups$1;
                }
            });
            none$ = None$.MODULE$;
            return none$;
        }
    }

    private static Option calcAnova(OneWayAnovaHelper $this, Traversable groups) {
        Some some;
        double mswg;
        OneWayAnovaHelper.OneWayAnovaResultAux resultAux = (OneWayAnovaHelper.OneWayAnovaResultAux)groups.foldLeft((Object)new OneWayAnovaHelper.OneWayAnovaResultAux($this, $this.OneWayAnovaResultAux().apply$default$1(), $this.OneWayAnovaResultAux().apply$default$2(), $this.OneWayAnovaResultAux().apply$default$3(), $this.OneWayAnovaResultAux().apply$default$4(), $this.OneWayAnovaResultAux().apply$default$5()), (Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OneWayAnovaHelper $outer;

            public final OneWayAnovaHelper.OneWayAnovaResultAux apply(OneWayAnovaHelper.OneWayAnovaResultAux x0$2, OneWayAnovaHelper.OneWayAnovaStatsInputAux x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)x0$2, (Object)x1$1);
                if (tuple2 != null) {
                    OneWayAnovaHelper.OneWayAnovaResultAux result = (OneWayAnovaHelper.OneWayAnovaResultAux)tuple2._1();
                    OneWayAnovaHelper.OneWayAnovaStatsInputAux data = (OneWayAnovaHelper.OneWayAnovaStatsInputAux)tuple2._2();
                    double ss = data.sqSum() - data.sum() * data.sum() / (double)data.count();
                    OneWayAnovaHelper.OneWayAnovaResultAux oneWayAnovaResultAux = new OneWayAnovaHelper.OneWayAnovaResultAux(this.$outer, result.sum() + data.sum(), result.sqSum() + data.sqSum(), result.count() + (double)data.count(), result.dfwg() + data.count() - 1, result.sswg() + ss);
                    return oneWayAnovaResultAux;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        double sst = resultAux.sqSum() - resultAux.sum() * resultAux.sum() / resultAux.count();
        int dfbg = groups.size() - 1;
        double msbg = (sst - resultAux.sswg()) / (double)dfbg;
        double FValue = msbg / (mswg = resultAux.sswg() / (double)resultAux.dfwg());
        if (FValue <= 0.0) {
            some = new Some((Object)OneWayAnovaHelper$class.result$1($this, 1.0, resultAux, dfbg, FValue));
        } else {
            Option<BigDecimal> beta = CommonsMathUtil$.MODULE$.regularizedBeta((double)dfbg * FValue / ((double)resultAux.dfwg() + (double)dfbg * FValue), 0.5 * (double)dfbg, 0.5 * (double)resultAux.dfwg(), $this.org$ada$server$calc$impl$OneWayAnovaHelper$$epsilon(), Integer.MAX_VALUE);
            some = beta.map((Function1)new Serializable($this, resultAux, dfbg, FValue){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ OneWayAnovaHelper $outer;
                private final OneWayAnovaHelper.OneWayAnovaResultAux resultAux$1;
                private final int dfbg$1;
                private final double FValue$1;

                public final OneWayAnovaResult apply(BigDecimal beta) {
                    return OneWayAnovaHelper$class.result$1(this.$outer, BigDecimal$.MODULE$.double2bigDecimal(1.0).$minus(beta).doubleValue(), this.resultAux$1, this.dfbg$1, this.FValue$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.resultAux$1 = resultAux$1;
                    this.dfbg$1 = dfbg$1;
                    this.FValue$1 = FValue$1;
                }
            });
        }
        return some;
    }

    public static final OneWayAnovaResult result$1(OneWayAnovaHelper $this, double pValue, OneWayAnovaHelper.OneWayAnovaResultAux resultAux$1, int dfbg$1, double FValue$1) {
        return new OneWayAnovaResult(pValue, FValue$1, dfbg$1, resultAux$1.dfwg());
    }

    public static void $init$(OneWayAnovaHelper $this) {
        $this.org$ada$server$calc$impl$OneWayAnovaHelper$_setter_$org$ada$server$calc$impl$OneWayAnovaHelper$$epsilon_$eq(1.0E-100);
    }
}

