/*
 * Decompiled with CFR 0.152.
 */
package org.ada.server.dataaccess.ignite;

import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;

public class CustomSqlFunctions {
    @QuerySqlFunction
    public static boolean binEquals(BinaryObject binaryObject, Object object) {
        return CustomSqlFunctions.safeEquals(binaryObject.deserialize(), object);
    }

    @QuerySqlFunction
    public static boolean binStringEquals(BinaryObject binaryObject, String string) {
        Object object = binaryObject.deserialize();
        return CustomSqlFunctions.safeEquals(object != null ? object.toString() : object, string);
    }

    @QuerySqlFunction
    public static boolean binNotEquals(BinaryObject binaryObject, Object object) {
        return !CustomSqlFunctions.binEquals(binaryObject, object);
    }

    @QuerySqlFunction
    public static boolean binStringNotEquals(BinaryObject binaryObject, String string) {
        return !CustomSqlFunctions.binStringEquals(binaryObject, string);
    }

    @QuerySqlFunction
    public static boolean binIn(BinaryObject binaryObject, Object ... objectArray) {
        Object object = binaryObject.deserialize();
        for (Object object2 : objectArray) {
            if (!CustomSqlFunctions.safeEquals(object, object2)) continue;
            return true;
        }
        return false;
    }

    @QuerySqlFunction
    public static boolean binStringIn(BinaryObject binaryObject, String ... stringArray) {
        Object object = binaryObject.deserialize();
        for (String string : stringArray) {
            if (!CustomSqlFunctions.safeEquals(object != null ? object.toString() : object, string)) continue;
            return true;
        }
        return false;
    }

    @QuerySqlFunction
    public static boolean binNotIn(BinaryObject binaryObject, Object ... objectArray) {
        return !CustomSqlFunctions.binIn(binaryObject, objectArray);
    }

    @QuerySqlFunction
    public static boolean binStringNotIn(BinaryObject binaryObject, String ... stringArray) {
        return !CustomSqlFunctions.binStringIn(binaryObject, stringArray);
    }

    private static boolean safeEquals(Object object, Object object2) {
        return object == null && object2 == null || object != null && object2 != null && object.equals(object2);
    }
}

