/*
 * Decompiled with CFR 0.152.
 */
package org.ada.server.services.importers;

import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.stream.ActorMaterializer;
import akka.stream.ActorMaterializer$;
import akka.stream.Materializer;
import com.fasterxml.jackson.core.JsonParseException;
import com.google.inject.assistedinject.Assisted;
import javax.inject.Inject;
import org.ada.server.dataaccess.JsonUtil$;
import org.ada.server.models.redcap.Event;
import org.ada.server.models.redcap.ExportField;
import org.ada.server.models.redcap.JsonFormat$;
import org.ada.server.models.redcap.LockRecordResponse;
import org.ada.server.models.redcap.Metadata;
import org.ada.server.services.AdaRestException;
import org.ada.server.services.AdaUnauthorizedAccessRestException;
import org.ada.server.services.importers.RedCapService;
import org.ada.server.services.importers.RedCapService$class;
import org.ada.server.services.importers.RedCapServiceWSImpl$;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import play.api.Configuration;
import play.api.http.Writeable$;
import play.api.libs.concurrent.Execution;
import play.api.libs.json.JsArray;
import play.api.libs.json.JsObject;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.ws.WSClient;
import play.api.libs.ws.WSRequest;
import play.api.libs.ws.WSResponse;
import play.api.libs.ws.ahc.AhcWSClient;
import play.api.mvc.Codec$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\t\rf!B\u0001\u0003\u0011\u0011a!a\u0005*fI\u000e\u000b\u0007oU3sm&\u001cWmV*J[Bd'BA\u0002\u0005\u0003%IW\u000e]8si\u0016\u00148O\u0003\u0002\u0006\r\u0005A1/\u001a:wS\u000e,7O\u0003\u0002\b\u0011\u000511/\u001a:wKJT!!\u0003\u0006\u0002\u0007\u0005$\u0017MC\u0001\f\u0003\ry'oZ\n\u0004\u00015\u0019\u0002C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g\r\u0005\u0002\u0015+5\t!!\u0003\u0002\u0017\u0005\ti!+\u001a3DCB\u001cVM\u001d<jG\u0016D\u0001\u0002\u0007\u0001\u0003\u0006\u0004%IAG\u0001\u0004kJd7\u0001A\u000b\u00027A\u0011Ad\b\b\u0003\u001duI!AH\b\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0013E\u0001\u0004TiJLgn\u001a\u0006\u0003==A\u0001b\t\u0001\u0003\u0002\u0003\u0006IaG\u0001\u0005kJd\u0007\u0005\u0003\u0005&\u0001\t\u0015\r\u0011\"\u0003\u001b\u0003\u0015!xn[3o\u0011!9\u0003A!A!\u0002\u0013Y\u0012A\u0002;pW\u0016t\u0007\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0003\t98\u000f\u0005\u0002,g5\tAF\u0003\u0002*[)\u0011afL\u0001\u0005Y&\u00147O\u0003\u00021c\u0005\u0019\u0011\r]5\u000b\u0003I\nA\u0001\u001d7bs&\u0011A\u0007\f\u0002\t/N\u001bE.[3oi\"Aa\u0007\u0001B\u0001B\u0003%q'A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0003qej\u0011aL\u0005\u0003u=\u0012QbQ8oM&<WO]1uS>t\u0007\"\u0002\u001f\u0001\t\u0003i\u0014A\u0002\u001fj]&$h\bF\u0003?\u007f=\u00136\u000b\u0005\u0002\u0015\u0001!)\u0001d\u000fa\u00017!\"q(Q'O!\t\u00115*D\u0001D\u0015\t!U)\u0001\bbgNL7\u000f^3eS:TWm\u0019;\u000b\u0005\u0019;\u0015AB5oU\u0016\u001cGO\u0003\u0002I\u0013\u00061qm\\8hY\u0016T\u0011AS\u0001\u0004G>l\u0017B\u0001'D\u0005!\t5o]5ti\u0016$\u0017!\u0002<bYV,\u0017%\u0001\r\t\u000b\u0015Z\u0004\u0019A\u000e)\t=\u000bU*U\u0011\u0002K!)\u0011f\u000fa\u0001U!)ag\u000fa\u0001o!\u00121(\u0016\t\u0003-jk\u0011a\u0016\u0006\u0003\rbS\u0011!W\u0001\u0006U\u00064\u0018\r_\u0005\u00037^\u0013a!\u00138kK\u000e$\bbB/\u0001\u0005\u0004%IAX\u0001\bi&lWm\\;u+\u0005y\u0006C\u0001\ba\u0013\t\twB\u0001\u0003M_:<\u0007BB2\u0001A\u0003%q,\u0001\u0005uS6,w.\u001e;!\u0011\u001d)\u0007A1A\u0005\n\u0019\fQc\u0019:fCR,WK\\:fGV\u0014X\rZ\"mS\u0016tG/F\u0001h!\tq\u0001.\u0003\u0002j\u001f\t9!i\\8mK\u0006t\u0007BB6\u0001A\u0003%q-\u0001\fde\u0016\fG/Z+og\u0016\u001cWO]3e\u00072LWM\u001c;!\u0011\u001di\u0007A1A\u0005\n9\f\u0001b^:DY&,g\u000e^\u000b\u0002U!1\u0001\u000f\u0001Q\u0001\n)\n\u0011b^:DY&,g\u000e\u001e\u0011\t\u000fI\u0004!\u0019!C\u0005g\u0006\u0019!/Z9\u0016\u0003Q\u0004\"aK;\n\u0005Yd#!C,T%\u0016\fX/Z:u\u0011\u0019A\b\u0001)A\u0005i\u0006!!/Z9!\u0011\u001dQ\bA1A\u0005\nm\fqBY1tKJ+\u0017/^3ti\u0012\u000bG/Y\u000b\u0002yB9Q0!\u0002\u0002\n\u0005%Q\"\u0001@\u000b\u0007}\f\t!A\u0005j[6,H/\u00192mK*\u0019\u00111A\b\u0002\u0015\r|G\u000e\\3di&|g.C\u0002\u0002\by\u00141!T1q!\u0011\tY!!\u0006\u000e\u0005\u00055!\u0002BA\b\u0003#\tA\u0001\\1oO*\u0011\u00111C\u0001\u0005U\u00064\u0018-C\u0002!\u0003\u001bAq!!\u0007\u0001A\u0003%A0\u0001\tcCN,'+Z9vKN$H)\u0019;bA!9\u0011Q\u0004\u0001\u0005\n\u0005}\u0011!\u0004:fG>\u0014HMU3rk\u0016\u001cH\u000fF\u0002}\u0003CA!\"a\t\u0002\u001cA\u0005\t\u0019AA\u0013\u0003\u0019)g/\u001a8ugB)\u0011qEA\u001c79!\u0011\u0011FA\u001a\u001d\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u00183\u00051AH]8pizJ\u0011\u0001E\u0005\u0004\u0003ky\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003s\tYDA\u0002TKFT1!!\u000e\u0010\u0011!\ty\u0004\u0001b\u0001\n\u0013Y\u0018aE7fi\u0006$\u0017\r^1SKF,Xm\u001d;ECR\f\u0007bBA\"\u0001\u0001\u0006I\u0001`\u0001\u0015[\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u0012\u000bG/\u0019\u0011\t\u0011\u0005\u001d\u0003A1A\u0005\nm\fQCZ5fY\u0012t\u0015-\\3t%\u0016\fX/Z:u\t\u0006$\u0018\rC\u0004\u0002L\u0001\u0001\u000b\u0011\u0002?\u0002-\u0019LW\r\u001c3OC6,7OU3rk\u0016\u001cH\u000fR1uC\u0002B\u0001\"a\u0014\u0001\u0005\u0004%Ia_\u0001\u0012KZ,g\u000e^:SKF,Xm\u001d;ECR\f\u0007bBA*\u0001\u0001\u0006I\u0001`\u0001\u0013KZ,g\u000e^:SKF,Xm\u001d;ECR\f\u0007\u0005C\u0004\u0002X\u0001!\t%!\u0017\u0002\u001d1L7\u000f^!mYJ+7m\u001c:egV\u0011\u00111\f\t\u0007\u0003;\n\u0019'a\u001a\u000e\u0005\u0005}#bAA1\u001f\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005\u0015\u0014q\f\u0002\u0007\rV$XO]3\u0011\r\u0005\u001d\u0012qGA5!\u0011\tY'!\u001d\u000e\u0005\u00055$bAA8[\u0005!!n]8o\u0013\u0011\t\u0019(!\u001c\u0003\u0011)\u001bxJ\u00196fGRDq!a\u001e\u0001\t\u0003\nI(\u0001\tmSN$XI^3oiJ+7m\u001c:egR!\u00111LA>\u0011!\t\u0019#!\u001eA\u0002\u0005\u0015\u0002bBA@\u0001\u0011\u0005\u0013\u0011Q\u0001\u000eY&\u001cH/T3uC\u0012\fG/Y:\u0016\u0005\u0005\r\u0005CBA/\u0003G\n)\t\u0005\u0004\u0002(\u0005]\u0012q\u0011\t\u0005\u0003\u0013\u000b\u0019*\u0004\u0002\u0002\f*!\u0011QRAH\u0003\u0019\u0011X\rZ2ba*\u0019\u0011\u0011\u0013\u0004\u0002\r5|G-\u001a7t\u0013\u0011\t)*a#\u0003\u00115+G/\u00193bi\u0006Dq!!'\u0001\t\u0003\nY*\u0001\tmSN$X\t\u001f9peR4\u0015.\u001a7egV\u0011\u0011Q\u0014\t\u0007\u0003;\n\u0019'a(\u0011\r\u0005\u001d\u0012qGAQ!\u0011\tI)a)\n\t\u0005\u0015\u00161\u0012\u0002\f\u000bb\u0004xN\u001d;GS\u0016dG\rC\u0004\u0002*\u0002!\t%a+\u0002\u00151L7\u000f^#wK:$8/\u0006\u0002\u0002.B1\u0011QLA2\u0003_\u0003b!a\n\u00028\u0005E\u0006\u0003BAE\u0003gKA!!.\u0002\f\n)QI^3oi\"9\u0011\u0011\u0018\u0001\u0005B\u0005m\u0016\u0001D2pk:$(+Z2pe\u0012\u001cXCAA_!\u0019\ti&a\u0019\u0002@B\u0019a\"!1\n\u0007\u0005\rwBA\u0002J]RDC!a.\u0002HB!\u00111BAe\u0013\u0011\tY-!\u0004\u0003\u0015\u0011+\u0007O]3dCR,G\rC\u0004\u0002P\u0002!\t%!5\u0002\u0013\u001d,GOU3d_J$G\u0003BAj\u00037\u0004b!!\u0018\u0002d\u0005U\u0007CBAl\u00033\fI'\u0004\u0002\u0002\u0002%!\u0011\u0011HA\u0001\u0011\u001d\ti.!4A\u0002m\t!!\u001b3)\t\u00055\u0017q\u0019\u0005\b\u0003G\u0004A\u0011IAs\u0003-9W\r^'fi\u0006$\u0017\r^1\u0015\t\u0005M\u0017q\u001d\u0005\b\u0003;\f\t\u000f1\u0001\u001cQ\u0011\t\t/a2\t\u000f\u00055\b\u0001\"\u0011\u0002p\u0006qq-\u001a;FqB|'\u000f\u001e$jK2$G\u0003BAj\u0003cDq!!8\u0002l\u0002\u00071\u0004\u000b\u0003\u0002l\u0006\u001d\u0007\"CA|\u0001\t\u0007I\u0011BA}\u0003aawnY6j]\u001e\u001cUo\u001d;p[\u0016\u0013(o\u001c:IC:$G.Z\u000b\u0003\u0003w\u0004rADA\u007f\u0005\u0003\u00119!C\u0002\u0002\u0000>\u0011q\u0002U1si&\fGNR;oGRLwN\u001c\t\u0004W\t\r\u0011b\u0001B\u0003Y\tQqk\u0015*fgB|gn]3\u0011\u00079\u0011I!C\u0002\u0003\f=\u0011A!\u00168ji\"A!q\u0002\u0001!\u0002\u0013\tY0A\rm_\u000e\\\u0017N\\4DkN$x.\\#se>\u0014\b*\u00198eY\u0016\u0004\u0003b\u0002B\n\u0001\u0011\u0005#QC\u0001\u0005Y>\u001c7\u000e\u0006\b\u0003\u0018\t\u0005\"Q\u0007B\u001d\u0005\u0007\u00129E!\u0014\u0011\r\u0005u\u00131\rB\r!\u0019\t9#a\u000e\u0003\u001cA!\u0011\u0011\u0012B\u000f\u0013\u0011\u0011y\"a#\u0003%1{7m\u001b*fG>\u0014HMU3ta>t7/\u001a\u0005\t\u0005G\u0011\t\u00021\u0001\u0003&\u00051\u0011m\u0019;j_:\u0004BAa\n\u0003.9\u0019AC!\u000b\n\u0007\t-\"!\u0001\tSK\u0012\u001c\u0015\r\u001d'pG.\f5\r^5p]&!!q\u0006B\u0019\u0005\u00151\u0016\r\\;f\u0013\r\u0011\u0019d\u0004\u0002\f\u000b:,X.\u001a:bi&|g\u000eC\u0004\u00038\tE\u0001\u0019A\u000e\u0002\rI,7m\u001c:e\u0011)\u0011YD!\u0005\u0011\u0002\u0003\u0007!QH\u0001\u0006KZ,g\u000e\u001e\t\u0005\u001d\t}2$C\u0002\u0003B=\u0011aa\u00149uS>t\u0007B\u0003B#\u0005#\u0001\n\u00111\u0001\u0003>\u0005Q\u0011N\\:ueVlWM\u001c;\t\u0015\t%#\u0011\u0003I\u0001\u0002\u0004\u0011Y%\u0001\u0005j]N$\u0018M\\2f!\u0015q!qHA`\u0011)\u0011yE!\u0005\u0011\u0002\u0003\u0007!1J\u0001\naJ|'.Z2u\u0013\u0012DqAa\u0015\u0001\t\u0013\u0011)&\u0001\bsk:\u0014V\rZ\"baF+XM]=\u0015\u0011\u0005m#q\u000bB0\u0005GB\u0001B!\u0017\u0003R\u0001\u0007!1L\u0001\fe\u0016\fX/Z:u\t\u0006$\u0018\rE\u0003\u001d\u0005;Z2$C\u0002\u0002\b\u0005B!B!\u0019\u0003RA\u0005\t\u0019\u0001B.\u0003-\tX/\u001a:z!\u0006\u0014\u0018-\\:\t\u0015\t\u0015$\u0011\u000bI\u0001\u0002\u0004\u00119'A\tdkN$x.\\#se>\u0014\b*\u00198eY\u0016\u0004RA\u0004B \u0003wD\u0011Ba\u001b\u0001\u0005\u0004%IA!\u001c\u0002'!\fg\u000e\u001a7f\u000bJ\u0014xN\u001d*fgB|gn]3\u0016\u0005\t=\u0004c\u0002\b\u0003r\t\u0005!qA\u0005\u0004\u0005gz!!\u0003$v]\u000e$\u0018n\u001c82\u0011!\u00119\b\u0001Q\u0001\n\t=\u0014\u0001\u00065b]\u0012dW-\u0012:s_J\u0014Vm\u001d9p]N,\u0007\u0005C\u0005\u0003|\u0001\t\n\u0011\"\u0003\u0003~\u00059\"/Z2pe\u0012\u0014V-];fgR$C-\u001a4bk2$H%M\u000b\u0003\u0005\u007fRC!!\n\u0003\u0002.\u0012!1\u0011\t\u0005\u0005\u000b\u0013y)\u0004\u0002\u0003\b*!!\u0011\u0012BF\u0003%)hn\u00195fG.,GMC\u0002\u0003\u000e>\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\tJa\"\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0003\u0016\u0002\t\n\u0011\"\u0003\u0003\u0018\u0006A\"/\u001e8SK\u0012\u001c\u0015\r])vKJLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\te%\u0006\u0002B.\u0005\u0003C\u0011B!(\u0001#\u0003%IAa(\u00021I,hNU3e\u0007\u0006\u0004\u0018+^3ss\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\"*\"!q\rBA\u0001")
public class RedCapServiceWSImpl
implements RedCapService {
    private final String url;
    private final String token;
    private final long timeout;
    private final boolean createUnsecuredClient;
    private final WSClient wsClient;
    private final WSRequest req;
    private final Map<String, String> baseRequestData;
    private final Map<String, String> metadataRequestData;
    private final Map<String, String> fieldNamesRequestData;
    private final Map<String, String> eventsRequestData;
    private final PartialFunction<WSResponse, BoxedUnit> lockingCustomErrorHandle;
    private final Function1<WSResponse, BoxedUnit> org$ada$server$services$importers$RedCapServiceWSImpl$$handleErrorResponse;

    @Override
    public Option<String> lock$default$3() {
        return RedCapService$class.lock$default$3(this);
    }

    @Override
    public Option<String> lock$default$4() {
        return RedCapService$class.lock$default$4(this);
    }

    @Override
    public Option<Object> lock$default$5() {
        return RedCapService$class.lock$default$5(this);
    }

    @Override
    public Option<Object> lock$default$6() {
        return RedCapService$class.lock$default$6(this);
    }

    private String url() {
        return this.url;
    }

    private String token() {
        return this.token;
    }

    private long timeout() {
        return this.timeout;
    }

    private boolean createUnsecuredClient() {
        return this.createUnsecuredClient;
    }

    private WSClient wsClient() {
        return this.wsClient;
    }

    private WSRequest req() {
        return this.req;
    }

    private Map<String, String> baseRequestData() {
        return this.baseRequestData;
    }

    private Map<String, String> recordRequest(Seq<String> events) {
        Nil$ eventsParam = events.nonEmpty() ? (scala.collection.immutable.Iterable)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"events"), (Object)events.mkString(","))})) : Nil$.MODULE$;
        return this.baseRequestData().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"content"), (Object)"record"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"flat")}))).$plus$plus((GenTraversableOnce)eventsParam);
    }

    private Seq<String> recordRequest$default$1() {
        return Nil$.MODULE$;
    }

    private Map<String, String> metadataRequestData() {
        return this.metadataRequestData;
    }

    private Map<String, String> fieldNamesRequestData() {
        return this.fieldNamesRequestData;
    }

    private Map<String, String> eventsRequestData() {
        return this.eventsRequestData;
    }

    @Override
    public Future<Seq<JsObject>> listAllRecords() {
        return this.runRedCapQuery(this.recordRequest(this.recordRequest$default$1()), this.runRedCapQuery$default$2(), this.runRedCapQuery$default$3());
    }

    @Override
    public Future<Seq<JsObject>> listEventRecords(Seq<String> events) {
        return this.runRedCapQuery(this.recordRequest(events), this.runRedCapQuery$default$2(), this.runRedCapQuery$default$3());
    }

    @Override
    public Future<Seq<Metadata>> listMetadatas() {
        return this.runRedCapQuery(this.metadataRequestData(), this.runRedCapQuery$default$2(), this.runRedCapQuery$default$3()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Metadata> apply(Seq<JsObject> x$1) {
                return (Seq)x$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Metadata apply(JsObject x$2) {
                        return (Metadata)x$2.as(JsonFormat$.MODULE$.metadataFormat());
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Execution.Implicits$.MODULE$.defaultContext());
    }

    @Override
    public Future<Seq<ExportField>> listExportFields() {
        return this.runRedCapQuery(this.fieldNamesRequestData(), this.runRedCapQuery$default$2(), this.runRedCapQuery$default$3()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<ExportField> apply(Seq<JsObject> x$3) {
                return (Seq)x$3.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ExportField apply(JsObject x$4) {
                        return (ExportField)x$4.as(JsonFormat$.MODULE$.exportFieldFormat());
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Execution.Implicits$.MODULE$.defaultContext());
    }

    @Override
    public Future<Seq<Event>> listEvents() {
        return this.runRedCapQuery(this.eventsRequestData(), this.runRedCapQuery$default$2(), this.runRedCapQuery$default$3()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Event> apply(Seq<JsObject> x$5) {
                return (Seq)x$5.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Event apply(JsObject x$6) {
                        return (Event)x$6.as(JsonFormat$.MODULE$.eventFormat());
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Execution.Implicits$.MODULE$.defaultContext());
    }

    @Override
    @Deprecated
    public Future<Object> countRecords() {
        return this.runRedCapQuery(this.recordRequest(this.recordRequest$default$1()), this.runRedCapQuery$default$2(), this.runRedCapQuery$default$3()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Seq<JsObject> items) {
                return JsonUtil$.MODULE$.count(items, "", "");
            }
        }, Execution.Implicits$.MODULE$.defaultContext());
    }

    @Override
    @Deprecated
    public Future<Seq<JsObject>> getRecord(String id) {
        return this.runRedCapQuery(this.recordRequest(this.recordRequest$default$1()), this.runRedCapQuery$default$2(), this.runRedCapQuery$default$3()).map((Function1)new Serializable(this, id){
            public static final long serialVersionUID = 0L;
            private final String id$1;

            public final Seq<JsObject> apply(Seq<JsObject> items) {
                return JsonUtil$.MODULE$.findBy(items, this.id$1, "cdisc_dm_usubjd");
            }
            {
                this.id$1 = id$1;
            }
        }, Execution.Implicits$.MODULE$.defaultContext());
    }

    @Override
    @Deprecated
    public Future<Seq<JsObject>> getMetadata(String id) {
        return this.runRedCapQuery(this.metadataRequestData(), this.runRedCapQuery$default$2(), this.runRedCapQuery$default$3()).map((Function1)new Serializable(this, id){
            public static final long serialVersionUID = 0L;
            private final String id$2;

            public final Seq<JsObject> apply(Seq<JsObject> items) {
                return JsonUtil$.MODULE$.findBy(items, this.id$2, "field_name");
            }
            {
                this.id$2 = id$2;
            }
        }, Execution.Implicits$.MODULE$.defaultContext());
    }

    @Override
    @Deprecated
    public Future<Seq<JsObject>> getExportField(String id) {
        return this.runRedCapQuery(this.fieldNamesRequestData(), this.runRedCapQuery$default$2(), this.runRedCapQuery$default$3()).map((Function1)new Serializable(this, id){
            public static final long serialVersionUID = 0L;
            private final String id$3;

            public final Seq<JsObject> apply(Seq<JsObject> items) {
                return JsonUtil$.MODULE$.findBy(items, this.id$3, "export_field_name");
            }
            {
                this.id$3 = id$3;
            }
        }, Execution.Implicits$.MODULE$.defaultContext());
    }

    private PartialFunction<WSResponse, BoxedUnit> lockingCustomErrorHandle() {
        return this.lockingCustomErrorHandle;
    }

    @Override
    public Future<Seq<LockRecordResponse>> lock(Enumeration.Value action, String record, Option<String> event, Option<String> instrument, Option<Object> instance, Option<Object> projectId) {
        Map requestData = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"token"), (Object)this.token()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"returnFormat"), (Object)"json"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"record"), (Object)record)}))).$plus$plus((GenTraversableOnce)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{event.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String x$7) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"event"), (Object)x$7);
            }
        }), instrument.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String x$8) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"instrument"), (Object)x$8);
            }
        }), instance.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(int x$9) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"instance"), (Object)((Object)BoxesRunTime.boxToInteger((int)x$9)).toString());
            }
        })})).flatten((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple2<String, String>> apply(Option<Tuple2<String, String>> xo) {
                return Option$.MODULE$.option2Iterable(xo);
            }
        })).toMap(Predef$.MODULE$.$conforms()));
        Map queryParams = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NOAUTH"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"module"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prefix"), (Object)"locking_api"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"page"), (Object)action.toString())}))).$plus$plus((GenTraversableOnce)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{projectId.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(int x$10) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pid"), (Object)((Object)BoxesRunTime.boxToInteger((int)x$10)).toString());
            }
        })})).flatten((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple2<String, String>> apply(Option<Tuple2<String, String>> xo) {
                return Option$.MODULE$.option2Iterable(xo);
            }
        })).toMap(Predef$.MODULE$.$conforms()));
        return this.runRedCapQuery((Map<String, String>)requestData, (Map<String, String>)queryParams, (Option<PartialFunction<WSResponse, BoxedUnit>>)new Some(this.lockingCustomErrorHandle())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<LockRecordResponse> apply(Seq<JsObject> jsons) {
                return (Seq)jsons.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LockRecordResponse apply(JsObject x$11) {
                        return (LockRecordResponse)x$11.as(JsonFormat$.MODULE$.responseFormat());
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Execution.Implicits$.MODULE$.defaultContext());
    }

    private Future<Seq<JsObject>> runRedCapQuery(Map<String, String> requestData, Map<String, String> queryParams, Option<PartialFunction<WSResponse, BoxedUnit>> customErrorHandle) {
        return this.req().withQueryString(queryParams.toSeq()).post(requestData.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Seq<String>> apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String a = (String)tuple2._1();
                    String b = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)a, (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{b})));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom()), Writeable$.MODULE$.writeableOf_urlEncodedForm(Codec$.MODULE$.utf_8())).map((Function1)new Serializable(this, customErrorHandle){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RedCapServiceWSImpl $outer;
            private final Option customErrorHandle$1;

            public final Seq<JsObject> apply(WSResponse response) {
                try {
                    this.customErrorHandle$1.map((Function1)new Serializable(this, response){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$runRedCapQuery$2 $outer;
                        private final WSResponse response$1;

                        public final void apply(PartialFunction<WSResponse, BoxedUnit> customHandle) {
                            if (customHandle.isDefinedAt((Object)this.response$1)) {
                                customHandle.apply((Object)this.response$1);
                            } else {
                                this.$outer.org$ada$server$services$importers$RedCapServiceWSImpl$$anonfun$$$outer().org$ada$server$services$importers$RedCapServiceWSImpl$$handleErrorResponse().apply((Object)this.response$1);
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.response$1 = response$1;
                        }
                    }).getOrElse((Function0)new Serializable(this, response){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$runRedCapQuery$2 $outer;
                        private final WSResponse response$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.org$ada$server$services$importers$RedCapServiceWSImpl$$anonfun$$$outer().org$ada$server$services$importers$RedCapServiceWSImpl$$handleErrorResponse().apply((Object)this.response$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.response$1 = response$1;
                        }
                    });
                    return (Seq)response.json().asOpt((Reads)Reads$.MODULE$.JsArrayReads()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Seq<JsObject> apply(JsArray x$12) {
                            return x$12.value();
                        }
                    }).getOrElse((Function0)new Serializable(this, response){
                        public static final long serialVersionUID = 0L;
                        private final WSResponse response$1;

                        public final Nothing$ apply() {
                            throw new AdaRestException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"JSON array response expected but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.response$1.body()})));
                        }
                        {
                            this.response$1 = response$1;
                        }
                    });
                }
                catch (JsonParseException jsonParseException) {
                    throw new AdaRestException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't parse a Red Cap JSON response due to ", ". Response body: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jsonParseException.getMessage(), response.body()})));
                }
            }

            public /* synthetic */ RedCapServiceWSImpl org$ada$server$services$importers$RedCapServiceWSImpl$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.customErrorHandle$1 = customErrorHandle$1;
            }
        }, Execution.Implicits$.MODULE$.defaultContext());
    }

    private Map<String, String> runRedCapQuery$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    private Option<PartialFunction<WSResponse, BoxedUnit>> runRedCapQuery$default$3() {
        return None$.MODULE$;
    }

    public Function1<WSResponse, BoxedUnit> org$ada$server$services$importers$RedCapServiceWSImpl$$handleErrorResponse() {
        return this.org$ada$server$services$importers$RedCapServiceWSImpl$$handleErrorResponse;
    }

    @Inject
    public RedCapServiceWSImpl(@Assisted(value="url") String url, @Assisted(value="token") String token, WSClient ws, Configuration configuration) {
        WSClient wSClient;
        this.url = url;
        this.token = token;
        RedCapService$class.$init$(this);
        this.timeout = BoxesRunTime.unboxToLong((Object)configuration.getLong("redcap.request.timeout").getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 600000L;
            }
        }));
        this.createUnsecuredClient = BoxesRunTime.unboxToBoolean((Object)configuration.getBoolean("redcap.create_unsecured_client").getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }));
        if (this.createUnsecuredClient()) {
            ActorSystem system = ActorSystem$.MODULE$.apply();
            ActorMaterializer materializer = ActorMaterializer$.MODULE$.apply(ActorMaterializer$.MODULE$.apply$default$1(), ActorMaterializer$.MODULE$.apply$default$2(), (ActorRefFactory)system);
            DefaultAsyncHttpClientConfig.Builder config = new DefaultAsyncHttpClientConfig.Builder();
            config.setAcceptAnyCertificate(true);
            config.setFollowRedirect(true);
            config.setReadTimeout((int)this.timeout());
            wSClient = new AhcWSClient((AsyncHttpClientConfig)config.build(), (Materializer)materializer);
        } else {
            wSClient = ws;
        }
        this.wsClient = wSClient;
        this.req = this.wsClient().url(url).withRequestTimeout((Duration)new package.DurationLong(package$.MODULE$.DurationLong(this.timeout())).millis());
        this.baseRequestData = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"token"), (Object)token), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"format"), (Object)"json")}));
        this.metadataRequestData = this.baseRequestData().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"content"), (Object)"metadata")})));
        this.fieldNamesRequestData = this.baseRequestData().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"content"), (Object)"exportFieldNames")})));
        this.eventsRequestData = this.baseRequestData().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"content"), (Object)"event")})));
        this.lockingCustomErrorHandle = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends WSResponse, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.status() == 400) {
                    int errorStart = A1.body().indexOf("<error>");
                    int errorEnd = A1.body().indexOf("</error>");
                    if (errorStart >= 0 && errorEnd >= 0) {
                        String error2 = A1.body().substring(errorStart + new StringOps(Predef$.MODULE$.augmentString("<error>")).size(), errorEnd);
                        throw new AdaRestException(error2);
                    }
                    throw new AdaRestException(new StringBuilder().append(A1.status()).append((Object)": ").append((Object)A1.statusText()).append((Object)"; ").append((Object)A1.body()).toString());
                }
                Object object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(WSResponse x1) {
                WSResponse wSResponse = x1;
                boolean bl = wSResponse.status() == 400;
                return bl;
            }
        };
        this.org$ada$server$services$importers$RedCapServiceWSImpl$$handleErrorResponse = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(WSResponse response) {
                int n = response.status();
                if (n >= 200 && n <= 299) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                boolean bl = 401 == n ? true : 403 == n;
                if (bl) {
                    throw new AdaUnauthorizedAccessRestException(new StringBuilder().append(response.status()).append((Object)": Unauthorized access.").toString());
                }
                throw new AdaRestException(new StringBuilder().append(response.status()).append((Object)": ").append((Object)response.statusText()).append((Object)"; ").append((Object)response.body()).toString());
            }
        };
    }
}

